/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import processing.core.PApplet;
import renderer.Render2D;
import util.math2d.Point2D;

public class HexRender2D
extends Render2D {
    final double theta = 1.0471975511965976;
    final double q = Math.sin(0.5235987755982988);

    public HexRender2D(PApplet p, int dimensionsX, int dimensionsY) {
        this(p, dimensionsX, dimensionsY, 1, 1);
    }

    public HexRender2D(PApplet p, int dimensionsX, int dimensionsY, int imgSizeX, int imgSizeY) {
        super(p, dimensionsX, dimensionsY, imgSizeX, imgSizeY);
    }

    @Override
    public void renderTile(Point2D point, int color) {
        this.renderTile((int)point.x, (int)point.y, color);
    }

    @Override
    public void renderBackground(int color) {
    }

    @Override
    public void renderGrid(int lineColor) {
        this.pg.beginDraw();
        this.pg.stroke(lineColor);
        this.pg.noFill();
        float diameter = this.gridSizeX / 2;
        for (int x = 0; x < this.dimensionsX; ++x) {
            for (int y = 0; y < this.dimensionsY; ++y) {
                Point2D c = this.getCenter(x, y);
                this.pg.beginShape();
                for (int i = 0; i < 6; ++i) {
                    this.pg.vertex((float)(c.x + (double)diameter * Math.cos((double)i * 1.0471975511965976)), (float)(c.y + (double)diameter * Math.sin((double)i * 1.0471975511965976)));
                }
                this.pg.endShape(2);
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public Point2D getCenter(int x, int y) {
        float xOffset = (float)((double)this.gridSizeX * (1.0 + Math.sin(0.5235987755982988)));
        float yOffset = (float)((double)this.gridSizeY * Math.cos(0.5235987755982988));
        float p_x = x % 2 == 0 ? (float)(x / 2) + 0.5f : (float)(x / 2) + 1.0f;
        float p_y = x % 2 == 0 ? (float)y + 0.5f : (float)y + 1.0f;
        return new Point2D(p_x * xOffset, p_y * yOffset);
    }

    @Override
    public void renderTile(int x, int y, int color) {
        this.pg.beginDraw();
        this.pg.noStroke();
        this.pg.fill(color);
        this.pg.beginShape();
        Point2D c = this.getCenter(x, y);
        float diameter = this.gridSizeX / 2;
        for (int i = 0; i < 6; ++i) {
            this.pg.vertex((float)(c.x + (double)diameter * Math.cos((double)i * 1.0471975511965976)), (float)(c.y + (double)diameter * Math.sin((double)i * 1.0471975511965976)));
        }
        this.pg.endShape(2);
        this.pg.noFill();
        this.pg.endDraw();
    }
}

