/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.util.Vector;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import util.math2d.Point2D;

public class Render2D {
    PApplet p;
    PGraphics pg;
    int dimensionsX;
    int dimensionsY;
    int gridSizeX;
    int gridSizeY;

    public Render2D(PApplet p, int dimensionsX, int dimensionsY) {
        this(p, dimensionsX, dimensionsY, dimensionsX, dimensionsY);
    }

    public Render2D(PApplet p, int dimensionsX, int dimensionsY, int imgSizeX, int imgSizeY) {
        this.p = p;
        this.dimensionsX = dimensionsX;
        this.dimensionsY = dimensionsY;
        this.gridSizeY = this.gridSizeX = (int)Math.max(1.0, Math.floor(Math.min(imgSizeX / dimensionsX, imgSizeX / dimensionsY)));
        this.resetGraphics();
    }

    public void setGridSize(int gridSize) {
        this.gridSizeX = gridSize;
        this.gridSizeY = gridSize;
        this.resetGraphics();
    }

    public void setGridSize(int gridSizeX, int gridSizeY) {
        this.gridSizeX = gridSizeX;
        this.gridSizeY = gridSizeY;
        this.resetGraphics();
    }

    public int getGridSizeX() {
        return this.gridSizeX;
    }

    public int getGridSizeY() {
        return this.gridSizeY;
    }

    public int getDimensionsX() {
        return this.dimensionsX;
    }

    public int getDimensionsY() {
        return this.dimensionsY;
    }

    public PImage getImage() {
        return this.pg;
    }

    public PGraphics getGraphics() {
        return this.pg;
    }

    public void resetGraphics() {
        this.pg = this.p.createGraphics(this.dimensionsX * this.gridSizeX, this.dimensionsY * this.gridSizeY, "processing.core.PGraphics2D");
        this.pg.beginDraw();
        this.pg.noStroke();
        this.pg.noFill();
        this.pg.endDraw();
    }

    public void renderBackground(int color) {
        this.pg.beginDraw();
        for (int x = 0; x < this.dimensionsX * this.gridSizeX; ++x) {
            for (int y = 0; y < this.dimensionsY * this.gridSizeY; ++y) {
                this.pg.set(x, y, color);
            }
        }
        this.pg.endDraw();
    }

    public void renderTiles(boolean[][] pixels, int color) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!pixels[x][y]) continue;
                this.pg.fill(color);
                this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderTiles(boolean[][] pixels, int colorOn, int colorOff) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (pixels[x][y]) {
                    this.pg.fill(colorOn);
                } else {
                    this.pg.fill(colorOff);
                }
                this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderTiles(float[][] pixels, int color) {
        this.renderTiles(pixels, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color), 0.0f));
    }

    public void renderTiles(float[][] pixels, int color, boolean fillZero) {
        this.renderTiles(pixels, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color), 0.0f), fillZero);
    }

    public void renderTiles(float[][] pixels, int colorOn, int colorOff) {
        this.renderTiles(pixels, colorOn, colorOff, false);
    }

    public void renderTiles(float[][] pixels, int colorOn, int colorOff, boolean fillZero) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                float temp = pixels[x][y];
                if (temp <= 0.0f) {
                    if (!fillZero) continue;
                    this.pg.fill(colorOff);
                    this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                    this.pg.noFill();
                    continue;
                }
                if (temp >= 1.0f) {
                    this.pg.fill(colorOn);
                    this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                    this.pg.noFill();
                    continue;
                }
                int c = this.pg.lerpColor(colorOff, colorOn, temp);
                this.pg.fill(c);
                this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderCustomGrid(int customDimensionsX, int customDimensionsY) {
        this.renderCustomGrid(120, customDimensionsX, customDimensionsY);
    }

    public void renderCustomGrid(int lineColor, int customDimensionsX, int customDimensionsY) {
        this.pg.beginDraw();
        this.pg.stroke(lineColor);
        int customGridSizeX = this.dimensionsX * this.gridSizeX / customDimensionsX;
        int customGridSizeY = this.dimensionsY * this.gridSizeY / customDimensionsY;
        for (int x = 0; x <= customDimensionsX + 1; ++x) {
            this.pg.line(x * customGridSizeX, 0.0f, x * customGridSizeX, customDimensionsY * customGridSizeY);
        }
        for (int y = 0; y <= customDimensionsY + 1; ++y) {
            this.pg.line(0.0f, y * customGridSizeY, customDimensionsX * customGridSizeX, y * customGridSizeY);
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderGrid() {
        this.renderGrid(120);
    }

    public void renderGrid(int lineColor) {
        this.pg.beginDraw();
        this.pg.stroke(lineColor);
        for (int x = 0; x <= this.dimensionsX + 1; ++x) {
            this.pg.line(x * this.gridSizeX, 0.0f, x * this.gridSizeX, this.dimensionsY * this.gridSizeY);
        }
        for (int y = 0; y <= this.dimensionsY + 1; ++y) {
            this.pg.line(0.0f, y * this.gridSizeY, this.dimensionsX * this.gridSizeX, y * this.gridSizeY);
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderPath(Vector<Point2D> path, int color, float lineWidth) {
        this.renderPath(path, color, lineWidth, 0);
    }

    public void renderPath(Vector<Point2D> path, int color, float lineWidth, int offset) {
        if (path.size() < 2) {
            return;
        }
        this.pg.beginDraw();
        this.pg.stroke(color);
        this.pg.strokeWeight(lineWidth);
        for (int i = 1; i < path.size(); ++i) {
            Point2D curr = path.get(i);
            Point2D prev = path.get(i - 1);
            this.pg.line((int)((curr.x + 0.5) * (double)this.gridSizeX), (int)((curr.y + 0.5) * (double)this.gridSizeY), (int)((prev.x + 0.5) * (double)this.gridSizeX), (int)((prev.y + 0.5) * (double)this.gridSizeY));
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderMidpoint(Point2D point, int color, int diameter) {
        this.renderMidpoint((int)point.x, (int)point.y, color, diameter, false);
    }

    public void renderMidpoint(int x, int y, int color, int diameter) {
        this.renderMidpoint(x, y, color, diameter, false);
    }

    public void renderMidpoint(Point2D point, int color, int diameter, boolean outline) {
        this.renderMidpoint((int)point.x, (int)point.y, color, diameter, outline);
    }

    public void renderMidpoint(int x, int y, int color, int diameter, boolean outline) {
        this.pg.beginDraw();
        if (outline) {
            this.pg.stroke(0);
            this.pg.strokeWeight(1.0f);
        } else {
            this.pg.noStroke();
        }
        this.pg.fill(color);
        this.pg.ellipse(((float)x + 0.5f) * (float)this.gridSizeX, ((float)y + 0.5f) * (float)this.gridSizeY, diameter, diameter);
        this.pg.noFill();
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderMidrect(Point2D point, int color, int width, int height) {
        this.renderMidrect((int)point.x, (int)point.y, color, width, height, false);
    }

    public void renderMidrect(int x, int y, int color, int width, int height) {
        this.renderMidrect(x, y, color, width, height, false);
    }

    public void renderMidrect(Point2D point, int color, int width, int height, boolean outline) {
        this.renderMidrect((int)point.x, (int)point.y, color, width, height, outline);
    }

    public void renderMidrect(int x, int y, int color, int width, int height, boolean outline) {
        this.pg.beginDraw();
        if (outline) {
            this.pg.stroke(0);
            this.pg.strokeWeight(1.0f);
        } else {
            this.pg.noStroke();
        }
        this.pg.fill(color);
        this.pg.rect(((float)x + 0.5f) * (float)this.gridSizeX - (float)(width / 2), ((float)y + 0.5f) * (float)this.gridSizeY - (float)(height / 2), width, height);
        this.pg.noFill();
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderMidtriangle(Point2D point, int color, int width, int height) {
        this.renderMidtriangle((int)point.x, (int)point.y, color, width, height, false);
    }

    public void renderMidtriangle(int x, int y, int color, int width, int height) {
        this.renderMidtriangle(x, y, color, width, height, false);
    }

    public void renderMidtriangle(Point2D point, int color, int width, int height, boolean outline) {
        this.renderMidtriangle((int)point.x, (int)point.y, color, width, height, outline);
    }

    public void renderMidtriangle(int x, int y, int color, int width, int height, boolean outline) {
        this.pg.beginDraw();
        if (outline) {
            this.pg.stroke(0);
            this.pg.strokeWeight(1.0f);
        } else {
            this.pg.noStroke();
        }
        this.pg.fill(color);
        this.pg.triangle(((float)x + 0.5f) * (float)this.gridSizeX - (float)(width / 2), ((float)y + 0.5f) * (float)this.gridSizeY + (float)(height / 2), ((float)x + 0.5f) * (float)this.gridSizeX, ((float)y + 0.5f) * (float)this.gridSizeY - (float)(height / 2), ((float)x + 0.5f) * (float)this.gridSizeX + (float)(width / 2), ((float)y + 0.5f) * (float)this.gridSizeY + (float)(height / 2));
        this.pg.noFill();
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderMidNgon(int x, int y, int color, int width, int points, boolean outline) {
        double angleInc = Math.PI * 2 / (double)points;
        float radius = (float)width / 2.0f;
        this.pg.beginDraw();
        if (outline) {
            this.pg.stroke(0);
            this.pg.strokeWeight(1.0f);
        } else {
            this.pg.noStroke();
        }
        this.pg.fill(color);
        this.pg.beginShape();
        double currAngle = 0.0;
        for (int i = 0; i < points; ++i) {
            this.pg.vertex(((float)x + 0.5f) * (float)this.gridSizeX - (float)((int)((double)radius * Math.sin(currAngle))), ((float)y + 0.5f) * (float)this.gridSizeY - (float)((int)((double)radius * Math.cos(currAngle))));
            currAngle += angleInc;
        }
        this.pg.endShape(2);
        this.pg.noFill();
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderTile(Point2D point, int color) {
        this.renderTile((int)point.x, (int)point.y, color);
    }

    public void renderTile(int x, int y, int color) {
        this.pg.beginDraw();
        this.pg.fill(color);
        this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
        this.pg.noFill();
        this.pg.endDraw();
    }

    public void renderLine(Point2D start, Point2D end, int color, float lineWidth) {
        this.pg.beginDraw();
        this.pg.stroke(color);
        this.pg.strokeWeight(lineWidth);
        this.pg.line((int)((start.x + 0.5) * (double)this.gridSizeX), (int)((start.y + 0.5) * (double)this.gridSizeY), (int)((end.x + 0.5) * (double)this.gridSizeX), (int)((end.y + 0.5) * (double)this.gridSizeY));
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderLine(int startX, int startY, int endX, int endY, int color, float lineWidth) {
        this.pg.beginDraw();
        this.pg.stroke(color);
        this.pg.strokeWeight(lineWidth);
        this.pg.line((int)(((float)startX + 0.5f) * (float)this.gridSizeX), (int)(((float)startY + 0.5f) * (float)this.gridSizeY), (int)(((float)endX + 0.5f) * (float)this.gridSizeX), (int)(((float)endY + 0.5f) * (float)this.gridSizeY));
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderSprite(PImage sprite, Point2D point, int sizeX, int sizeY) {
        this.renderSprite(sprite, (int)point.x, (int)point.y, sizeX, sizeY, false);
    }

    public void renderSprite(PImage sprite, int centerX, int centerY, int sizeX, int sizeY) {
        this.renderSprite(sprite, centerX, centerY, sizeX, sizeY, false);
    }

    public void renderSprite(PImage sprite, Point2D point, int sizeX, int sizeY, boolean smoothing) {
        this.renderSprite(sprite, (int)point.x, (int)point.y, sizeX, sizeY, smoothing);
    }

    public void renderSprite(PImage sprite, int centerX, int centerY, int sizeX, int sizeY, boolean smoothing) {
        this.pg.beginDraw();
        if (!smoothing) {
            this.pg.noSmooth();
        }
        this.pg.image(sprite, (int)(((float)centerX + 0.5f - (float)(sizeX / 2)) * (float)this.gridSizeX), (int)(((float)centerY + 0.5f - (float)(sizeY / 2)) * (float)this.gridSizeY), sizeX, sizeY);
        this.pg.smooth();
        this.pg.endDraw();
    }

    public void renderSprite(PImage sprite, Point2D point, int sizeX, int sizeY, double rotation) {
        this.renderSprite(sprite, (int)point.x, (int)point.y, sizeX, sizeY, rotation, false);
    }

    public void renderSprite(PImage sprite, int centerX, int centerY, int sizeX, int sizeY, double rotation) {
        this.renderSprite(sprite, centerX, centerY, sizeX, sizeY, rotation, false);
    }

    public void renderSprite(PImage sprite, Point2D point, int sizeX, int sizeY, double rotation, boolean smoothing) {
        this.renderSprite(sprite, (int)point.x, (int)point.y, sizeX, sizeY, rotation, smoothing);
    }

    public void renderSprite(PImage sprite, int centerX, int centerY, int sizeX, int sizeY, double rotation, boolean smoothing) {
        this.pg.beginDraw();
        this.pg.pushMatrix();
        if (!smoothing) {
            this.pg.noSmooth();
        }
        this.pg.translate(((float)centerX + 0.5f) * (float)this.gridSizeX, ((float)centerY + 0.5f) * (float)this.gridSizeY);
        this.pg.rotate((float)rotation);
        this.pg.image(sprite, -sizeX * this.gridSizeX / 2, -sizeY * this.gridSizeY / 2, sizeX, sizeY);
        this.pg.smooth();
        this.pg.pushMatrix();
        this.pg.endDraw();
    }

    public void renderPattern(boolean[][] pattern, Point2D point, int color) {
        this.renderPattern(pattern, (int)point.x, (int)point.y, color);
    }

    public void renderPattern(boolean[][] pattern, int centerX, int centerY, int color) {
        this.pg.beginDraw();
        int startX = centerX - pattern.length / 2;
        int startY = centerY - pattern[0].length / 2;
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[x].length; ++y) {
                if (!pattern[x][y]) continue;
                this.pg.fill(color);
                this.pg.rect((x + startX) * this.gridSizeX, (y + startY) * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderMaskedTiles(float[][] pixels, boolean[][] mask, int color) {
        this.renderMaskedTiles(pixels, mask, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color), 0.0f));
    }

    public void renderMaskedTiles(float[][] pixels, boolean[][] mask, int color, boolean fillZero) {
        this.renderMaskedTiles(pixels, mask, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color), 0.0f), fillZero);
    }

    public void renderMaskedTiles(float[][] pixels, boolean[][] mask, int colorOn, int colorOff) {
        this.renderMaskedTiles(pixels, mask, colorOn, colorOff, false);
    }

    public void renderMaskedTiles(float[][] pixels, boolean[][] mask, int colorOn, int colorOff, boolean fillZero) {
        if (pixels.length != mask.length || pixels[0].length != mask[0].length) {
            return;
        }
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                float temp = pixels[x][y];
                if (!mask[x][y] || temp <= 0.0f) {
                    if (!fillZero) continue;
                    this.pg.fill(colorOff);
                    this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                    this.pg.noFill();
                    continue;
                }
                if (mask[x][y] && temp >= 1.0f) {
                    this.pg.fill(colorOn);
                    this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                    this.pg.noFill();
                    continue;
                }
                if (!mask[x][y]) continue;
                int c = this.pg.lerpColor(colorOff, colorOn, temp);
                this.pg.fill(c);
                this.pg.rect(x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }
}

