/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.util.Vector;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import util.math2d.Point2D;

public class Render3D {
    PApplet p;
    PGraphics pg;
    int dimensionsX;
    int dimensionsY;
    int dimensionsZ;
    int gridSizeX;
    int gridSizeY;
    int gridSizeZ;
    int offsetX;
    int offsetY;
    float gridTilt;
    float inverseTilt;

    public Render3D(PApplet p, int dimensionsX, int dimensionsY, int dimensionsZ, int imgSizeX, int imgSizeY, float gridTilt) {
        this.p = p;
        this.gridTilt = gridTilt;
        this.inverseTilt = (float)Math.sqrt(1.0 - Math.pow(gridTilt, 2.0));
        int gridSize = (int)Math.floor((double)imgSizeX / (double)((float)dimensionsX + gridTilt * (float)dimensionsY));
        gridSize = (int)Math.floor((double)imgSizeY / (double)(this.inverseTilt * (float)dimensionsY + (float)dimensionsZ));
        this.dimensionsX = dimensionsX;
        this.dimensionsY = dimensionsY;
        this.dimensionsZ = dimensionsZ;
        this.gridSizeX = gridSize;
        this.gridSizeY = (int)Math.ceil((float)gridSize * gridTilt);
        this.gridSizeZ = gridSize;
        this.offsetX = (int)Math.ceil((float)dimensionsY * gridTilt * (float)this.gridSizeX);
        this.offsetY = (dimensionsZ + 1) * this.gridSizeZ;
        this.resetGraphics();
    }

    public PImage getImage() {
        return this.pg;
    }

    public PGraphics getGraphics() {
        return this.pg;
    }

    public void resetGraphics() {
        this.pg = this.p.createGraphics(1 + this.offsetX + this.dimensionsX * this.gridSizeX, 1 + this.offsetY + this.dimensionsY * this.gridSizeY, "processing.core.PGraphics2D");
    }

    public void renderCubes(boolean[][][] pixels) {
        this.pg.beginDraw();
        this.pg.stroke(255);
        for (int z = 0; z < pixels[0][0].length; ++z) {
            for (int x = 0; x < pixels.length; ++x) {
                for (int y = 0; y < pixels[x].length; ++y) {
                    if (!pixels[x][y][z]) continue;
                    this.renderCube(x, y, z, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, this.pg.color(220));
                }
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderCubes(boolean[][] pixels, int color) {
        this.pg.beginDraw();
        this.pg.stroke(255);
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!pixels[x][y]) continue;
                this.renderCube(x, y, 0, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, color);
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderCubes(boolean[][] pixels, int z, int color) {
        this.pg.beginDraw();
        this.pg.stroke(255);
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!pixels[x][y]) continue;
                this.renderCube(x, y, z, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, color);
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderCubes(boolean[][][] pixels, int color) {
        this.pg.beginDraw();
        this.pg.stroke(255);
        for (int z = 0; z < pixels[0][0].length; ++z) {
            for (int x = 0; x < pixels.length; ++x) {
                for (int y = 0; y < pixels[x].length; ++y) {
                    if (!pixels[x][y][z]) continue;
                    this.renderCube(x, y, z, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, color);
                }
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderCubes(float[][] pixels, int color) {
        this.renderCubes(pixels, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color)));
    }

    public void renderCubes(float[][] pixels, int colorOn, int colorOff) {
        this.pg.beginDraw();
        this.pg.stroke(255);
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!(pixels[x][y] > 0.0f)) continue;
                this.renderCube(x, y, 0, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, this.pg.lerpColor(colorOn, colorOff, pixels[x][y]));
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderCubes(float[][][] pixels, int color) {
        this.renderCubes(pixels, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color)));
    }

    public void renderCubes(float[][][] pixels, int colorOn, int colorOff) {
        this.pg.beginDraw();
        this.pg.stroke(255);
        for (int z = 0; z < pixels[0][0].length; ++z) {
            for (int x = 0; x < pixels.length; ++x) {
                for (int y = 0; y < pixels[x].length; ++y) {
                    if (!(pixels[x][y][z] > 0.0f)) continue;
                    this.renderCube(x, y, z, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, this.pg.lerpColor(colorOn, colorOff, pixels[x][y][z]));
                }
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderCube(int x, int y, int z, int color) {
        this.renderCube(x, y, z, this.gridSizeX, this.gridSizeY, this.gridSizeZ, this.offsetX, this.offsetY, color);
    }

    protected void renderCube(int x, int y, int z, int gridSizeX, int gridSizeY, int gridSizeZ, int offsetX, int offsetY, int color) {
        Point2D point5 = this.getTopLeftEdge(x, y, z);
        Point2D point6 = this.getBottomLeftEdge(x, y, z);
        Point2D point7 = this.getBottomRightEdge(x, y, z);
        Point2D point8 = this.getTopRightEdge(x, y, z);
        Point2D point1 = this.getTopLeftEdge(x, y, z + 1);
        Point2D point2 = this.getBottomLeftEdge(x, y, z + 1);
        Point2D point3 = this.getBottomRightEdge(x, y, z + 1);
        Point2D point4 = this.getTopRightEdge(x, y, z + 1);
        int topColor = color;
        int sideColor = this.pg.lerpColor(topColor, this.pg.color(0), 0.75f);
        int frontColor = this.pg.lerpColor(topColor, this.pg.color(0), 0.5f);
        this.pg.beginDraw();
        this.pg.fill(sideColor);
        this.pg.beginShape();
        this.pg.vertex((int)point3.x, (int)point3.y);
        this.pg.vertex((int)point4.x, (int)point4.y);
        this.pg.vertex((int)point8.x, (int)point8.y);
        this.pg.vertex((int)point7.x, (int)point7.y);
        this.pg.endShape(2);
        this.pg.noFill();
        this.pg.fill(frontColor);
        this.pg.beginShape();
        this.pg.vertex((int)point2.x, (int)point2.y);
        this.pg.vertex((int)point3.x, (int)point3.y);
        this.pg.vertex((int)point7.x, (int)point7.y);
        this.pg.vertex((int)point6.x, (int)point6.y);
        this.pg.endShape(2);
        this.pg.noFill();
        this.pg.fill(topColor);
        this.pg.beginShape();
        this.pg.vertex((int)point1.x, (int)point1.y);
        this.pg.vertex((int)point2.x, (int)point2.y);
        this.pg.vertex((int)point3.x, (int)point3.y);
        this.pg.vertex((int)point4.x, (int)point4.y);
        this.pg.endShape(2);
        this.pg.noFill();
        this.pg.endDraw();
    }

    public void renderTiles(boolean[][] pixels, int color) {
        this.pg.beginDraw();
        int z = 0;
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!pixels[x][y]) continue;
                Point2D point1 = this.getTopLeftEdge(x, y, z);
                Point2D point2 = this.getBottomLeftEdge(x, y, z);
                Point2D point3 = this.getBottomRightEdge(x, y, z);
                Point2D point4 = this.getTopRightEdge(x, y, z);
                this.pg.fill(color);
                this.pg.beginShape();
                this.pg.vertex((int)point1.x, (int)point1.y);
                this.pg.vertex((int)point2.x, (int)point2.y);
                this.pg.vertex((int)point3.x, (int)point3.y);
                this.pg.vertex((int)point4.x, (int)point4.y);
                this.pg.endShape(2);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderTiles(float[][] pixels, int color) {
        this.renderTiles(pixels, color, this.pg.color(this.pg.red(color), this.pg.green(color), this.pg.blue(color), 0.0f));
    }

    public void renderTiles(float[][] pixels, int colorOn, int colorOff) {
        this.pg.beginDraw();
        int z = 0;
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!(pixels[x][y] > 0.0f)) continue;
                Point2D point1 = this.getTopLeftEdge(x, y, z);
                Point2D point2 = this.getBottomLeftEdge(x, y, z);
                Point2D point3 = this.getBottomRightEdge(x, y, z);
                Point2D point4 = this.getTopRightEdge(x, y, z);
                int c = this.pg.lerpColor(colorOn, colorOff, pixels[x][y]);
                this.pg.fill(c);
                this.pg.beginShape();
                this.pg.vertex((int)point1.x, (int)point1.y);
                this.pg.vertex((int)point2.x, (int)point2.y);
                this.pg.vertex((int)point3.x, (int)point3.y);
                this.pg.vertex((int)point4.x, (int)point4.y);
                this.pg.endShape(2);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderPoints(boolean[][] pixels, int z, int color) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!pixels[x][y]) continue;
                Point2D point = this.getMidPoint(x, y, z);
                this.pg.fill(color);
                this.pg.ellipse((int)point.x, (int)point.y, 3.0f, 3.0f);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderPoints(boolean[][][] pixels, int color) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                for (int z = 0; z < pixels[x][y].length; ++z) {
                    if (!pixels[x][y][z]) continue;
                    Point2D point = this.getMidPoint(x, y, z);
                    this.pg.fill(color);
                    this.pg.ellipse((int)point.x, (int)point.y, 3.0f, 3.0f);
                    this.pg.noFill();
                }
            }
        }
        this.pg.endDraw();
    }

    public void renderPoints(Vector<Point2D> polygon, int z, int color) {
        this.pg.beginDraw();
        for (int i = 0; i < polygon.size(); ++i) {
            float point1_x = (float)this.offsetX + ((float)polygon.get((int)i).x + 0.5f - this.gridTilt * ((float)polygon.get((int)i).y + 0.5f)) * (float)this.gridSizeX;
            float point1_y = (float)(this.offsetY - this.gridSizeZ) + ((float)polygon.get((int)i).y + 0.5f) * (float)this.gridSizeY - ((float)z - 0.5f) * (float)this.gridSizeZ;
            this.pg.fill(color);
            this.pg.ellipse(point1_x, point1_y, 3.0f, 3.0f);
            this.pg.noFill();
        }
        this.pg.endDraw();
    }

    public void renderLines(Vector<Point2D> polygon, int z, int color) {
        this.pg.beginDraw();
        for (int i = 0; i < polygon.size() - 1; ++i) {
            Point2D point1 = this.getMidPoint((int)polygon.get((int)i).x, (int)polygon.get((int)i).y, z);
            Point2D point2 = this.getMidPoint((int)polygon.get((int)(i + 1)).x, (int)polygon.get((int)(i + 1)).y, z);
            this.pg.stroke(color);
            this.pg.strokeWeight(2.0f);
            this.pg.line((int)point1.x, (int)point1.y, (int)point2.x, (int)point2.y);
            this.pg.noStroke();
            this.pg.fill(color);
            this.pg.ellipse((int)point1.x, (int)point1.y, 10.0f, 10.0f);
            this.pg.noFill();
            this.pg.fill(this.p.color(255));
            this.pg.ellipse((int)point2.x, (int)point2.y, 10.0f, 10.0f);
            this.pg.noFill();
        }
        this.pg.endDraw();
    }

    public void renderBackground(int color) {
        this.pg.beginDraw();
        int z = 0;
        for (int x = 0; x < this.dimensionsX; ++x) {
            for (int y = 0; y < this.dimensionsY; ++y) {
                Point2D point1 = this.getTopLeftEdge(x, y, z);
                Point2D point2 = this.getBottomLeftEdge(x, y, z);
                Point2D point3 = this.getBottomRightEdge(x, y, z);
                Point2D point4 = this.getTopRightEdge(x, y, z);
                this.pg.fill(color);
                this.pg.beginShape();
                this.pg.vertex((int)point1.x, (int)point1.y);
                this.pg.vertex((int)point2.x, (int)point2.y);
                this.pg.vertex((int)point3.x, (int)point3.y);
                this.pg.vertex((int)point4.x, (int)point4.y);
                this.pg.endShape(2);
                this.pg.noFill();
            }
        }
        this.pg.endDraw();
    }

    public void renderGrid() {
        this.pg.beginDraw();
        this.pg.stroke(80);
        int z = 0;
        for (int x = 0; x <= this.dimensionsX; ++x) {
            for (int y = 0; y <= this.dimensionsY; ++y) {
                Point2D point1 = this.getTopLeftEdge(x, y, z);
                Point2D point2 = this.getBottomLeftEdge(x, y, z);
                Point2D point3 = this.getTopRightEdge(x, y, z);
                if (y < this.dimensionsY) {
                    this.pg.line((int)point1.x, (int)point1.y, (int)point2.x, (int)point2.y);
                }
                if (x >= this.dimensionsX) continue;
                this.pg.line((int)point1.x, (int)point1.y, (int)point3.x, (int)point3.y);
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public void renderHeightmap(float[][] heightmap, int color) {
        this.pg.beginDraw();
        this.pg.stroke(80);
        this.pg.strokeWeight(1.0f);
        for (int x = 0; x < heightmap.length - 1; ++x) {
            for (int y = 0; y < heightmap[x].length - 1; ++y) {
                Point2D point1 = this.getMidPoint(x, y, (int)(heightmap[x][y] * (float)this.dimensionsZ));
                Point2D point2 = this.getMidPoint(x, y + 1, (int)(heightmap[x][y + 1] * (float)this.dimensionsZ));
                Point2D point3 = this.getMidPoint(x + 1, y + 1, (int)(heightmap[x + 1][y + 1] * (float)this.dimensionsZ));
                Point2D point4 = this.getMidPoint(x + 1, y, (int)(heightmap[x + 1][y] * (float)this.dimensionsZ));
                this.pg.fill(color);
                this.pg.beginShape();
                this.pg.vertex((int)point1.x, (int)point1.y);
                this.pg.vertex((int)point2.x, (int)point2.y);
                this.pg.vertex((int)point3.x, (int)point3.y);
                this.pg.vertex((int)point4.x, (int)point4.y);
                this.pg.endShape(2);
                this.pg.noFill();
            }
        }
        this.pg.noStroke();
        this.pg.endDraw();
    }

    public Point2D getMidPoint(int x, int y, int z) {
        float point1_x = (float)this.offsetX + ((float)x + 0.5f - this.gridTilt * ((float)y + 0.5f)) * (float)this.gridSizeX;
        float point1_y = (float)(this.offsetY - this.gridSizeZ) + ((float)y + 0.5f) * (float)this.gridSizeY - (float)(z * this.gridSizeZ);
        return new Point2D(point1_x, point1_y);
    }

    public Point2D getCubeMidPoint(int x, int y, int z) {
        float point1_x = (float)this.offsetX + ((float)x + 0.5f - this.gridTilt * ((float)y + 0.5f)) * (float)this.gridSizeX;
        float point1_y = (float)(this.offsetY - this.gridSizeZ) + ((float)y + 0.5f) * (float)this.gridSizeY - ((float)z - 0.5f) * (float)this.gridSizeZ;
        return new Point2D(point1_x, point1_y);
    }

    public Point2D getTopLeftEdge(int x, int y, int z) {
        float point1_x = (float)this.offsetX + ((float)x - this.gridTilt * (float)y) * (float)this.gridSizeX;
        float point1_y = this.offsetY - this.gridSizeZ + y * this.gridSizeY - z * this.gridSizeZ;
        return new Point2D(point1_x, point1_y);
    }

    public Point2D getBottomLeftEdge(int x, int y, int z) {
        float point1_x = (float)this.offsetX + ((float)x - this.gridTilt * (float)(y + 1)) * (float)this.gridSizeX;
        float point1_y = this.offsetY - this.gridSizeZ + (y + 1) * this.gridSizeY - z * this.gridSizeZ;
        return new Point2D(point1_x, point1_y);
    }

    public Point2D getBottomRightEdge(int x, int y, int z) {
        float point1_x = (float)this.offsetX + ((float)(x + 1) - this.gridTilt * (float)(y + 1)) * (float)this.gridSizeX;
        float point1_y = this.offsetY - this.gridSizeZ + (y + 1) * this.gridSizeY - z * this.gridSizeZ;
        return new Point2D(point1_x, point1_y);
    }

    public Point2D getTopRightEdge(int x, int y, int z) {
        float point1_x = (float)this.offsetX + ((float)(x + 1) - this.gridTilt * (float)y) * (float)this.gridSizeX;
        float point1_y = this.offsetY - this.gridSizeZ + y * this.gridSizeY - z * this.gridSizeZ;
        return new Point2D(point1_x, point1_y);
    }
}

