/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import processing.core.PApplet;
import processing.core.PImage;
import renderer.Render2D;
import util.math2d.Point2D;

public class SpriteRender2D
extends Render2D {
    public SpriteRender2D(PApplet p, int dimensionsX, int dimensionsY, int imgSizeX, int imgSizeY) {
        super(p, dimensionsX, dimensionsY, imgSizeX, imgSizeY);
    }

    public void renderTile(Point2D point, String spriteFile) {
        this.renderTile((int)point.x, (int)point.y, this.p.loadImage(spriteFile));
    }

    public void renderTile(Point2D point, PImage sprite) {
        this.renderTile((int)point.x, (int)point.y, sprite);
    }

    public void renderTile(int x, int y, String spriteFile) {
        this.renderTile(x, y, this.p.loadImage(spriteFile));
    }

    public void renderTile(int x, int y, PImage sprite) {
        this.pg.beginDraw();
        this.pg.imageMode(0);
        this.pg.image(sprite, x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
        this.pg.endDraw();
    }

    public void renderTiles(boolean[][] pixels, String spriteFile) {
        this.renderTiles(pixels, this.p.loadImage(spriteFile));
    }

    public void renderTiles(boolean[][] pixels, PImage sprite) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (!pixels[x][y]) continue;
                this.pg.imageMode(0);
                this.pg.image(sprite, x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
            }
        }
        this.pg.endDraw();
    }

    public void renderTiles(boolean[][] pixels, String onSpriteFile, String offSpriteFile) {
        this.renderTiles(pixels, this.p.loadImage(onSpriteFile), this.p.loadImage(offSpriteFile));
    }

    public void renderTiles(boolean[][] pixels, PImage onSprite, PImage offSprite) {
        this.pg.beginDraw();
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                if (pixels[x][y]) {
                    this.pg.imageMode(0);
                    this.pg.image(onSprite, x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
                    continue;
                }
                this.pg.imageMode(0);
                this.pg.image(offSprite, x * this.gridSizeX, y * this.gridSizeY, this.gridSizeX, this.gridSizeY);
            }
        }
        this.pg.endDraw();
    }
}

