/*
 * Decompiled with CFR 0.152.
 */
package strategyviewer;

import com.jme3.asset.plugins.FileLocator;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.terrain.geomipmap.TerrainQuad;
import terrainviewer.TerrainImporter;
import terrainviewer.data.DataProcess;

public class StrategyTerrainImporter
extends TerrainImporter {
    public void initResources(String resourceFile, TerrainQuad terrain, Vector3f pos, Vector3f scale) {
        boolean[][] resMap = DataProcess.loadBooleanMatrix((String)resourceFile);
        float totalSize = terrain.getTotalSize();
        int sizeX = resMap.length;
        int sizeY = resMap[0].length;
        float gridSizeX = scale.x * totalSize / (float)sizeX;
        float gridSizeY = scale.z * totalSize / (float)sizeY;
        Material mat_grid = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat_grid.setColor("Color", ColorRGBA.Blue);
        Box vertBox = new Box(Vector3f.ZERO, Vector3f.UNIT_XYZ.mult(2.0f));
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                if (!resMap[x][y]) continue;
                float itemPos_z = pos.x + ((float)x + 0.5f) * gridSizeX - totalSize / 2.0f;
                float itemPos_x = pos.z + ((float)y + 0.5f) * gridSizeY - totalSize / 2.0f;
                float itemPos_y = pos.y + terrain.getHeight(new Vector2f(itemPos_x, itemPos_z)) + pos.y;
                Geometry wall = new Geometry("VertBox", (Mesh)vertBox);
                wall.setMaterial(mat_grid);
                wall.setLocalTranslation(itemPos_x, itemPos_y, itemPos_z);
                this.rootNode.attachChild((Spatial)wall);
            }
        }
        this.viewPort.setBackgroundColor(ColorRGBA.White);
    }

    public void simpleInitApp() {
        String terrainFile = "Textures/Imported/heightImage.png";
        String alphaFile = "Textures/Imported/alphaImage.png";
        String resourceFile = "assets/Textures/Imported/resMatrix.dat";
        this.assetManager.registerLocator("assets/", FileLocator.class);
        String[] tileFiles = new String[]{"Textures/Terrain/stone.DDS", "Textures/Terrain/desert.DDS", "Textures/Terrain/splat/road.jpg"};
        this.initCam(Vector3f.UNIT_Y.mult(900.0f), 80.0f);
        this.initSun(new Vector3f(-1.0f, 1.0f, 0.0f));
        TerrainQuad terrain = this.initHeightMap(terrainFile, 64.0f, Vector3f.ZERO, Vector3f.UNIT_XYZ, alphaFile, tileFiles, 64.0f);
        this.initResources(resourceFile, terrain, Vector3f.ZERO, Vector3f.UNIT_XYZ);
    }

    public static void main(String[] args) {
        AppSettings settings = new AppSettings(true);
        settings.setResolution(640, 480);
        StrategyTerrainImporter app = new StrategyTerrainImporter();
        app.setShowSettings(false);
        app.setSettings(settings);
        app.start();
    }
}

