/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.util.Vector;
import processing.core.PApplet;
import ui.screens.Screen;
import util.collections.ColorCollection;
import util.collections.FontCollection;
import util.statics.LogManager;

public class BaseApplet
extends PApplet {
    final int[] size = new int[]{640, 480};
    public FontCollection fontManager = null;
    public ColorCollection colorManager = null;
    protected Screen screen = null;
    Vector<Screen> previousScreens;

    public void setup() {
        this.size(this.size[0], this.size[1]);
        LogManager.addLogfile("Error", "errorstate.log");
        this.fontManager = new FontCollection(this);
        this.colorManager = new ColorCollection(this);
        this.previousScreens = new Vector();
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void swapScreen(Screen toSwap) {
        this.screen.resolveScreenChanged();
        this.previousScreens.add(this.screen);
        this.screen = toSwap;
        this.redraw();
    }

    public void swapPreviousScreen() {
        this.screen = this.previousScreens.lastElement();
        this.previousScreens.remove(this.screen);
        this.screen.resolveScreenRestored();
        this.redraw();
    }

    public void replaceScreen(Screen toSwap) {
        this.screen.resolveScreenChanged();
        this.screen = toSwap;
        this.redraw();
    }

    public Screen findScreen(Class definition) {
        for (int i = this.previousScreens.size() - 1; i > 0; --i) {
            if (!definition.isInstance(this.previousScreens.get(i))) continue;
            return this.previousScreens.get(i);
        }
        return null;
    }

    public void purgeScreenHistory() {
        this.previousScreens.clear();
    }

    public void update() {
        if (this.screen != null) {
            this.screen.update();
        }
    }

    public void draw() {
        if (this.screen != null) {
            this.screen.draw();
        }
    }

    public void mouseReleased() {
        if (this.screen != null) {
            this.screen.mouseReleased();
        }
    }

    public void mousePressed() {
        if (this.screen != null) {
            this.screen.mousePressed();
        }
    }

    public void mouseClicked() {
        if (this.screen != null) {
            this.screen.mouseClicked();
        }
    }

    public void mouseDragged() {
        if (this.screen != null) {
            this.screen.mouseDragged();
        }
    }

    public void mouseMoved() {
        if (this.screen != null) {
            this.screen.mouseMoved();
        }
    }

    public void keyPressed() {
        if (this.screen != null) {
            this.screen.keyPressed();
        }
    }

    public void keyReleased() {
        if (this.screen != null) {
            this.screen.keyReleased();
        }
    }

    public void keyTyped() {
        if (this.screen != null) {
            this.screen.keyTyped();
        }
    }
}

