/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;
import util.statics.LogManager;

public class UIButton
extends UIComponent {
    String fontname = "Base";
    String caption;
    float textHeight;
    State state;

    public UIButton(BaseApplet p, String caption, int positionX, int positionY, int width, int height) {
        this(p, caption, positionX, positionY, width);
        this.height = height;
    }

    public UIButton(BaseApplet p, String caption, int positionX, int positionY, int width) {
        this(p, caption, positionX, positionY);
        this.width = width;
    }

    public UIButton(BaseApplet p, String caption, int positionX, int positionY, int width, int height, String fontname) {
        this(p, caption, positionX, positionY, width, fontname);
        this.height = height;
        this.setFont(fontname);
    }

    public UIButton(BaseApplet p, String caption, int positionX, int positionY, int width, String fontname) {
        this(p, caption, positionX, positionY, fontname);
        this.width = width;
        this.setFont(fontname);
    }

    public UIButton(BaseApplet p, String caption, int positionX, int positionY, String fontname) {
        this(p, caption, positionX, positionY);
        this.setFont(fontname);
        this.computeWidth();
    }

    public UIButton(BaseApplet p, String caption, int positionX, int positionY) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.textHeight = p.fontManager.getFontHeight(this.fontname);
        p.textFont(p.fontManager.getFont(this.fontname), this.textHeight);
        this.width = (int)p.textWidth(caption) + 10;
        this.height = (int)Math.ceil(this.textHeight) + 6;
        this.caption = caption;
        this.state = State.UP;
    }

    protected void computeWidth() {
        this.p.textFont(this.p.fontManager.getFont(this.fontname), this.textHeight);
        this.width = (int)this.p.textWidth(this.caption) + 10;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public void setFont(String fontname) {
        this.setFont(fontname, false);
    }

    public void setFont(String fontname, boolean autoWidth) {
        if (!this.p.fontManager.isFont(fontname)) {
            LogManager.writeError("Error", this, "font " + fontname + " does not exist.");
        }
        this.fontname = fontname;
        this.textHeight = this.p.fontManager.getFontHeight(fontname);
        this.height = (int)Math.ceil(this.textHeight) + 6;
        if (autoWidth) {
            this.width = (int)this.p.textWidth(this.caption) + 10;
        }
    }

    public void resolveHide() {
        this.state = State.UP;
    }

    public void resolveScreenChanged() {
        this.state = State.UP;
    }

    public void resolveScreenRestored() {
        this.state = State.UP;
    }

    public void draw() {
        this.p.stroke(0);
        this.p.strokeWeight(1.0f);
        this.p.strokeCap(2);
        if (this.state == State.DISABLED) {
            this.p.fill(this.p.colorManager.getColor("ButtonDisabled"));
        } else if (this.state == State.OVER) {
            this.p.fill(this.p.colorManager.getColor("ButtonOver"));
        } else if (this.state == State.PRESSED) {
            this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
        } else {
            this.p.fill(this.p.colorManager.getColor("ButtonUp"));
        }
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, this.width, this.height);
        if (this.state == State.DISABLED) {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonDisabled"));
        } else if (this.state == State.OVER) {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonOver"));
        } else if (this.state == State.PRESSED) {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonPressed"));
        } else {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonUp"));
        }
        this.p.textFont(this.p.fontManager.getFont(this.fontname));
        this.p.textAlign(3);
        this.p.text(this.caption, (float)this.positionX, (float)this.positionY + this.textHeight / 4.0f);
        this.p.noFill();
        this.p.noStroke();
    }

    public State getState() {
        return this.state;
    }

    public void reset() {
        this.state = State.UP;
    }

    public void enable() {
        this.state = State.UP;
        this.update();
    }

    public void disable() {
        this.state = State.DISABLED;
    }

    public void mousePressed() {
        this.update();
    }

    public void mouseReleased() {
        this.update();
    }

    public void mouseMoved() {
        this.update();
    }

    public void update() {
        if (this.state == State.DISABLED) {
            return;
        }
        this.state = this.p.mousePressed ? State.DOWN : (this.isMouseOver() ? (this.state == State.DOWN ? State.PRESSED : State.OVER) : State.UP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DISABLED,
        UP,
        DOWN,
        PRESSED,
        OVER;

    }
}

