/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIButton;

public class UIButtonImage
extends UIButton {
    PImage img;
    PImage overImg;
    int mouseOverTint;

    public UIButtonImage(BaseApplet p, String filename, int positionX, int positionY, int width, int height) {
        this(p, p.loadImage(filename), positionX, positionY, width, height);
    }

    public UIButtonImage(BaseApplet p, String filename, int positionX, int positionY) {
        this(p, p.loadImage(filename), positionX, positionY);
    }

    public UIButtonImage(BaseApplet p, PImage img, int positionX, int positionY, int width, int height) {
        super(p, "", positionX, positionY, width, height);
        this.img = img;
        img.resize(width, height);
        this.init();
    }

    public UIButtonImage(BaseApplet p, PImage img, int positionX, int positionY) {
        super(p, "", positionX, positionY);
        this.img = img;
        this.overImg = null;
        this.width = img.width;
        this.height = img.height;
        this.init();
    }

    public UIButtonImage(BaseApplet p, String filename, String overFilename, int positionX, int positionY, int width, int height) {
        this(p, p.loadImage(filename), p.loadImage(overFilename), positionX, positionY, width, height);
    }

    public UIButtonImage(BaseApplet p, String filename, String overFilename, int positionX, int positionY) {
        this(p, p.loadImage(filename), p.loadImage(overFilename), positionX, positionY);
    }

    public UIButtonImage(BaseApplet p, PImage img, PImage overImg, int positionX, int positionY, int width, int height) {
        super(p, "", positionX, positionY, width, height);
        this.img = img;
        this.img.resize(width, height);
        this.overImg = overImg;
        this.overImg.resize(width, height);
        this.init();
    }

    public UIButtonImage(BaseApplet p, PImage img, PImage overImg, int positionX, int positionY) {
        super(p, "", positionX, positionY);
        this.img = img;
        this.width = img.width;
        this.height = img.height;
        this.init();
    }

    protected void init() {
        this.mouseOverTint = this.p.colorManager.getColor("ImageButtonOverTint");
    }

    public void setMouseOverTint(int r, int g, int b) {
        this.setMouseOverTint(this.p.color(r, g, b));
    }

    public void setMouseOverTint(int color) {
        this.mouseOverTint = color;
    }

    public void draw() {
        if (this.state == UIButton.State.DISABLED) {
            this.p.tint(this.p.colorManager.getColor("ImageButtonDisabledTint"));
        } else if (this.state == UIButton.State.OVER && this.overImg == null) {
            this.p.tint(this.mouseOverTint);
        }
        this.p.imageMode(3);
        if (this.overImg != null) {
            this.p.image(this.overImg, this.positionX, this.positionY);
        } else {
            this.p.image(this.img, this.positionX, this.positionY);
        }
        this.p.noTint();
    }
}

