/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIMapOutput;
import util.math2d.Point2D;

public class UICanvas
extends UIMapOutput {
    boolean paintMode = true;
    int paintColor = 0;
    Point2D startPoint = null;
    boolean drawRectangle = false;

    public UICanvas(BaseApplet p, int positionX, int positionY, int width, int height) {
        super(p, positionX, positionY, width, height);
    }

    public UICanvas(BaseApplet p, int positionX, int positionY, int width, int height, int resolution) {
        super(p, positionX, positionY, width, height, resolution);
    }

    public void setPaintMode(boolean value) {
        this.paintMode = value;
    }

    public void setPaintColor(int color) {
        this.paintColor = color;
    }

    public void setPaintColor(int r, int g, int b) {
        this.paintColor = this.p.color(r, g, b);
    }

    public void setDrawRectangle(boolean value) {
        if (this.drawRectangle != value) {
            this.drawRectangle = value;
            this.startPoint = null;
        }
    }

    public void draw() {
        super.draw();
        if (this.paintMode && this.isMouseOver()) {
            int gridIndexX = (int)Math.floor((double)(this.p.mouseX - this.startX) / (double)this.gridSize);
            int gridIndexY = (int)Math.floor((double)(this.p.mouseY - this.startY) / (double)this.gridSize);
            if (this.drawRectangle && this.startPoint != null) {
                this.p.noFill();
                this.p.stroke(this.p.color(255));
                int minX = Math.min(gridIndexX, (int)this.startPoint.x);
                int minY = Math.min(gridIndexY, (int)this.startPoint.y);
                int width = 1 + Math.max(gridIndexX, (int)this.startPoint.x) - minX;
                int height = 1 + Math.max(gridIndexY, (int)this.startPoint.y) - minY;
                this.p.rect(minX * this.gridSize + this.startX, minY * this.gridSize + this.startY, width * this.gridSize, height * this.gridSize);
                this.p.noStroke();
            } else {
                this.p.noFill();
                this.p.stroke(this.p.color(255));
                this.p.rect(gridIndexX * this.gridSize + this.startX, gridIndexY * this.gridSize + this.startY, this.gridSize, this.gridSize);
                this.p.noStroke();
            }
        }
    }

    public void update() {
        if (this.paintMode && this.p.mousePressed && this.isMouseOver()) {
            int gridIndexX = (int)Math.floor((double)(this.p.mouseX - this.startX) / (double)this.gridSize);
            int gridIndexY = (int)Math.floor((double)(this.p.mouseY - this.startY) / (double)this.gridSize);
            if (gridIndexX >= 0 && gridIndexY < this.resolutionX && gridIndexY >= 0 && gridIndexY < this.resolutionY) {
                if (this.drawRectangle) {
                    if (this.startPoint == null) {
                        this.startPoint = new Point2D(gridIndexX, gridIndexY);
                    } else {
                        int minX = Math.min(gridIndexX, (int)this.startPoint.x);
                        int minY = Math.min(gridIndexY, (int)this.startPoint.y);
                        int maxX = Math.max(gridIndexX, (int)this.startPoint.x);
                        int maxY = Math.max(gridIndexY, (int)this.startPoint.y);
                        for (int x = minX; x <= maxX; ++x) {
                            for (int y = minY; y <= maxY; ++y) {
                                this.setPixel(x, y, this.paintColor);
                            }
                        }
                        this.startPoint = null;
                    }
                } else {
                    this.setPixel(gridIndexX, gridIndexY, this.paintColor);
                }
            }
            this.requestRedraw();
        }
    }

    public void mousePressed() {
        this.update();
    }

    public void mouseMoved() {
        this.update();
    }
}

