/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIProgressBar;

public class UIComparativeProgressBar
extends UIProgressBar {
    int altColor;
    double altProgress;

    public UIComparativeProgressBar(BaseApplet p, int positionX, int positionY, int width, int length) {
        super(p, positionX, positionY, width, length);
        this.setDefaultColor();
        this.progress = 0.0;
        this.altProgress = -1.0;
    }

    public void setAltProgress(double value) {
        this.altProgress = value;
    }

    public void setAltColor(int value) {
        this.altColor = value;
    }

    public void setDefaultColor() {
        this.color = this.p.colorManager.getColor("ProgressBar");
        this.altColor = this.p.colorManager.getColor("ProgressBarComparison");
    }

    public void draw() {
        this.p.noStroke();
        this.p.fill(this.color);
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, (int)((double)this.width * this.progress), this.height);
        this.p.noFill();
        this.p.noStroke();
        if (this.altProgress >= 0.0) {
            this.p.noStroke();
            this.p.fill(this.altColor);
            this.p.rect(this.positionX - this.width / 2 + (int)((double)this.width * this.altProgress - 1.0), this.positionY - this.height / 2, 2.0f, this.height);
            this.p.noFill();
            this.p.noStroke();
        }
        this.p.stroke(0);
        this.p.strokeWeight(1.0f);
        this.p.strokeCap(2);
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, this.width, this.height);
        this.p.noFill();
        this.p.noStroke();
        if (this.useText) {
            this.p.fill(this.p.colorManager.getColor("Font_ProgressBar"));
            this.p.textFont(this.p.fontManager.getFont("Base"));
            int tY = this.positionY + (int)(this.p.fontManager.getFontHeight("Base") / 2.0f);
            this.p.textAlign(3);
            this.p.text((int)(this.progress * 100.0) + "%", (float)this.positionX, (float)tY);
        }
    }
}

