/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import util.math2d.Point2D;

public abstract class UIComponent {
    protected int positionX;
    protected int positionY;
    protected int width;
    protected int height;
    protected BaseApplet p;

    public UIComponent(BaseApplet p) {
        this.p = p;
    }

    public UIComponent(BaseApplet p, int positionX, int positionY, int width, int height) {
        this.p = p;
        this.positionX = positionX;
        this.positionY = positionY;
        this.width = width;
        this.height = height;
    }

    public void setPositionX(int value) {
        this.positionX = value;
    }

    public void setPositionY(int value) {
        this.positionY = value;
    }

    public void setPosition(int x, int y) {
        this.positionX = x;
        this.positionY = y;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public void setTopLeftPosition(int x, int y) {
        this.positionX = x + this.width / 2;
        this.positionY = y + this.height / 2;
    }

    public void setTopLeftPosition(Point2D point) {
        this.setTopLeftPosition((int)point.x, (int)point.y);
    }

    public void setTopRightPosition(int x, int y) {
        this.positionX = x - this.width / 2;
        this.positionY = y + this.height / 2;
    }

    public void setTopRightPosition(Point2D point) {
        this.setTopRightPosition((int)point.x, (int)point.y);
    }

    public void setBottomRightPosition(int x, int y) {
        this.positionX = x - this.width / 2;
        this.positionY = y - this.height / 2;
    }

    public void setBottomRightPosition(Point2D point) {
        this.setBottomRightPosition((int)point.x, (int)point.y);
    }

    public void setBottomLeftPosition(int x, int y) {
        this.positionX = x + this.width / 2;
        this.positionY = y - this.height / 2;
    }

    public void setBottomLeftPosition(Point2D point) {
        this.setBottomLeftPosition((int)point.x, (int)point.y);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Point2D getTopLeftCorner() {
        return new Point2D(this.positionX - this.width / 2, this.positionY - this.height / 2);
    }

    public Point2D getTopRightCorner() {
        return new Point2D(this.positionX + this.width / 2, this.positionY - this.height / 2);
    }

    public Point2D getBottomLeftCorner() {
        return new Point2D(this.positionX - this.width / 2, this.positionY + this.height / 2);
    }

    public Point2D getBottomRightCorner() {
        return new Point2D(this.positionX + this.width / 2, this.positionY + this.height / 2);
    }

    public boolean isMouseOver() {
        return this.isOver(this.p.mouseX, this.p.mouseY);
    }

    public boolean isOver(int x, int y) {
        return x >= this.positionX - this.width / 2 && x <= this.positionX + this.width / 2 && y >= this.positionY - this.height / 2 && y <= this.positionY + this.height / 2;
    }

    public abstract void draw();

    public void update() {
    }

    public void mouseClicked() {
    }

    public void mouseMoved() {
    }

    public void mouseDragged() {
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void keyTyped() {
    }

    public void resolveHide() {
    }

    public void resolveShow() {
    }

    public void resolveScreenChanged() {
    }

    public void resolveScreenRestored() {
    }
}

