/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;

public abstract class UIDraggable
extends UIComponent {
    State state;
    int mouseOffsetX;
    int mouseOffsetY;
    int initialPositionX;
    int initialPositionY;

    public UIDraggable(BaseApplet p, int positionX, int positionY, int width, int height) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.initialPositionX = positionX;
        this.initialPositionY = positionY;
        this.width = width;
        this.height = height;
        this.state = State.UP;
        this.mouseOffsetX = 0;
        this.mouseOffsetY = 0;
    }

    public boolean isDragged() {
        return this.state == State.DRAGGED;
    }

    public void resetDragged() {
        this.revertToInitialPosition();
        if (this.state == State.DRAGGED) {
            this.state = State.UP;
        }
    }

    public void setInitialPosition(int x, int y) {
        this.initialPositionX = x;
        this.initialPositionY = y;
    }

    public void revertToInitialPosition() {
        this.positionX = this.initialPositionX;
        this.positionY = this.initialPositionY;
    }

    public void mousePressed() {
        if (this.state == State.UP && this.isMouseOver()) {
            this.state = State.DRAGGED;
            this.mouseOffsetX = this.positionX - this.p.mouseX;
            this.mouseOffsetY = this.positionY - this.p.mouseY;
        }
    }

    public void mouseDragged() {
        if (this.state == State.DRAGGED) {
            this.positionX = this.p.mouseX + this.mouseOffsetX;
            this.positionY = this.p.mouseY + this.mouseOffsetY;
        }
    }

    public void mouseReleased() {
        if (this.state == State.DRAGGED) {
            this.state = State.UP;
        }
    }

    public abstract void draw();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DISABLED,
        UP,
        DRAGGED;

    }
}

