/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIDraggable;

public class UIDraggableImage
extends UIDraggable {
    PImage img;

    public UIDraggableImage(BaseApplet p, String filename, int positionX, int positionY) {
        this(p, p.loadImage(filename), positionX, positionY);
    }

    public UIDraggableImage(BaseApplet p, String filename, int positionX, int positionY, int width, int height) {
        this(p, p.loadImage(filename), positionX, positionY, width, height);
    }

    public UIDraggableImage(BaseApplet p, PImage img, int positionX, int positionY) {
        this(p, img, positionX, positionY, img.width, img.height);
    }

    public UIDraggableImage(BaseApplet p, PImage img, int positionX, int positionY, int width, int height) {
        super(p, positionX, positionY, width, height);
        this.img = img;
        img.width = width;
        img.height = height;
    }

    public void draw() {
        this.p.imageMode(3);
        this.p.image(this.img, this.positionX, this.positionY);
        if (this.state == UIDraggable.State.DRAGGED) {
            this.p.stroke(this.p.colorManager.getColor("DraggableImageSelected"));
        } else {
            this.p.stroke(this.p.colorManager.getColor("DraggableImage"));
        }
        this.p.strokeWeight(2.0f);
        this.p.strokeJoin(8);
        this.p.strokeCap(4);
        this.p.noFill();
        this.p.rect(this.positionX - this.width / 2 - 1, this.positionY - this.height / 2 - 1, this.width + 2, this.height + 2);
        this.p.noStroke();
    }
}

