/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIComponent;

public class UIImage
extends UIComponent {
    PImage img;
    boolean edge = false;

    public UIImage(BaseApplet p, String filename, int positionX, int positionY) {
        this(p, p.loadImage(filename), positionX, positionY);
    }

    public UIImage(BaseApplet p, String filename, int positionX, int positionY, int width, int height) {
        this(p, p.loadImage(filename), positionX, positionY, width, height);
    }

    public UIImage(BaseApplet p, PImage img, int positionX, int positionY) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.setImage(img, false);
    }

    public UIImage(BaseApplet p, PImage img, int positionX, int positionY, int width, int height) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.width = width;
        this.height = height;
        this.setImage(img, true);
    }

    public PImage getImage() {
        return this.img;
    }

    public void setEdge(boolean value) {
        this.edge = value;
    }

    public void setImage(PImage img, boolean resize) {
        this.img = this.p.createImage(img.width, img.height, img.format);
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                this.img.set(x, y, img.get(x, y));
            }
        }
        if (resize) {
            this.img.resize(this.width, this.height);
        } else {
            this.width = img.width;
            this.height = img.height;
        }
    }

    public void setImage(String filename, boolean resize) {
        this.setImage(this.p.loadImage(filename), resize);
    }

    public void draw() {
        this.p.imageMode(3);
        this.p.image(this.img, this.positionX, this.positionY);
        if (this.edge) {
            this.p.stroke(0);
            this.p.strokeWeight(1.0f);
            this.p.strokeCap(2);
            this.p.rect(this.positionX - this.width / 2 - 1, this.positionY - this.height / 2 - 1, this.width + 2, this.height + 2);
            this.p.noFill();
            this.p.noStroke();
        }
    }
}

