/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;

public class UILabel
extends UIComponent {
    String fontname = "Base";
    String caption;
    boolean useBorder;
    float textHeight;
    int textColor;
    int textCenter;

    public UILabel(BaseApplet p, String caption, int positionX, int positionY, int width, int height) {
        this(p, caption, positionX, positionY, width);
        this.height = height;
    }

    public UILabel(BaseApplet p, String caption, int positionX, int positionY, int width) {
        this(p, caption, positionX, positionY);
        this.width = width;
    }

    public UILabel(BaseApplet p, String caption, int positionX, int positionY, int width, int height, String fontname) {
        this(p, caption, positionX, positionY, width, fontname);
        this.height = height;
        this.setFont(fontname);
    }

    public UILabel(BaseApplet p, String caption, int positionX, int positionY, int width, String fontname) {
        this(p, caption, positionX, positionY, fontname);
        this.width = width;
        this.setFont(fontname);
    }

    public UILabel(BaseApplet p, String caption, int positionX, int positionY, String fontname) {
        this(p, caption, positionX, positionY);
        this.setFont(fontname);
        this.computeWidth();
    }

    public UILabel(BaseApplet p, String caption, int positionX, int positionY) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.textHeight = p.fontManager.getFontHeight(this.fontname);
        this.textColor = p.colorManager.getColor("Font_Default");
        this.width = (int)p.textWidth(caption) + 10;
        this.height = (int)Math.ceil(this.textHeight) + 6;
        this.caption = caption;
        this.textCenter = 0;
        this.useBorder = false;
    }

    protected void computeWidth() {
        this.p.textFont(this.p.fontManager.getFont(this.fontname), this.textHeight);
        this.width = (int)this.p.textWidth(this.caption) + 10;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public void setTextColor(int value) {
        this.textColor = value;
    }

    public void setTextCenter(int value) {
        this.textCenter = value;
    }

    public void setBorder(boolean value) {
        this.useBorder = value;
    }

    public void setFont(String fontname) {
        if (!this.p.fontManager.isFont(fontname)) {
            System.out.println("UIButton: Font " + fontname + " does not exist.");
        }
        this.fontname = fontname;
        this.textHeight = this.p.fontManager.getFontHeight(fontname);
        this.height = (int)Math.ceil(this.textHeight) + 6;
    }

    public void setFont(String fontname, boolean autoWidth) {
        if (this.p.fontManager.isFont(fontname)) {
            System.out.println("UIButton: Font " + fontname + " does not exist.");
        }
        this.fontname = fontname;
        this.textHeight = this.p.fontManager.getFontHeight(fontname);
        this.height = (int)Math.ceil(this.textHeight) + 6;
        if (autoWidth) {
            this.width = (int)this.p.textWidth(this.caption) + 10;
        }
    }

    public void draw() {
        this.p.fill(this.textColor);
        if (this.useBorder) {
            this.p.stroke(0);
        }
        this.p.textFont(this.p.fontManager.getFont(this.fontname));
        if (this.textCenter < 0) {
            this.p.textAlign(39);
        } else if (this.textCenter > 0) {
            this.p.textAlign(37);
        } else {
            this.p.textAlign(3);
        }
        this.p.text(this.caption, (float)this.positionX, (float)this.positionY + this.textHeight / 4.0f);
        this.p.noFill();
        this.p.noStroke();
    }
}

