/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import java.util.Vector;
import ui.BaseApplet;
import ui.components.UIComponent;
import ui.components.UIMapOutput;

public class UILayeredMapOutput
extends UIComponent {
    Vector<UIMapOutput> layers;
    int startX;
    int startY;
    int resolutionX;
    int resolutionY;
    Vector<Integer> drawnIndexes;
    Vector<Integer> drawnColors;

    public UILayeredMapOutput(BaseApplet p, int positionX, int positionY, int width, int height) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.width = width;
        this.height = height;
        this.resolutionX = width;
        this.resolutionY = height;
        this.startX = positionX - width / 2;
        this.startY = positionY - height / 2;
        this.layers = new Vector();
        this.drawnIndexes = new Vector();
        this.drawnColors = new Vector();
        p.noLoop();
    }

    public void addLayer() {
    }

    public void resetDrawIndexes() {
        this.drawnIndexes.clear();
        this.drawnColors.clear();
    }

    public void requestRedraw() {
        this.p.redraw();
    }

    public void setPixel(int x, int y, int index, int value) {
        if (index < 0 || this.layers.size() >= index) {
            System.out.println("Index out of range");
            return;
        }
        this.layers.get(index).setPixel(x, y, value);
    }

    public void setPixel(int x, int y, int index, int r, int g, int b) {
        if (index < 0 || this.layers.size() >= index) {
            System.out.println("Index out of range");
            return;
        }
        this.layers.get(index).setPixel(x, y, r, g, b);
    }

    public int getPixel(int x, int y, int index) {
        if (index < 0 || this.layers.size() >= index) {
            System.out.println("Index out of range");
            return -1;
        }
        return this.layers.get(index).getPixel(x, y);
    }

    public int getPixelR(int x, int y, int index) {
        if (index < 0 || this.layers.size() >= index) {
            System.out.println("Index out of range");
            return -1;
        }
        return this.layers.get(index).getPixelR(x, y);
    }

    public int getPixelG(int x, int y, int index) {
        if (index < 0 || this.layers.size() >= index) {
            System.out.println("Index out of range");
            return -1;
        }
        return this.layers.get(index).getPixelG(x, y);
    }

    public int getPixelB(int x, int y, int index) {
        if (index < 0 || this.layers.size() >= index) {
            System.out.println("Index out of range");
            return -1;
        }
        return this.layers.get(index).getPixelB(x, y);
    }

    protected UIMapOutput getMonoMapOutput(int index) {
        if (index < 0 || this.layers.size() <= index) {
            System.out.println("UIMapOutput: index out of range");
            return null;
        }
        return this.layers.get(index);
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public void showLayer(int index) {
        this.showLayer(index, this.p.color(255));
    }

    public void showLayer(int index, int drawnColorR, int drawnColorG, int drawnColorB) {
        this.showLayer(index, this.p.color(drawnColorR, drawnColorG, drawnColorB));
    }

    public void showLayer(int index, int drawnColor) {
        if (this.drawnIndexes.size() != this.drawnColors.size()) {
            System.out.println("UILayeredMapOutput: mismatch in size between drawnIndexes and drawnColors.");
            return;
        }
        if (this.drawnIndexes.contains(index)) {
            return;
        }
        this.drawnIndexes.add(index);
        this.drawnColors.add(drawnColor);
    }

    public void draw() {
        this.p.stroke(0);
        this.p.strokeWeight(1.0f);
        this.p.strokeCap(2);
        this.p.fill(255);
        this.p.rect(this.startX - 1, this.startY + 1, this.width + 2, this.height + 2);
        this.p.noFill();
        this.p.noStroke();
        for (int i = 0; i < this.drawnIndexes.size(); ++i) {
            int t = this.drawnIndexes.get(i);
            int c = this.drawnColors.get(i);
            this.layers.get(t).draw();
        }
    }
}

