/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIComponent;

public class UIMapOutput
extends UIComponent {
    int[] pixels;
    int startX;
    int startY;
    int resolutionX;
    int resolutionY;
    boolean showGrid = true;
    int gridSize;
    float aspect;

    public UIMapOutput(BaseApplet p, int positionX, int positionY, int width, int height) {
        super(p, positionX, positionY, width, height);
        this.computeResolution();
        this.pixels = new int[this.resolutionX * this.resolutionY];
    }

    public UIMapOutput(BaseApplet p, int positionX, int positionY, int width, int height, int resolution) {
        super(p, positionX, positionY, width, height);
        this.computeResolution(resolution);
        this.pixels = new int[this.resolutionX * this.resolutionY];
    }

    public void computeResolution() {
        this.computeResolution(Math.max(this.width, this.height));
    }

    public void computeResolution(int resolution) {
        this.aspect = (float)this.width / (float)this.height;
        if (this.aspect > 1.0f) {
            this.resolutionX = resolution;
            this.resolutionY = (int)Math.floor((float)resolution / this.aspect);
        } else {
            this.resolutionX = (int)Math.floor((float)resolution * this.aspect);
            this.resolutionY = resolution;
        }
        this.gridSize = (int)Math.floor((float)this.width / (float)this.resolutionX);
        this.width = this.gridSize * this.resolutionX;
        this.height = this.gridSize * this.resolutionY;
        this.startX = this.positionX - this.width / 2;
        this.startY = this.positionY - this.height / 2;
    }

    public int size() {
        return this.pixels.length;
    }

    public void setPixel(int x, int y, int color) {
        this.pixels[y * this.resolutionX + x] = color;
    }

    public void setPixel(int x, int y, int r, int g, int b) {
        this.setPixel(x, y, this.p.color(r, g, b));
    }

    public void setAllPixels(int r, int g, int b) {
        this.setAllPixels(this.p.color(r, g, b));
    }

    public void setAllPixels(int color) {
        for (int y = 0; y < this.resolutionY; ++y) {
            for (int x = 0; x < this.resolutionX; ++x) {
                this.setPixel(x, y, color);
            }
        }
    }

    public PImage getImage() {
        return this.getImage(this.gridSize);
    }

    public PImage getImage(int gridSize) {
        PImage result = this.p.createImage(this.resolutionX * gridSize, this.resolutionY * gridSize, 1);
        boolean pX = false;
        boolean pY = false;
        for (int x = 0; x < this.resolutionX; ++x) {
            for (int y = 0; y < this.resolutionY; ++y) {
                int color = this.pixels[y * this.resolutionX + x];
                for (int i = 0; i < gridSize; ++i) {
                    for (int j = 0; j < gridSize; ++j) {
                        result.set(x * gridSize + i, y * gridSize + j, color);
                    }
                }
            }
        }
        return result;
    }

    public void setImage(PImage img) {
        if (img.width == this.resolutionX && img.height == this.resolutionY) {
            for (int x = 0; x < this.resolutionX; ++x) {
                for (int y = 0; y < this.resolutionY; ++y) {
                    this.pixels[y * this.resolutionX + x] = img.get(x, y);
                }
            }
        } else {
            for (int x = 0; x < this.resolutionX; ++x) {
                for (int y = 0; y < this.resolutionY; ++y) {
                    this.pixels[y * this.resolutionX + x] = img.get((int)(((float)x + 0.5f) * (float)this.gridSize), (int)(((float)y + 0.5f) * (float)this.gridSize));
                }
            }
        }
    }

    public void setMaxResolution(int value) {
        PImage currScreenshot = this.getImage();
        this.computeResolution(value);
        this.pixels = new int[this.resolutionX * this.resolutionY];
        this.setImage(currScreenshot);
    }

    public int getPixel(int x, int y) {
        return this.pixels[y * this.resolutionX + x];
    }

    public int getPixelR(int x, int y) {
        return (int)this.p.red(this.getPixel(x, y));
    }

    public int getPixelG(int x, int y) {
        return (int)this.p.green(this.getPixel(x, y));
    }

    public int getPixelB(int x, int y) {
        return (int)this.p.blue(this.getPixel(x, y));
    }

    public boolean[] getArrayOfColor(int r, int g, int b) {
        if (this.pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            result[i] = this.pixels[i] == this.p.color(r, g, b);
        }
        return result;
    }

    public boolean[] getArrayBelowColor(int r, int g, int b) {
        if (this.pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            result[i] = this.p.red(this.pixels[i]) < (float)r && this.p.green(this.pixels[i]) < (float)g && this.p.blue(this.pixels[i]) < (float)b;
        }
        return result;
    }

    public boolean[] getArrayAboveColor(int r, int g, int b) {
        if (this.pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            result[i] = this.p.red(this.pixels[i]) > (float)r && this.p.green(this.pixels[i]) > (float)g && this.p.blue(this.pixels[i]) > (float)b;
        }
        return result;
    }

    public boolean[] getArrayBetweenColors(int r1, int g1, int b1, int r2, int g2, int b2) {
        if (this.pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            result[i] = this.p.red(this.pixels[i]) >= (float)r1 && this.p.green(this.pixels[i]) >= (float)g1 && this.p.blue(this.pixels[i]) >= (float)b1 && this.p.red(this.pixels[i]) <= (float)r2 && this.p.green(this.pixels[i]) <= (float)g2 && this.p.blue(this.pixels[i]) <= (float)b2;
        }
        return result;
    }

    public void requestRedraw() {
        this.p.redraw();
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public int getMaxResolution() {
        if (this.aspect > 1.0f) {
            return this.resolutionX;
        }
        return this.resolutionY;
    }

    public void draw() {
        int x;
        int y;
        this.p.stroke(0);
        this.p.strokeWeight(1.0f);
        this.p.strokeCap(2);
        this.p.fill(255);
        this.p.rect(this.startX, this.startY, this.width, this.height);
        this.p.noFill();
        this.p.noStroke();
        if (this.gridSize <= 1) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    this.p.set(this.startX + x, this.startY + y, this.pixels[this.resolutionX * y + x]);
                }
            }
        } else {
            this.p.rectMode(0);
            for (y = 0; y < this.resolutionY; ++y) {
                for (x = 0; x < this.resolutionX; ++x) {
                    this.p.fill(this.pixels[this.resolutionX * y + x]);
                    this.p.rect(this.startX + x * this.gridSize, this.startY + y * this.gridSize, this.gridSize, this.gridSize);
                }
            }
        }
        if (this.gridSize > 2 && this.showGrid) {
            this.p.stroke(this.p.colorManager.getColor("CanvasGrid"));
            for (y = 1; y < this.resolutionY; ++y) {
                this.p.line(this.startX, this.startY + y * this.gridSize, this.startX + this.width, this.startY + y * this.gridSize);
            }
            for (int x2 = 1; x2 < this.resolutionX; ++x2) {
                this.p.line(this.startX + x2 * this.gridSize, this.startY, this.startX + x2 * this.gridSize, this.startY + this.height);
            }
            this.p.noStroke();
        }
    }

    public PImage toImage() {
        PImage result = new PImage(this.width, this.height);
        for (int y = 0; y < this.resolutionY; ++y) {
            for (int x = 0; x < this.resolutionX; ++x) {
                for (int i = 0; i < this.gridSize; ++i) {
                    for (int j = 0; j < this.gridSize; ++j) {
                        result.set(x * this.gridSize + i, y * this.gridSize + j, this.pixels[this.resolutionX * y + x]);
                    }
                }
            }
        }
        return result;
    }
}

