/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIComponent;
import ui.components.UILabel;

public class UIModNumber
extends UIComponent {
    UIButton plusButton;
    UIButton minusButton;
    UILabel display;
    float value;
    int minValue;
    int maxValue;
    int increment;

    public UIModNumber(BaseApplet p, int positionX, int positionY, int initialValue, int minValue, int maxValue, int increment) {
        super(p, positionX, positionY, 0, 0);
        this.value = initialValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.increment = increment;
        this.init();
        this.update();
    }

    public int getValue() {
        return (int)this.value;
    }

    public void init() {
        this.display = new UILabel(this.p, "" + this.getValue(), this.positionX + 15, this.positionY + 13, 30, 26, "Large");
        this.display.setBorder(true);
        this.plusButton = new UIButton(this.p, "+", this.positionX + 40, this.positionY + 7, 12, 13);
        this.minusButton = new UIButton(this.p, "-", this.positionX + 40, this.positionY + 20, 12, 13);
    }

    public void draw() {
        this.p.strokeCap(2);
        this.display.draw();
        if (this.value < (float)this.maxValue) {
            this.plusButton.draw();
        }
        if (this.value > (float)this.minValue) {
            this.minusButton.draw();
        }
    }

    public void update() {
        UIButton.State state = null;
        int initialValue = this.getValue();
        if (this.value < (float)this.maxValue) {
            this.plusButton.update();
            state = this.plusButton.getState();
            if (state == UIButton.State.PRESSED) {
                this.value += (float)this.increment;
            }
        }
        if (this.value > (float)this.minValue) {
            this.minusButton.update();
            state = this.minusButton.getState();
            if (state == UIButton.State.PRESSED) {
                this.value -= (float)this.increment;
            }
        }
        if (initialValue != this.getValue()) {
            this.display.setCaption("" + this.getValue());
            this.draw();
        }
    }

    public void mousePressed() {
        this.update();
    }

    public void mouseReleased() {
        this.update();
    }

    public void mouseClicked() {
        this.update();
    }
}

