/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;

public class UIPlaceholder
extends UIComponent {
    UIComponent contained;

    public UIPlaceholder(BaseApplet p, int positionX, int positionY, int width, int height) {
        super(p, positionX, positionY, width, height);
        this.positionX = positionX;
        this.positionY = positionY;
        this.width = width;
        this.height = height;
        this.contained = null;
    }

    public UIPlaceholder(BaseApplet p, UIComponent contained) {
        super(p, contained.positionX, contained.positionY, contained.width, contained.height);
        this.contained = contained;
    }

    public void clearOccupiedBy() {
        this.contained = null;
    }

    public void setOccupiedBy(UIComponent contained) {
        this.contained = contained;
    }

    public UIComponent getOccupiedBy() {
        return this.contained;
    }

    public boolean isUnoccupied() {
        return this.contained == null;
    }

    public boolean isOccupiedBy(UIComponent contained) {
        if (this.contained == null) {
            return false;
        }
        return this.contained.equals(contained);
    }

    public void draw() {
        int i;
        this.p.noStroke();
        this.p.fill(this.p.colorManager.getColor("PlaceholderLine"));
        for (i = -this.width / 2; i < this.width / 2; i += 10) {
            this.p.rect(this.positionX + i - 1, this.positionY - this.height / 2 - 1, 2.0f, 2.0f);
            this.p.rect(this.positionX - i - 1, this.positionY + this.height / 2 - 1, 2.0f, 2.0f);
        }
        for (i = -this.height / 2; i < this.height / 2; i += 10) {
            this.p.rect(this.positionX - this.width / 2 - 1, this.positionY - i - 1, 2.0f, 2.0f);
            this.p.rect(this.positionX + this.width / 2 - 1, this.positionY + i - 1, 2.0f, 2.0f);
        }
    }
}

