/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;

public class UIProgressBar
extends UIComponent {
    int color;
    double progress;
    boolean useText;

    public UIProgressBar(BaseApplet p, int positionX, int positionY, int width, int length) {
        super(p, positionX, positionY, width, length);
        this.setDefaultColor();
        this.progress = 0.0;
    }

    public void setProgress(double value) {
        this.progress = value;
    }

    public void setUseText(boolean value) {
        this.useText = value;
    }

    public void setColor(int value) {
        this.color = value;
    }

    public void setDefaultColor() {
        this.color = this.p.colorManager.getColor("ProgressBar");
    }

    public void draw() {
        this.p.noStroke();
        this.p.fill(this.color);
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, (int)((double)this.width * this.progress), this.height);
        this.p.noFill();
        this.p.noStroke();
        this.p.stroke(0);
        this.p.strokeWeight(1.0f);
        this.p.strokeCap(2);
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, this.width, this.height);
        this.p.noFill();
        this.p.noStroke();
        if (this.useText) {
            this.p.fill(this.p.colorManager.getColor("Font_ProgressBar"));
            this.p.textFont(this.p.fontManager.getFont("Base"));
            int tY = this.positionY + (int)(this.p.fontManager.getFontHeight("Base") / 2.0f);
            this.p.textAlign(3);
            this.p.text((int)(this.progress * 100.0) + "%", (float)this.positionX, (float)tY);
        }
    }
}

