/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;

public class UIQuickInfoLabel
extends UIComponent {
    String caption;
    final int timeout = 2500;
    int timer;
    float textHeight;

    public UIQuickInfoLabel(BaseApplet p, int positionX, int positionY, int width, int height) {
        super(p, positionX, positionY, width, height);
        this.textHeight = p.fontManager.getFontHeight("Small");
        this.caption = "";
        this.timer = -1;
    }

    public UIQuickInfoLabel(BaseApplet p, int positionX, int positionY, int width) {
        super(p);
        this.positionX = positionX;
        this.positionY = positionY;
        this.width = width;
        this.textHeight = p.fontManager.getFontHeight("Small");
        this.height = (int)Math.ceil(this.textHeight) + 6;
        this.caption = "";
        this.timer = -1;
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.timer = this.p.millis();
    }

    public void draw() {
        if (this.timer == -1) {
            return;
        }
        if (this.p.millis() - this.timer > 2500) {
            this.timer = -1;
            return;
        }
        this.p.noStroke();
        this.p.strokeCap(2);
        this.p.fill(this.p.colorManager.getColor("QuickInfoLabel"));
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, this.width, this.height);
        this.p.fill(this.p.colorManager.getColor("Font_QuickInfoLabel"));
        this.p.textFont(this.p.fontManager.getFont("Small"));
        this.p.textAlign(37);
        this.p.text(this.caption, (float)(this.positionX - this.width / 2 + 5), (float)this.positionY + this.textHeight / 4.0f);
        this.p.noFill();
        this.p.noStroke();
    }
}

