/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIComponent;

public class UISlider
extends UIComponent {
    int selectionX;
    int selectionY;
    float minValue;
    float maxValue;
    float value;
    State state;
    Type type;
    final int selectionSize = 10;

    public UISlider(BaseApplet p, int positionX, int positionY, int size, Type type) {
        super(p);
        this.type = type;
        this.positionX = positionX;
        this.positionY = positionY;
        if (type == Type.HORIZONTAL_GRADIENT || type == Type.HORIZONTAL_STATE) {
            this.selectionX = positionX - size / 2;
            this.selectionY = positionY;
            this.width = size;
            this.height = 10;
        } else {
            this.selectionX = positionX;
            this.selectionY = positionY - size / 2;
            this.width = 10;
            this.height = size;
        }
        this.value = 0.0f;
        this.state = State.INACTIVE;
        this.minValue = 0.0f;
        this.maxValue = 1.0f;
    }

    public boolean isMouseOverRange() {
        return this.p.mouseX >= this.positionX - this.width / 2 && this.p.mouseX <= this.positionX + this.width / 2 && this.p.mouseY >= this.positionY - this.height / 2 && this.p.mouseY <= this.positionY + this.height / 2;
    }

    public boolean isMouseOverSelection() {
        return this.p.mouseX >= this.selectionX - 5 && this.p.mouseX <= this.selectionX + 5 && this.p.mouseY >= this.selectionY - 5 && this.p.mouseY <= this.selectionY + 5;
    }

    public float getValueFromSliderPos() {
        float result = this.type == Type.HORIZONTAL_GRADIENT || this.type == Type.HORIZONTAL_STATE ? 0.5f + (float)(this.selectionX - this.positionX) / (float)this.width : 0.5f + (float)(this.selectionY - this.positionY) / (float)this.height;
        result = this.minValue + result * (this.maxValue - this.minValue);
        return result;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
    }

    public void setMinValue(float value) {
        this.minValue = value;
    }

    public void setValue(float value) {
        float nrmValue = 0.0f;
        if (this.maxValue - this.minValue > 0.0f) {
            nrmValue = (value - this.minValue) / (this.maxValue - this.minValue);
        }
        if (this.type == Type.HORIZONTAL_GRADIENT || this.type == Type.HORIZONTAL_STATE) {
            this.selectionX = (int)((float)this.width * (nrmValue - 0.5f) + (float)this.positionX);
        } else {
            this.selectionY = (int)((float)this.height * (nrmValue - 0.5f) + (float)this.positionY);
        }
    }

    public void draw() {
        this.p.stroke(0);
        this.p.strokeWeight(2.0f);
        this.p.strokeCap(2);
        this.p.fill(this.p.colorManager.getColor("SliderRange"));
        if (this.type == Type.HORIZONTAL_GRADIENT || this.type == Type.HORIZONTAL_STATE) {
            this.p.line(this.positionX - this.width / 2, this.positionY, this.positionX + this.width / 2, this.positionY);
        } else {
            this.p.line(this.positionX, this.positionY - this.height / 2, this.positionX, this.positionY + this.height / 2);
        }
        this.p.strokeWeight(1.0f);
        if (this.state == State.ACTIVE) {
            this.p.fill(this.p.colorManager.getColor("SliderKnobActive"));
        } else {
            this.p.fill(this.p.colorManager.getColor("SliderKnobInactive"));
        }
        this.p.ellipse(this.selectionX, this.selectionY, 10.0f, 10.0f);
        this.p.fill(this.p.colorManager.getColor("Font_Slider"));
        this.p.textFont(this.p.fontManager.getFont("Base"));
        this.p.textAlign(3);
        this.p.noFill();
        this.p.noStroke();
    }

    public float getValue() {
        if (this.state == State.INACTIVE) {
            return this.value;
        }
        return 0.0f;
    }

    public State getState() {
        return this.state;
    }

    public void enable() {
        this.state = State.ACTIVE;
    }

    public void disable() {
        this.state = State.DISABLED;
    }

    public void mousePressed() {
        if (this.state == State.DISABLED) {
            return;
        }
        this.state = this.isMouseOverSelection() ? State.ACTIVE : State.INACTIVE;
    }

    public void mouseReleased() {
        if (this.state == State.DISABLED) {
            return;
        }
        if (this.isMouseOverRange()) {
            if (this.type == Type.HORIZONTAL_GRADIENT) {
                this.selectionX = this.p.mouseX;
            } else if (this.type == Type.VERTICAL_GRADIENT) {
                this.selectionY = this.p.mouseY;
            }
        }
        this.state = State.INACTIVE;
    }

    public void mouseDragged() {
        if (this.state == State.ACTIVE) {
            if (this.type == Type.HORIZONTAL_GRADIENT) {
                this.selectionX = this.p.mouseX > this.positionX + this.width / 2 ? this.positionX + this.width / 2 : (this.p.mouseX < this.positionX - this.width / 2 ? this.positionX - this.width / 2 : this.p.mouseX);
            } else if (this.type == Type.VERTICAL_GRADIENT) {
                this.selectionY = this.p.mouseY > this.positionY + this.height / 2 ? this.positionY + this.height / 2 : (this.p.mouseY < this.positionY - this.height / 2 ? this.positionY - this.height / 2 : this.p.mouseY);
            }
        } else {
            this.state = State.INACTIVE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        HORIZONTAL_GRADIENT,
        HORIZONTAL_STATE,
        VERTICAL_GRADIENT,
        VERTICAL_STATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DISABLED,
        INACTIVE,
        ACTIVE;

    }
}

