/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIButton;

public class UITextField
extends UIButton {
    boolean allowSpecialChars = false;

    public UITextField(BaseApplet p, String caption, int positionX, int positionY, int width, int height) {
        this(p, caption, positionX, positionY, width);
        this.height = height;
    }

    public UITextField(BaseApplet p, String caption, int positionX, int positionY, int width) {
        this(p, caption, positionX, positionY);
        this.width = width;
    }

    public UITextField(BaseApplet p, String caption, int positionX, int positionY, int width, int height, String fontname) {
        this(p, caption, positionX, positionY, width, fontname);
        this.height = height;
        this.setFont(fontname);
    }

    public UITextField(BaseApplet p, String caption, int positionX, int positionY, int width, String fontname) {
        this(p, caption, positionX, positionY, fontname);
        this.width = width;
        this.setFont(fontname);
    }

    public UITextField(BaseApplet p, String caption, int positionX, int positionY, String fontname) {
        this(p, caption, positionX, positionY);
        this.setFont(fontname);
        this.computeWidth();
    }

    public UITextField(BaseApplet p, String caption, int positionX, int positionY) {
        super(p, caption, positionX, positionY);
    }

    public void setAllowSpecialChars(boolean value) {
        this.allowSpecialChars = value;
    }

    public void update() {
        if (this.state == UIButton.State.DISABLED) {
            return;
        }
        if (this.p.mousePressed) {
            this.state = this.isMouseOver() ? UIButton.State.OVER : UIButton.State.UP;
        }
    }

    public void keyTyped() {
        if (this.state == UIButton.State.OVER) {
            if (this.p.key == '\b') {
                if (!this.caption.isEmpty()) {
                    this.caption = this.caption.substring(0, this.caption.length() - 1);
                }
            } else if (this.p.key == '\r') {
                this.state = UIButton.State.UP;
            } else if (this.p.key >= 'a' && this.p.key <= 'z' || this.p.key >= 'A' && this.p.key <= 'Z' || this.p.key >= '0' && this.p.key <= '9' || this.p.key == ' ') {
                this.caption = this.caption + this.p.key;
            } else if (this.allowSpecialChars) {
                this.caption = this.caption + this.p.key;
            }
        }
    }
}

