/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import ui.BaseApplet;
import ui.components.UIButton;

public class UIToggleButton
extends UIButton {
    boolean toggledOn = false;

    public UIToggleButton(BaseApplet p, String caption, int positionX, int positionY, int width, int height) {
        super(p, caption, positionX, positionY, width, height);
    }

    public UIToggleButton(BaseApplet p, String caption, int positionX, int positionY, int width) {
        super(p, caption, positionX, positionY, width);
    }

    public UIToggleButton(BaseApplet p, String caption, int positionX, int positionY, int width, int height, String fontname) {
        super(p, caption, positionX, positionY, width, height, fontname);
    }

    public UIToggleButton(BaseApplet p, String caption, int positionX, int positionY, int width, String fontname) {
        super(p, caption, positionX, positionY, width, fontname);
    }

    public UIToggleButton(BaseApplet p, String caption, int positionX, int positionY, String fontname) {
        super(p, caption, positionX, positionY, fontname);
    }

    public UIToggleButton(BaseApplet p, String caption, int positionX, int positionY) {
        super(p, caption, positionX, positionY);
    }

    public void setToggle(boolean value) {
        this.toggledOn = value;
    }

    public boolean isToggledOn() {
        return this.toggledOn;
    }

    public void draw() {
        this.p.stroke(0);
        this.p.strokeWeight(1.0f);
        this.p.strokeCap(2);
        if (this.state == UIButton.State.DISABLED) {
            this.p.fill(this.p.colorManager.getColor("ButtonDisabled"));
        } else if (this.state == UIButton.State.OVER) {
            if (this.toggledOn) {
                this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
            } else {
                this.p.fill(this.p.colorManager.getColor("ButtonOver"));
            }
        } else if (this.state == UIButton.State.PRESSED) {
            this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
        } else if (this.toggledOn) {
            this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
        } else {
            this.p.fill(this.p.colorManager.getColor("ButtonUp"));
        }
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, this.width, this.height);
        if (this.state == UIButton.State.DISABLED) {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonDisabled"));
        } else if (this.state == UIButton.State.OVER) {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonOver"));
        } else if (this.state == UIButton.State.PRESSED) {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonPressed"));
        } else {
            this.p.fill(this.p.colorManager.getColor("Font_ButtonUp"));
        }
        this.p.textFont(this.p.fontManager.getFont(this.fontname));
        this.p.textAlign(3);
        this.p.text(this.caption, (float)this.positionX, (float)this.positionY + this.textHeight / 4.0f);
        this.p.noFill();
        this.p.noStroke();
    }

    public void update() {
        if (this.state == UIButton.State.DISABLED) {
            return;
        }
        if (this.p.mousePressed) {
            this.state = UIButton.State.DOWN;
        } else if (this.isMouseOver()) {
            if (this.state == UIButton.State.DOWN) {
                this.state = UIButton.State.PRESSED;
                this.toggledOn = !this.toggledOn;
            } else {
                this.state = UIButton.State.OVER;
            }
        } else {
            this.state = UIButton.State.UP;
        }
    }
}

