/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIToggleButton;
import ui.components.UIToggleButtonMultiGroup;
import util.statics.LogManager;

public class UIToggleButtonGroup
extends UIToggleButtonMultiGroup {
    boolean allowUnselected;
    int selectedIndex;

    public UIToggleButtonGroup(BaseApplet p, int positionX, int positionY, int buttonWidth, int buttonHeight) {
        this(p, positionX, positionY, buttonWidth, buttonHeight, false);
    }

    public UIToggleButtonGroup(BaseApplet p, int positionX, int positionY, int buttonWidth, int buttonHeight, boolean allowUnselected) {
        super(p, positionX, positionY, buttonWidth, buttonHeight);
    }

    public void addButton(String buttonCaption) {
        super.addButton(buttonCaption);
        this.setSelectedIndex(this.buttons.size() - 1);
    }

    public void addButtonNextLine(String buttonCaption) {
        super.addButtonNextLine(buttonCaption);
        this.setSelectedIndex(this.buttons.size() - 1);
    }

    public void addButtonImage(PImage img, boolean useFrame) {
        super.addButtonImage(img, useFrame);
        this.setSelectedIndex(this.buttons.size() - 1);
    }

    public void addButtonImageNextLine(PImage img, boolean useFrame) {
        super.addButtonImageNextLine(img, useFrame);
        this.setSelectedIndex(this.buttons.size() - 1);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedCaption() {
        return ((UIToggleButton)this.buttons.get((int)this.selectedIndex)).caption;
    }

    public void setAllowUnselected(boolean allowUnselected) {
        this.allowUnselected = allowUnselected;
    }

    public void setSelectedIndex(int value) {
        if (value == -1 && !this.allowUnselected) {
            LogManager.writeError("Error", this, "allowing unselected is not allowed");
            return;
        }
        this.selectedIndex = value;
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (i == this.selectedIndex) {
                ((UIToggleButton)this.buttons.get(i)).setToggle(true);
                continue;
            }
            ((UIToggleButton)this.buttons.get(i)).setToggle(false);
        }
    }

    public void update() {
        int index = -1;
        int backupIndex = -1;
        int prevIndex = this.selectedIndex;
        for (int i = 0; i < this.buttons.size(); ++i) {
            UIToggleButton b = (UIToggleButton)this.buttons.get(i);
            boolean prevState = b.isToggledOn();
            b.update();
            if (!prevState && b.isToggledOn()) {
                index = i;
                continue;
            }
            if (!b.isToggledOn()) continue;
            backupIndex = i;
        }
        if (this.allowUnselected) {
            if (index != -1) {
                this.setSelectedIndex(index);
            } else {
                this.setSelectedIndex(backupIndex);
            }
        } else if (!this.allowUnselected) {
            if (index != -1) {
                this.setSelectedIndex(index);
            } else {
                this.setSelectedIndex(prevIndex);
            }
        }
    }
}

