/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIToggleButton;

public class UIToggleButtonImage
extends UIToggleButton {
    PImage img;
    boolean useFrame;
    int mouseOverTint;
    int toggledTint;

    public UIToggleButtonImage(BaseApplet p, String filename, int positionX, int positionY, int width, int height) {
        this(p, p.loadImage(filename), positionX, positionY, width, height);
    }

    public UIToggleButtonImage(BaseApplet p, String filename, int positionX, int positionY) {
        this(p, p.loadImage(filename), positionX, positionY);
    }

    public UIToggleButtonImage(BaseApplet p, PImage image, int positionX, int positionY, int width, int height) {
        super(p, "", positionX, positionY, width, height);
        this.img = image;
        this.img.resize(width, height);
        this.init();
    }

    public UIToggleButtonImage(BaseApplet p, PImage image, int positionX, int positionY) {
        super(p, "", positionX, positionY);
        this.img = image;
        this.width = this.img.width;
        this.height = this.img.height;
        this.init();
    }

    protected void init() {
        this.useFrame = true;
        this.mouseOverTint = this.p.colorManager.getColor("ImageButtonOverTint");
        this.toggledTint = this.p.colorManager.getColor("ImageButtonToggledTint");
    }

    public PImage getImage() {
        return this.img;
    }

    public void setImage(PImage img, boolean resize) {
        this.img = this.p.createImage(img.width, img.height, img.format);
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                this.img.set(x, y, img.get(x, y));
            }
        }
        if (resize) {
            this.img.resize(this.width, this.height);
        } else {
            this.width = img.width;
            this.height = img.height;
        }
    }

    public void setImage(String filename, boolean resize) {
        this.setImage(this.p.loadImage(filename), resize);
    }

    public void setToggledTint(int r, int g, int b) {
        this.setToggledTint(this.p.color(r, g, b));
    }

    public void setToggledTint(int color) {
        this.toggledTint = color;
    }

    public void setMouseOverTint(int r, int g, int b) {
        this.setMouseOverTint(this.p.color(r, g, b));
    }

    public void setMouseOverTint(int color) {
        this.mouseOverTint = color;
    }

    public void setUseFrame(boolean value) {
        this.useFrame = value;
    }

    public void draw() {
        if (this.useFrame) {
            this.p.stroke(0);
            this.p.strokeWeight(1.0f);
            this.p.strokeCap(2);
            if (this.state == UIButton.State.DISABLED) {
                this.p.fill(this.p.colorManager.getColor("ButtonDisabled"));
            } else if (this.state == UIButton.State.OVER) {
                if (this.toggledOn) {
                    this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
                } else {
                    this.p.fill(this.p.colorManager.getColor("ButtonOver"));
                }
            } else if (this.state == UIButton.State.PRESSED) {
                this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
            } else if (this.toggledOn) {
                this.p.fill(this.p.colorManager.getColor("ButtonPressed"));
            } else {
                this.p.fill(this.p.colorManager.getColor("ButtonUp"));
            }
            if (this.state == UIButton.State.DISABLED) {
                this.p.stroke(this.p.colorManager.getColor("ImageButtonDisabledTint"));
            } else if (this.isToggledOn()) {
                this.p.stroke(this.toggledTint);
            } else if (this.state == UIButton.State.OVER) {
                this.p.stroke(this.mouseOverTint);
            }
            this.p.rect(this.positionX - this.width / 2 - 1, this.positionY - this.height / 2 - 1, this.width + 1, this.height + 1);
            this.p.noTint();
        } else if (this.state == UIButton.State.DISABLED) {
            this.p.tint(this.p.colorManager.getColor("ImageButtonDisabledTint"));
        } else if (this.isToggledOn()) {
            this.p.tint(this.toggledTint);
        } else if (this.state == UIButton.State.OVER) {
            this.p.tint(this.mouseOverTint);
        }
        this.p.imageMode(3);
        this.p.image(this.img, this.positionX, this.positionY);
        this.p.noTint();
        this.p.noFill();
        this.p.noStroke();
    }
}

