/*
 * Decompiled with CFR 0.152.
 */
package ui.components;

import java.util.Vector;
import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIComponent;
import ui.components.UIToggleButton;
import ui.components.UIToggleButtonImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIToggleButtonMultiGroup
extends UIComponent {
    Vector<UIToggleButton> buttons;
    int currPositionX;
    int currPositionY;
    int buttonWidth;
    int buttonHeight;
    int offset = 5;

    public UIToggleButtonMultiGroup(BaseApplet p, int positionX, int positionY, int buttonWidth, int buttonHeight) {
        super(p, positionX, positionY, 0, 0);
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
        this.currPositionX = positionX;
        this.currPositionY = positionY;
        this.buttons = new Vector();
    }

    public void addButton(String buttonCaption) {
        this.currPositionX = this.buttons.isEmpty() ? this.positionX : this.currPositionX + (this.buttonWidth + this.offset);
        this.currPositionY = this.buttons.isEmpty() ? this.positionY : this.currPositionY;
        this.buttons.add(new UIToggleButton(this.p, buttonCaption, this.currPositionX, this.currPositionY, this.buttonWidth, this.buttonHeight));
    }

    public void addButtonNextLine(String buttonCaption) {
        this.currPositionX = this.positionX;
        this.currPositionY = this.buttons.isEmpty() ? this.positionY : this.currPositionY + (this.buttonHeight + this.offset);
        this.buttons.add(new UIToggleButton(this.p, buttonCaption, this.currPositionX, this.currPositionY, this.buttonWidth, this.buttonHeight));
    }

    public void addButtonImage(String filename, boolean useFrame) {
        this.addButtonImage(this.p.loadImage(filename), "", useFrame);
    }

    public void addButtonImage(String filename, String caption, boolean useFrame) {
        this.addButtonImage(this.p.loadImage(filename), caption, useFrame);
    }

    public void addButtonImage(PImage img, boolean useFrame) {
        this.addButtonImage(img, "", useFrame);
    }

    public void addButtonImage(PImage img, String caption, boolean useFrame) {
        this.currPositionX = this.buttons.isEmpty() ? this.positionX : this.currPositionX + (this.buttonWidth + this.offset);
        this.currPositionY = this.buttons.isEmpty() ? this.positionY : this.currPositionY;
        UIToggleButtonImage uitbi = new UIToggleButtonImage(this.p, img, this.currPositionX, this.currPositionY, this.buttonWidth, this.buttonHeight);
        uitbi.setCaption(caption);
        uitbi.setUseFrame(useFrame);
        this.buttons.add(uitbi);
    }

    public void addButtonImageNextLine(String filename, boolean useFrame) {
        this.addButtonImageNextLine(this.p.loadImage(filename), "", useFrame);
    }

    public void addButtonImageNextLine(String filename, String caption, boolean useFrame) {
        this.addButtonImageNextLine(this.p.loadImage(filename), caption, useFrame);
    }

    public void addButtonImageNextLine(PImage img, boolean useFrame) {
        this.addButtonImageNextLine(img, "", useFrame);
    }

    public void addButtonImageNextLine(PImage img, String caption, boolean useFrame) {
        this.currPositionX = this.positionX;
        this.currPositionY = this.buttons.isEmpty() ? this.positionY : this.currPositionY + (this.buttonHeight + this.offset);
        UIToggleButtonImage uitbi = new UIToggleButtonImage(this.p, img, this.currPositionX, this.currPositionY, this.buttonWidth, this.buttonHeight);
        uitbi.setCaption(caption);
        uitbi.setUseFrame(useFrame);
        this.buttons.add(uitbi);
    }

    public void addHorizontalSpacing(int offsetX) {
        this.currPositionX += offsetX;
    }

    public void addVerticalSpacing(int offsetY) {
        this.currPositionY += offsetY;
    }

    public void clear() {
        this.buttons.clear();
    }

    public int size() {
        return this.buttons.size();
    }

    public UIToggleButton getButton(int index) {
        if (index < 0 || index >= this.buttons.size()) {
            return null;
        }
        return this.buttons.get(index);
    }

    public void setSelectedNone() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setToggle(false);
        }
    }

    public void setSelectedAll() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setToggle(false);
        }
    }

    public void setSelected(int selectedIndex) {
        if (selectedIndex >= 0 && selectedIndex < this.buttons.size()) {
            this.buttons.get(selectedIndex).setToggle(true);
        }
    }

    public void setSelected(String selectedCaption) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).getCaption().equalsIgnoreCase(selectedCaption)) continue;
            this.buttons.get(i).setToggle(true);
        }
    }

    public void setOnlySelected(int selectedIndex) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (i == selectedIndex) {
                this.buttons.get(i).setToggle(true);
                continue;
            }
            this.buttons.get(i).setToggle(false);
        }
    }

    public void setOnlySelected(String selectedCaption) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (this.buttons.get(i).getCaption().equalsIgnoreCase(selectedCaption)) {
                this.buttons.get(i).setToggle(true);
                continue;
            }
            this.buttons.get(i).setToggle(false);
        }
    }

    public void setOffset(int value) {
        this.offset = value;
    }

    public Vector<Integer> getSelectedIndexes() {
        Vector<Integer> result = new Vector<Integer>();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isToggledOn()) continue;
            result.add(i);
        }
        return result;
    }

    public boolean isSelected(int index) {
        if (index >= 0 && index < this.buttons.size()) {
            return this.buttons.get(index).isToggledOn();
        }
        return false;
    }

    public boolean isAnySelected() {
        return !this.getSelectedIndexes().isEmpty();
    }

    @Override
    public void draw() {
        for (UIToggleButton b : this.buttons) {
            b.draw();
        }
    }

    @Override
    public boolean isMouseOver() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isOver(this.p.mouseX, this.p.mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).update();
        }
    }

    @Override
    public void mouseClicked() {
        this.update();
    }

    @Override
    public void mousePressed() {
        this.update();
    }

    @Override
    public void mouseReleased() {
        this.update();
    }
}

