/*
 * Decompiled with CFR 0.152.
 */
package ui.screens;

import java.util.Iterator;
import ui.BaseApplet;
import ui.components.UIComponent;
import ui.screens.UIContainer;

public class Popup
extends UIContainer {
    protected float textHeight;
    protected String ID;
    protected String caption;

    public Popup(BaseApplet p, String ID, String caption) {
        super(p);
        int totalWidth;
        this.positionX = p.width / 2;
        this.positionY = p.height / 2;
        this.ID = ID;
        this.caption = caption;
        p.textFont(p.fontManager.getFont("Base"));
        this.textHeight = p.fontManager.getFontHeight("Base");
        this.height = (int)Math.ceil(this.textHeight) + 6;
        if ((double)totalWidth >= 0.7 * (double)p.width) {
            for (totalWidth = (int)p.textWidth(caption); totalWidth > p.width / 2; totalWidth -= p.width / 2) {
                this.height = (int)((float)this.height + this.textHeight);
            }
            this.width = p.width / 2 + 10;
        } else {
            this.width = totalWidth + 10;
        }
    }

    public void draw() {
        this.p.noStroke();
        this.p.fill(this.p.colorManager.getColor("PopupCover"));
        this.p.rect(0.0f, 0.0f, this.p.width, this.p.height);
        this.p.noFill();
        this.p.noStroke();
        this.p.stroke(0.0f, 0.0f, 0.0f);
        this.p.fill(this.p.colorManager.getColor("Background"));
        this.p.rect(this.positionX - this.width / 2, this.positionY - this.height / 2, this.width, this.height);
        Iterator<UIComponent> c_it = this.getDrawIterator();
        while (c_it.hasNext()) {
            UIComponent c = c_it.next();
            c.draw();
        }
        this.p.noStroke();
        this.p.noFill();
        this.p.fill(0);
        this.p.textFont(this.p.fontManager.getFont("Base"));
        this.p.text(this.caption, (float)(this.positionX - this.width / 2), (float)(this.positionY - this.height / 2) + this.textHeight / 4.0f, (float)this.width, (float)this.height);
    }

    public void mouseClicked() {
        if (this.isMouseOver()) {
            super.mouseClicked();
        } else {
            this.p.getScreen().resolvePopup(this, -1);
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public String getID() {
        return this.ID;
    }
}

