/*
 * Decompiled with CFR 0.152.
 */
package ui.screens;

import java.util.Vector;
import ui.BaseApplet;
import ui.screens.Popup;
import ui.screens.UIContainer;

public abstract class Screen
extends UIContainer {
    protected Vector<Popup> popups = new Vector();

    public Screen(BaseApplet p) {
        super(p);
    }

    public void draw() {
        this.p.background(this.p.colorManager.getColor("Background"));
        super.draw();
        if (!this.popups.isEmpty()) {
            this.popups.lastElement().draw();
        }
    }

    public boolean hasFocus() {
        return this.popups.isEmpty();
    }

    public void addPopup(Popup popup) {
        this.update();
        this.popups.add(popup);
    }

    public void resolvePopup(Popup popup, int option) {
        boolean b = this.popups.remove(popup);
        this.update();
    }

    public void mouseClicked() {
        if (this.popups.isEmpty()) {
            super.mouseClicked();
        } else {
            this.popups.lastElement().mouseClicked();
        }
    }

    public void mouseMoved() {
        if (this.popups.isEmpty()) {
            super.mouseMoved();
        } else {
            this.popups.lastElement().mouseMoved();
        }
    }

    public void mouseDragged() {
        if (this.popups.isEmpty()) {
            super.mouseDragged();
        } else {
            this.popups.lastElement().mouseDragged();
        }
    }

    public void mousePressed() {
        if (this.popups.isEmpty()) {
            super.mousePressed();
        } else {
            this.popups.lastElement().mousePressed();
        }
    }

    public void mouseReleased() {
        if (this.popups.isEmpty()) {
            super.mouseReleased();
        } else {
            this.popups.lastElement().mouseReleased();
        }
    }

    public void keyPressed() {
        if (this.popups.isEmpty()) {
            super.keyPressed();
        } else {
            this.popups.lastElement().keyPressed();
        }
    }

    public void keyReleased() {
        if (this.popups.isEmpty()) {
            super.keyReleased();
        } else {
            this.popups.lastElement().keyReleased();
        }
    }

    public void keyTyped() {
        if (this.popups.isEmpty()) {
            super.keyTyped();
        } else {
            this.popups.lastElement().keyTyped();
        }
    }

    public void resolveScreenChanged() {
        if (this.popups.isEmpty()) {
            super.resolveScreenChanged();
        } else {
            this.popups.clear();
        }
    }

    public void resolveScreenRestored() {
        if (this.popups.isEmpty()) {
            super.resolveScreenRestored();
        } else {
            this.popups.clear();
        }
    }
}

