/*
 * Decompiled with CFR 0.152.
 */
package ui.screens;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import ui.BaseApplet;
import ui.components.UIComponent;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIContainer
extends UIComponent {
    private Hashtable<String, UIComponent> components = new Hashtable();
    private Vector<UIComponent> drawnComponents = new Vector();

    public UIContainer(BaseApplet p) {
        super(p);
    }

    public boolean containsKey(String key) {
        return this.components.containsKey(key);
    }

    @Override
    public void draw() {
        for (UIComponent c : this.drawnComponents) {
            c.draw();
        }
    }

    public Iterator<UIComponent> getDrawIterator() {
        return this.drawnComponents.iterator();
    }

    public void addComponent(String id, UIComponent component) {
        this.components.put(id, component);
        this.drawnComponents.add(component);
    }

    public UIComponent getComponent(String key) {
        return this.components.get(key);
    }

    public String getComponentID(UIComponent component) {
        if (component == null) {
            return "";
        }
        for (Map.Entry<String, UIComponent> entry : this.components.entrySet()) {
            if (!component.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return "";
    }

    public boolean isHidden(String key) {
        UIComponent c = this.components.get(key);
        if (c == null) {
            LogManager.writeError("Error", this, "Component " + key + " not found");
            return true;
        }
        return this.isHidden(c);
    }

    public boolean isHidden(UIComponent component) {
        return !this.drawnComponents.contains(component);
    }

    public void show(String key) {
        UIComponent c = this.components.get(key);
        if (c == null) {
            LogManager.writeError("Error", this, "Component " + key + " not found");
        }
        this.show(c);
    }

    public void show(UIComponent component) {
        if (!this.components.contains(component)) {
            LogManager.writeError("Error", this, "Shown component does not exist in components list");
            return;
        }
        if (!this.drawnComponents.contains(component)) {
            component.resolveShow();
            this.drawnComponents.add(component);
        }
    }

    public void hide(String key) {
        UIComponent c = this.components.get(key);
        if (c == null) {
            LogManager.writeError("Error", this, "UIContainer: component " + key + " not found");
        }
        this.hide(c);
    }

    public void hide(UIComponent component) {
        if (!this.components.contains(component)) {
            LogManager.writeError("Error", this, "Shown component does not exist in components list");
            return;
        }
        if (this.drawnComponents.contains(component)) {
            component.resolveHide();
            this.drawnComponents.remove(component);
        }
    }

    public void setDrawTop(UIComponent component) {
        if (!this.drawnComponents.contains(component)) {
            LogManager.writeError("Error", this, "Component not currently drawn");
            return;
        }
        this.drawnComponents.remove(component);
        this.drawnComponents.add(component);
    }

    public void setDrawBottom(UIComponent component) {
        int index = this.drawnComponents.indexOf(component);
        if (index == -1) {
            LogManager.writeError("Error", this, "Component not currently drawn");
            return;
        }
        this.drawnComponents.remove(index);
        this.drawnComponents.add(0, component);
    }

    public void setDrawOver(UIComponent component, UIComponent afterComponent) {
        int index = this.drawnComponents.indexOf(component);
        int overIndex = this.drawnComponents.indexOf(afterComponent);
        if (index == -1 || overIndex == -1) {
            LogManager.writeError("Error", this, "Components not currently drawn");
            return;
        }
        this.drawnComponents.remove(index);
        this.drawnComponents.add(0, component);
    }

    public void setDrawUnder(UIComponent component, UIComponent afterComponent) {
        if (!this.drawnComponents.contains(component)) {
            LogManager.writeError("Error", this, "Component not currently drawn");
        }
        this.drawnComponents.remove(component);
        this.drawnComponents.add(0, component);
    }

    @Override
    public void update() {
        for (UIComponent c : this.drawnComponents) {
            c.update();
        }
    }

    @Override
    public void mouseClicked() {
        for (UIComponent c : this.drawnComponents) {
            c.mouseClicked();
        }
    }

    @Override
    public void mouseMoved() {
        for (UIComponent c : this.drawnComponents) {
            c.mouseMoved();
        }
    }

    @Override
    public void mouseDragged() {
        for (UIComponent c : this.drawnComponents) {
            c.mouseDragged();
        }
    }

    @Override
    public void mousePressed() {
        for (UIComponent c : this.drawnComponents) {
            c.mousePressed();
        }
    }

    @Override
    public void mouseReleased() {
        for (UIComponent c : this.drawnComponents) {
            c.mouseReleased();
        }
    }

    @Override
    public void keyPressed() {
        for (UIComponent c : this.drawnComponents) {
            c.keyPressed();
        }
    }

    @Override
    public void keyReleased() {
        for (UIComponent c : this.drawnComponents) {
            c.keyReleased();
        }
    }

    @Override
    public void keyTyped() {
        for (UIComponent c : this.drawnComponents) {
            c.keyTyped();
        }
    }

    @Override
    public void resolveScreenChanged() {
        for (UIComponent c : this.drawnComponents) {
            c.resolveScreenChanged();
        }
    }

    @Override
    public void resolveScreenRestored() {
        for (UIComponent c : this.drawnComponents) {
            c.resolveScreenRestored();
        }
    }
}

