/*
 * Decompiled with CFR 0.152.
 */
package ai.pathfinder;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import java.util.ArrayList;

public class Pathfinder {
    public ArrayList nodes;
    public ArrayList open = new ArrayList();
    public ArrayList closed = new ArrayList();
    public boolean wrap = false;
    public boolean corners = true;
    public boolean manhattan = false;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float offsetZ = 0.0f;

    public Pathfinder() {
        this.nodes = new ArrayList();
    }

    public Pathfinder(ArrayList nodes) {
        this.nodes = nodes;
    }

    public Pathfinder(int w, int h, float scale) {
        this.setCuboidNodes(w, h, scale);
    }

    public Pathfinder(int w, int h, int d, float scale) {
        this.setCuboidNodes(w, h, d, scale);
    }

    public ArrayList aStar(Node start, Node finish) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            n.reset();
            ++i;
        }
        this.open.clear();
        this.closed.clear();
        this.open.add(start);
        while (this.open.size() > 0) {
            float lowest = Float.MAX_VALUE;
            int c = -1;
            int i2 = 0;
            while (i2 < this.open.size()) {
                Node temp = (Node)this.open.get(i2);
                if (temp.f < lowest) {
                    lowest = temp.f;
                    c = i2;
                }
                ++i2;
            }
            Node current = (Node)this.open.remove(c);
            this.closed.add(current);
            if (current == finish) break;
            int i3 = 0;
            while (i3 < current.links.size()) {
                Connector a = (Connector)current.links.get(i3);
                Node adjacent = a.n;
                if (adjacent.walkable && !this.arrayListContains(this.closed, adjacent)) {
                    if (!this.arrayListContains(this.open, adjacent)) {
                        this.open.add(adjacent);
                        adjacent.parent = current;
                        adjacent.setG(a);
                        if (this.manhattan) {
                            adjacent.MsetF(finish);
                        } else {
                            adjacent.setF(finish);
                        }
                    } else if (adjacent.g > current.g + a.d) {
                        adjacent.parent = current;
                        adjacent.setG(a);
                        if (this.manhattan) {
                            adjacent.MsetF(finish);
                        } else {
                            adjacent.setF(finish);
                        }
                    }
                }
                ++i3;
            }
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Node pathNode = finish;
        while (pathNode != null) {
            path.add(pathNode);
            pathNode = pathNode.parent;
        }
        Node test = (Node)path.get(path.size() - 1);
        if (test == finish) {
            float leastDist = Float.MAX_VALUE;
            Node bestNode = null;
            int i4 = 0;
            while (i4 < this.closed.size()) {
                Node n = (Node)this.closed.get(i4);
                float nDist = n.dist(finish);
                if (nDist < leastDist) {
                    leastDist = nDist;
                    bestNode = n;
                }
                ++i4;
            }
            if (bestNode.parent != null) {
                pathNode = bestNode;
                path = new ArrayList();
                while (pathNode != null) {
                    path.add(pathNode);
                    pathNode = pathNode.parent;
                }
            }
        }
        return path;
    }

    public ArrayList bfs(Node start, Node finish) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            n.reset();
            ++i;
        }
        this.open.clear();
        this.closed.clear();
        this.open.add(start);
        while (this.open.size() > 0) {
            float lowest = Float.MAX_VALUE;
            int c = -1;
            int i2 = 0;
            while (i2 < this.open.size()) {
                Node temp = (Node)this.open.get(i2);
                if (temp.h < lowest) {
                    lowest = temp.h;
                    c = i2;
                }
                ++i2;
            }
            Node current = (Node)this.open.remove(c);
            this.closed.add(current);
            if (current == finish) break;
            int i3 = 0;
            while (i3 < current.links.size()) {
                Connector a = (Connector)current.links.get(i3);
                Node adjacent = a.n;
                if (adjacent.walkable && !this.arrayListContains(this.closed, adjacent) && !this.arrayListContains(this.open, adjacent)) {
                    this.open.add(adjacent);
                    adjacent.parent = current;
                    if (this.manhattan) {
                        adjacent.MsetH(finish);
                    } else {
                        adjacent.setH(finish);
                    }
                }
                ++i3;
            }
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Node pathNode = finish;
        while (pathNode != null) {
            path.add(pathNode);
            pathNode = pathNode.parent;
        }
        Node test = (Node)path.get(path.size() - 1);
        if (test == finish) {
            float leastDist = Float.MAX_VALUE;
            Node bestNode = null;
            int i4 = 0;
            while (i4 < this.closed.size()) {
                Node n = (Node)this.closed.get(i4);
                float nDist = n.dist(finish);
                if (nDist < leastDist) {
                    leastDist = nDist;
                    bestNode = n;
                }
                ++i4;
            }
            if (bestNode.parent != null) {
                pathNode = bestNode;
                path = new ArrayList();
                while (pathNode != null) {
                    path.add(pathNode);
                    pathNode = pathNode.parent;
                }
            }
        }
        return path;
    }

    public void dijkstra(Node start) {
        this.dijkstra(start, null);
    }

    public ArrayList dijkstra(Node start, Node finish) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            n.reset();
            ++i;
        }
        this.open.clear();
        this.closed.clear();
        this.open.add(start);
        start.g = 0.0f;
        while (this.open.size() > 0) {
            Node current = (Node)this.open.remove(0);
            this.closed.add(current);
            if (current == finish) break;
            int i2 = 0;
            while (i2 < current.links.size()) {
                Connector a = (Connector)current.links.get(i2);
                Node adjacent = a.n;
                if (adjacent.walkable && !this.arrayListContains(this.closed, adjacent)) {
                    if (!this.arrayListContains(this.open, adjacent)) {
                        this.open.add(adjacent);
                        adjacent.parent = current;
                        adjacent.setG(a);
                    } else if (adjacent.g > current.g + a.d) {
                        adjacent.parent = current;
                        adjacent.setG(a);
                    }
                }
                ++i2;
            }
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Node pathNode = finish;
        while (pathNode != null) {
            path.add(pathNode);
            pathNode = pathNode.parent;
        }
        return path;
    }

    public ArrayList getPath(Node pathNode) {
        ArrayList<Node> path = new ArrayList<Node>();
        while (pathNode != null) {
            path.add(pathNode);
            pathNode = pathNode.parent;
        }
        return path;
    }

    public void setCuboidNodes(int w, int h, float scale) {
        this.nodes = new ArrayList();
        this.nodes = this.createCuboidNodes(new int[]{w, h}, scale);
    }

    public void setCuboidNodes(int w, int h, int d, float scale) {
        this.nodes = new ArrayList();
        this.nodes = this.createCuboidNodes(new int[]{w, h, d}, scale);
    }

    public void addNodes(ArrayList nodes) {
        this.nodes.addAll(nodes);
    }

    public ArrayList createCuboidNodes(int w, int h, float scale) {
        return this.createCuboidNodes(new int[]{w, h}, scale);
    }

    public ArrayList createCuboidNodes(int w, int h, int d, float scale) {
        return this.createCuboidNodes(new int[]{w, h, d}, scale);
    }

    private ArrayList createCuboidNodes(int[] dim, float scale) {
        Object[] p;
        ArrayList<Node> world = new ArrayList<Node>();
        int totalLength = 1;
        int i = 0;
        while (i < dim.length) {
            if (dim[i] > 0) {
                totalLength *= dim[i];
            }
            ++i;
        }
        i = 0;
        while (i < totalLength) {
            int[] intP = this.getFolded(i, dim);
            p = new float[intP.length];
            int j = 0;
            while (j < p.length) {
                p[j] = (float)intP[j] * scale;
                ++j;
            }
            Node temp = new Node((float[])p);
            temp.x += this.offsetX;
            temp.y += this.offsetY;
            temp.z += this.offsetZ;
            world.add(temp);
            ++i;
        }
        int directions = (int)Math.pow(3.0, dim.length);
        int i2 = 0;
        while (i2 < totalLength) {
            p = this.getFolded(i2, dim);
            Node myNode = (Node)world.get(i2);
            int[] b = new int[p.length];
            int[] w = new int[p.length];
            int j = 0;
            while (j < b.length) {
                b[j] = (int)(p[j] - true);
                w[j] = 0;
                ++j;
            }
            j = 0;
            while (j < directions) {
                Node connectee;
                boolean valid = true;
                int k = 0;
                while (k < dim.length) {
                    if (b[k] > dim[k] - 1 || b[k] < 0) {
                        if (this.wrap) {
                            if (b[k] > dim[k] - 1) {
                                int n = k;
                                b[n] = b[n] - dim[k];
                                int n2 = k;
                                w[n2] = w[n2] - 1;
                            }
                            if (b[k] < 0) {
                                int n = k;
                                b[n] = b[n] + dim[k];
                                int n3 = k;
                                w[n3] = w[n3] + 1;
                            }
                        } else {
                            valid = false;
                        }
                    }
                    if (!this.corners) {
                        int combinations = 0;
                        int l = 0;
                        while (l < dim.length) {
                            if (b[l] != p[l]) {
                                ++combinations;
                            }
                            ++l;
                        }
                        if (combinations > 1) {
                            valid = false;
                        }
                    }
                    ++k;
                }
                if (valid && myNode != (connectee = (Node)world.get(this.getUnfolded(b, dim)))) {
                    myNode.connect(connectee);
                }
                if (this.wrap) {
                    k = 0;
                    while (k < dim.length) {
                        switch (w[k]) {
                            case 1: {
                                int n = k;
                                b[n] = b[n] - dim[k];
                                w[k] = 0;
                                break;
                            }
                            case -1: {
                                int n = k;
                                b[n] = b[n] + dim[k];
                                w[k] = 0;
                            }
                        }
                        ++k;
                    }
                }
                b[0] = b[0] + 1;
                k = 0;
                while (k < b.length - 1) {
                    if (b[k] > p[k] + true) {
                        int n = k + 1;
                        b[n] = b[n] + 1;
                        int n4 = k;
                        b[n4] = b[n4] - 3;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return world;
    }

    public void disconnectUnwalkables() {
        int i = 0;
        while (i < this.nodes.size()) {
            Node temp = (Node)this.nodes.get(i);
            if (!temp.walkable) {
                temp.disconnect();
            }
            ++i;
        }
    }

    public void radialDisconnectUnwalkables() {
        int i = 0;
        while (i < this.nodes.size()) {
            Node temp = (Node)this.nodes.get(i);
            if (!temp.walkable) {
                temp.radialDisconnect();
            }
            ++i;
        }
    }

    public boolean arrayListContains(ArrayList c, Node n) {
        int i = 0;
        while (i < c.size()) {
            Node o = (Node)c.get(i);
            if (o == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(Node n) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node o = (Node)this.nodes.get(i);
            if (o == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getFolded(int n, int[] d) {
        int[] coord = new int[d.length];
        int i = 0;
        while (i < d.length) {
            coord[i] = n;
            int j = d.length - 1;
            while (j > i) {
                int level = 1;
                int k = 0;
                while (k < j) {
                    level *= d[k];
                    ++k;
                }
                int n2 = i;
                coord[n2] = coord[n2] % level;
                --j;
            }
            int level = 1;
            int j2 = 0;
            while (j2 < i) {
                level *= d[j2];
                ++j2;
            }
            int n3 = i++;
            coord[n3] = coord[n3] / level;
        }
        return coord;
    }

    public int getUnfolded(int[] p, int[] d) {
        int coord = 0;
        int i = 0;
        while (i < p.length) {
            int level = 1;
            int j = 0;
            while (j < i) {
                level *= d[j];
                ++j;
            }
            coord += p[i] * level;
            ++i;
        }
        return coord;
    }
}

