/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Gene;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeGene
extends Gene {
    protected Vector<Gene> geneList;

    public CompositeGene(ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.geneList = new Vector();
    }

    public void addGene(Gene other) {
        this.geneList.add(other);
    }

    @Override
    public void randomize() {
        for (int i = 0; i < this.geneList.size(); ++i) {
            this.geneList.get(i).randomize();
        }
    }

    @Override
    public Gene mutate() {
        CompositeGene result = new CompositeGene(this.parameters);
        for (int i = 0; i < this.geneList.size(); ++i) {
            this.geneList.get(i).mutate();
        }
        return result;
    }

    public int size() {
        return this.geneList.size();
    }

    public Gene getGene(int index) {
        return this.geneList.get(index);
    }

    @Override
    public Vector<Gene> produceOffspring(Gene other) {
        if (other instanceof CompositeGene) {
            CompositeGene otherComposite = (CompositeGene)other;
            if (otherComposite.geneList.size() != this.geneList.size()) {
                return null;
            }
            CompositeGene offspring1 = new CompositeGene(this.parameters);
            CompositeGene offspring2 = new CompositeGene(otherComposite.parameters);
            for (int i = 0; i < this.geneList.size(); ++i) {
                Vector<Gene> offspringFragments = this.geneList.get(i).produceOffspring(otherComposite.geneList.get(i));
                if (offspringFragments.size() == 2) {
                    offspring1.addGene(offspringFragments.get(0));
                    offspring2.addGene(offspringFragments.get(1));
                    continue;
                }
                if (offspringFragments.size() == 1) {
                    offspring1.addGene(offspringFragments.get(0));
                    offspring2.addGene(offspringFragments.get(0).clone());
                    continue;
                }
                LogManager.writeError("Error", this, "offspring fragments are invalid");
            }
            Vector<Gene> result = new Vector<Gene>();
            result.add(offspring1);
            result.add(offspring2);
            return result;
        }
        return null;
    }

    @Override
    public String toXML() {
        String result = "<compositeGene>";
        for (int i = 0; i < this.geneList.size(); ++i) {
            result = result + this.geneList.get(i).toXML();
        }
        result = result + "</compositeGene>";
        return result;
    }

    @Override
    public Gene clone() {
        CompositeGene result = new CompositeGene(this.parameters);
        result.geneList = new Vector();
        for (int i = 0; i < this.geneList.size(); ++i) {
            result.geneList.add(this.geneList.get(i).clone());
        }
        return result;
    }

    @Override
    public float getDifference(Gene other) {
        if (other instanceof CompositeGene) {
            CompositeGene otherComposite = (CompositeGene)other;
            if (otherComposite.geneList.size() != this.geneList.size()) {
                return Float.MAX_VALUE;
            }
            float result = 0.0f;
            for (int i = 0; i < this.geneList.size(); ++i) {
                result += this.geneList.get(i).getDifference(otherComposite.geneList.get(i));
            }
            return result /= (float)this.geneList.size();
        }
        return Float.MAX_VALUE;
    }
}

