/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Gene;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandableGene
extends Gene {
    protected Vector<Gene> geneList;
    protected Gene startingGene;

    public ExpandableGene(Gene startingGene, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.startingGene = startingGene.clone();
        this.geneList = new Vector();
    }

    @Override
    public void randomize() {
        this.clearGenes();
        int minimumGenes = 0;
        if (this.parameters.contains("minimumGenes")) {
            minimumGenes = this.parameters.getInteger("minimumGenes");
        }
        this.addRandomGene(minimumGenes);
    }

    public int size() {
        return this.geneList.size();
    }

    public Gene getGene(int index) {
        return this.geneList.get(index);
    }

    public void clearGenes() {
        this.geneList = new Vector();
    }

    public void addGene(Gene toAdd) {
        this.geneList.add(toAdd);
    }

    public void addRandomGene() {
        this.addRandomGene(1);
    }

    public void addRandomGene(int number) {
        for (int i = 0; i < number; ++i) {
            Gene toAdd = this.startingGene.clone();
            toAdd.randomize();
            this.geneList.add(toAdd);
        }
    }

    @Override
    public String toXML() {
        String result = "<expandableGene>";
        for (int i = 0; i < this.geneList.size(); ++i) {
            result = result + this.geneList.get(i).toXML();
        }
        result = result + "</expandableGene>";
        return result;
    }

    @Override
    public Gene clone() {
        ExpandableGene result = new ExpandableGene(this.startingGene.clone(), this.parameters);
        result.geneList = new Vector();
        for (int i = 0; i < this.geneList.size(); ++i) {
            result.geneList.add(this.geneList.get(i).clone());
        }
        return result;
    }

    @Override
    public Vector<Gene> produceOffspring(Gene other) {
        ExpandableGene otherExpandable;
        if (this.geneList.isEmpty()) {
            LogManager.writeError("Error", this, "Gene empty");
        }
        if (other instanceof ExpandableGene) {
            otherExpandable = (ExpandableGene)other;
        } else {
            otherExpandable = new ExpandableGene(other, other.parameters);
            otherExpandable.addGene(other);
        }
        boolean smallestOther = this.geneList.size() > otherExpandable.geneList.size();
        Vector<Gene> base = new Vector<Gene>();
        Vector<Gene> candidates = new Vector<Gene>();
        if (smallestOther) {
            base.addAll(otherExpandable.geneList);
            candidates.addAll(this.geneList);
        } else {
            base.addAll(this.geneList);
            candidates.addAll(otherExpandable.geneList);
        }
        Vector<Gene> offspring1genes = new Vector<Gene>();
        Vector<Gene> offspring2genes = new Vector<Gene>();
        while (!candidates.isEmpty()) {
            int roll = RandomNumberManager.getRandomInt(0, candidates.size());
            Vector<Gene> offspringFragments = ((Gene)base.get(0)).produceOffspring((Gene)candidates.get(roll));
            if (offspringFragments.size() == 2) {
                offspring1genes.add(offspringFragments.get(0));
                offspring2genes.add(offspringFragments.get(1));
            } else if (offspringFragments.size() == 1) {
                offspring1genes.add(offspringFragments.get(0));
                offspring2genes.add(offspringFragments.get(0).clone());
            } else {
                LogManager.writeError("Error", this, "offspring fragments are invalid");
            }
            base.remove(0);
            candidates.remove(roll);
        }
        if (!base.isEmpty()) {
            offspring1genes.addAll(base);
        }
        Vector<Gene> result = new Vector<Gene>();
        ExpandableGene offspring1 = new ExpandableGene((Gene)offspring1genes.firstElement(), this.parameters);
        for (int i = 0; i < offspring1genes.size(); ++i) {
            offspring1.addGene((Gene)offspring1genes.get(i));
        }
        result.add(offspring1);
        ExpandableGene offspring2 = new ExpandableGene((Gene)offspring2genes.firstElement(), this.parameters);
        for (int i = 0; i < offspring2genes.size(); ++i) {
            offspring2.addGene((Gene)offspring2genes.get(i));
        }
        result.add(offspring2);
        return result;
    }

    @Override
    public Gene mutate() {
        int i;
        if (this.geneList.isEmpty()) {
            LogManager.writeError("Error", this, "Gene empty");
        }
        boolean mutateAllGenes = false;
        if (this.parameters.contains("mutateAllGenes")) {
            mutateAllGenes = this.parameters.getBoolean("mutateAllGenes");
        }
        int mutateAddGene = 0;
        if (this.parameters.contains("mutateAddGene")) {
            mutateAddGene = this.parameters.getInteger("mutateAdddGene");
        }
        Vector<Gene> mutatedGenes = new Vector<Gene>();
        if (mutateAllGenes) {
            for (int i2 = 0; i2 < this.geneList.size(); ++i2) {
                mutatedGenes.add(this.geneList.get(i2).mutate());
            }
        } else {
            int geneIndex = RandomNumberManager.getRandomInt(0, this.geneList.size());
            for (i = 0; i < this.geneList.size(); ++i) {
                if (i == geneIndex) {
                    mutatedGenes.add(this.geneList.get(i).mutate());
                    continue;
                }
                mutatedGenes.add(this.geneList.get(i).clone());
            }
        }
        ExpandableGene result = new ExpandableGene(this.startingGene.clone(), this.parameters);
        result.clearGenes();
        for (i = 0; i < mutatedGenes.size(); ++i) {
            result.addGene((Gene)mutatedGenes.get(i));
        }
        int maximumGenes = Integer.MAX_VALUE;
        if (this.parameters.contains("maximumGenes")) {
            maximumGenes = this.parameters.getInteger("maximumGenes");
        }
        if (result.geneList.size() < maximumGenes && RandomNumberManager.getRandomInt(0, 100) < mutateAddGene) {
            result.addRandomGene();
        }
        return result;
    }

    @Override
    public float getDifference(Gene other) {
        if (this.geneList.isEmpty()) {
            LogManager.writeError("Error", this, "Gene empty");
        }
        if (other instanceof ExpandableGene) {
            ExpandableGene otherExpandable = (ExpandableGene)other;
            if (otherExpandable.geneList.isEmpty()) {
                LogManager.writeError("Error", this, "Other gene is empty");
            }
            float avgMinDifferences = 0.0f;
            for (int i = 0; i < this.geneList.size(); ++i) {
                float minDifference = Float.POSITIVE_INFINITY;
                for (int j = 0; j < otherExpandable.geneList.size(); ++j) {
                    float currDifference = this.geneList.get(i).getDifference(otherExpandable.geneList.get(j));
                    if (!(currDifference < minDifference)) continue;
                    minDifference = currDifference;
                }
                avgMinDifferences += minDifference;
            }
            return avgMinDifferences /= (float)this.geneList.size();
        }
        float minDifference = Float.MAX_VALUE;
        for (int i = 0; i < this.geneList.size(); ++i) {
            float currDifference = this.geneList.get(i).getDifference(other);
            if (!(currDifference < minDifference)) continue;
            minDifference = currDifference;
        }
        return minDifference;
    }

    protected int findClosestIndex(Gene other) {
        int closestIndex = -1;
        if (other instanceof ExpandableGene) {
            ExpandableGene otherExpandable = (ExpandableGene)other;
            float minDifference = Float.POSITIVE_INFINITY;
            for (int i = 0; i < this.geneList.size(); ++i) {
                for (int j = 0; j < otherExpandable.geneList.size(); ++j) {
                    float currDifference = this.geneList.get(i).getDifference(otherExpandable.geneList.get(j));
                    if (!(currDifference < minDifference)) continue;
                    minDifference = currDifference;
                    closestIndex = i;
                }
            }
        } else {
            float minDifference = Float.POSITIVE_INFINITY;
            for (int i = 0; i < this.geneList.size(); ++i) {
                float currDifference = this.geneList.get(i).getDifference(other);
                if (!(currDifference < minDifference)) continue;
                minDifference = currDifference;
                closestIndex = i;
            }
        }
        return closestIndex;
    }
}

