/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Embryogeny;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainer;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.NoveltyTrainer;
import genetic.fitness.Fitness;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FI2PopTrainer
implements Runnable {
    GeneticAlgorithmTrainerGeneric feasibleTrainer;
    GeneticAlgorithmTrainerGeneric infeasibleTrainer;
    Fitness feasibilityCheck;
    Embryogeny fcEmbryogeny;
    ParameterCollection parameters;

    public FI2PopTrainer(Fitness feasible_fn, Fitness infeasible_fn, Embryogeny embryo, GeneticAlgorithm feasible_ga, GeneticAlgorithm infeasible_ga, ParameterCollection gaParams) {
        this(feasible_fn, infeasible_fn, null, embryo, feasible_ga, infeasible_ga, gaParams);
    }

    public FI2PopTrainer(Fitness feasible_fn, Fitness infeasible_fn, Fitness feasibilityCheck, Embryogeny embryo, GeneticAlgorithm feasible_ga, GeneticAlgorithm infeasible_ga, ParameterCollection gaParams) {
        this(feasible_fn, infeasible_fn, feasibilityCheck, null, embryo, feasible_ga, infeasible_ga, gaParams);
    }

    public FI2PopTrainer(Fitness feasible_fn, Fitness infeasible_fn, Fitness feasibilityCheck, Embryogeny feasibilityCheckEmbryogeny, Embryogeny embryo, GeneticAlgorithm feasible_ga, GeneticAlgorithm infeasible_ga, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.feasibilityCheck = feasibilityCheck == null ? infeasible_fn : feasibilityCheck;
        this.fcEmbryogeny = feasibilityCheckEmbryogeny == null ? embryo : feasibilityCheckEmbryogeny;
        this.feasibleTrainer = new GeneticAlgorithmTrainer(feasible_fn, embryo, feasible_ga, gaParams);
        this.infeasibleTrainer = new GeneticAlgorithmTrainer(infeasible_fn, embryo, infeasible_ga, gaParams);
    }

    public FI2PopTrainer(Fitness feasibilityCheck, GeneticAlgorithmTrainerGeneric feasibleTrainer, GeneticAlgorithmTrainerGeneric infeasibleTrainer, ParameterCollection gaParams) {
        this(feasibilityCheck, null, feasibleTrainer, infeasibleTrainer, gaParams);
    }

    public FI2PopTrainer(Fitness feasibilityCheck, Embryogeny feasibilityCheckEmbryogeny, GeneticAlgorithmTrainerGeneric feasibleTrainer, GeneticAlgorithmTrainerGeneric infeasibleTrainer, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.feasibilityCheck = feasibilityCheck;
        this.fcEmbryogeny = feasibilityCheckEmbryogeny == null ? infeasibleTrainer.embryogeny : feasibilityCheckEmbryogeny;
        this.feasibleTrainer = feasibleTrainer;
        this.infeasibleTrainer = infeasibleTrainer;
    }

    public void shufflePopulations() {
        double fcCheck;
        Object fcPhenotype;
        Gene g;
        int i;
        this.feasibleTrainer.initializePhenotypes();
        this.infeasibleTrainer.initializePhenotypes();
        Vector<Gene> feasibleGenes = new Vector<Gene>();
        Vector<Gene> infeasibleGenes = new Vector<Gene>();
        for (i = 0; i < this.feasibleTrainer.getPopulation().getPopulationSize(); ++i) {
            g = this.feasibleTrainer.getPopulation().getGene(i);
            fcPhenotype = this.fcEmbryogeny != this.feasibleTrainer.embryogeny ? this.fcEmbryogeny.createPhenotype(g.getGenotype()) : g.getPhenotype();
            fcCheck = this.feasibilityCheck.evaluate(fcPhenotype);
            if (fcCheck != 0.0) {
                g.setPhenotype(this.infeasibleTrainer.embryogeny.createPhenotype(g.genotype));
                infeasibleGenes.add(g);
                continue;
            }
            feasibleGenes.add(g);
        }
        for (i = 0; i < this.infeasibleTrainer.getPopulation().getPopulationSize(); ++i) {
            g = this.infeasibleTrainer.getPopulation().getGene(i);
            fcPhenotype = this.fcEmbryogeny != this.infeasibleTrainer.embryogeny ? this.fcEmbryogeny.createPhenotype(g.getGenotype()) : g.getPhenotype();
            fcCheck = this.feasibilityCheck.evaluate(fcPhenotype);
            if (fcCheck != 0.0) {
                infeasibleGenes.add(g);
                continue;
            }
            g.setPhenotype(this.feasibleTrainer.embryogeny.createPhenotype(g.genotype));
            feasibleGenes.add(g);
        }
        this.feasibleTrainer.getPopulation().replacePopulation(feasibleGenes);
        this.feasibleTrainer.evaluateParents();
        this.feasibleTrainer.calculateStatistics();
        if (this.feasibleTrainer instanceof NoveltyTrainer) {
            ((NoveltyTrainer)this.feasibleTrainer).saveNovelIndividuals();
        }
        this.infeasibleTrainer.getPopulation().replacePopulation(infeasibleGenes);
        this.infeasibleTrainer.evaluateParents();
        this.infeasibleTrainer.calculateStatistics();
        if (this.infeasibleTrainer instanceof NoveltyTrainer) {
            ((NoveltyTrainer)this.infeasibleTrainer).saveNovelIndividuals();
        }
    }

    protected void init() {
        this.feasibleTrainer.init();
        this.infeasibleTrainer.init();
    }

    public void evaluateParents() {
        this.feasibleTrainer.evaluateParents();
        this.infeasibleTrainer.evaluateParents();
    }

    public void setLogID(String logID) {
        this.feasibleTrainer.setLogID(logID);
        this.infeasibleTrainer.setLogID(logID + "_infeasible");
    }

    public String getLogID() {
        return this.feasibleTrainer.getLogID();
    }

    @Override
    public void run() {
        this.train();
    }

    public void train() {
        this.feasibleTrainer.resetGenerationCount();
        this.infeasibleTrainer.resetGenerationCount();
        int maxGeneration = 1000;
        if (this.parameters.contains("maxGenerations")) {
            maxGeneration = this.parameters.getInteger("maxGenerations");
        }
        this.feasibleTrainer.setMaxGeneration(maxGeneration);
        this.infeasibleTrainer.setMaxGeneration(maxGeneration);
        this.train(maxGeneration);
    }

    public void train(int generations) {
        double minimumAcceptedFitness = -1.0;
        if (this.parameters.contains("minimumAcceptedFitness")) {
            minimumAcceptedFitness = this.parameters.getDouble("minimumAcceptedFitness");
        }
        for (int e = 0; e < generations && !(Math.abs(this.feasibleTrainer.getMaxFitness() - minimumAcceptedFitness) < 1.0E-5); ++e) {
            double ratio;
            int totalPopulation = this.feasibleTrainer.getPopulation().getPopulationSize() + this.infeasibleTrainer.getPopulation().getPopulationSize();
            int feasibleOffspring = this.feasibleTrainer.getPopulation().getPopulationSize();
            if (this.parameters.contains("enforceMinFeasiblePopulation") && feasibleOffspring > 0 && (ratio = this.parameters.getDouble("enforceMinFeasiblePopulation")) >= 0.0 && ratio <= 1.0) {
                feasibleOffspring = Math.max(feasibleOffspring, (int)Math.round((double)totalPopulation * ratio));
            }
            this.writeLogProgress();
            this.feasibleTrainer.generateOffspring(feasibleOffspring);
            this.infeasibleTrainer.generateOffspring(totalPopulation - feasibleOffspring);
            ++this.feasibleTrainer.currGeneration;
            ++this.infeasibleTrainer.currGeneration;
            this.shufflePopulations();
        }
    }

    public Vector<Double> evaluateFeasibleParentsCustom(Fitness customFn) {
        return this.feasibleTrainer.evaluateParentsCustom(customFn);
    }

    public GeneticAlgorithmTrainerGeneric getFeasibleTrainer() {
        return this.feasibleTrainer;
    }

    public GeneticAlgorithmTrainerGeneric getInfeasibleTrainer() {
        return this.infeasibleTrainer;
    }

    public Gene getBestFeasibleIndividual() {
        return this.feasibleTrainer.getBestIndividual();
    }

    public Gene getBestFeasibleIndividualCustom(Fitness fn) {
        return this.feasibleTrainer.getBestIndividualCustom(fn);
    }

    public Vector<Object> getBestFeasiblePhenotypes(int number) {
        return this.feasibleTrainer.getBestPhenotypes(number);
    }

    public Vector<Gene> getBestFeasibleGenes(int number) {
        return this.feasibleTrainer.getBestGenes(number);
    }

    public Vector<Object> getRandomFeasiblePhenotypes(int number) {
        return this.feasibleTrainer.getRandomPhenotypes(number);
    }

    public Vector<Gene> getRandomFeasibleGenes(int number) {
        return this.feasibleTrainer.getRandomGenes(number);
    }

    public Vector<Object> getDifferentFeasiblePhenotypes(int number, Gene target) {
        return this.feasibleTrainer.getDifferentPhenotypes(number, target);
    }

    public Vector<Gene> getDifferentFeasibleGenes(int number, Gene target) {
        return this.feasibleTrainer.getDifferentGenes(number, target);
    }

    public Vector<Object> getSampleFeasiblePhenotypes(int number) {
        return this.feasibleTrainer.getSamplePhenotypes(number);
    }

    public Vector<Gene> getSampleFeasibleGenes(int number) {
        return this.feasibleTrainer.getSampleGenes(number);
    }

    public boolean existsFeasible() {
        return this.feasibleTrainer.getPopulation().getPopulationSize() > 0;
    }

    public int getFeasibleSize() {
        return this.feasibleTrainer.getPopulation().getPopulationSize();
    }

    public int getInfeasibleSize() {
        return this.infeasibleTrainer.getPopulation().getPopulationSize();
    }

    public double getProgress() {
        return this.feasibleTrainer.getProgress();
    }

    public void writeLogProgress() {
        this.feasibleTrainer.writeFitnessProgress();
        this.infeasibleTrainer.writeFitnessProgress();
        if (!this.feasibleTrainer.logID.isEmpty()) {
            if (LogManager.addLogfile(this.feasibleTrainer.logID + "_populationProgress", this.feasibleTrainer.logID + "_populationProgress.csv")) {
                LogManager.write(this.feasibleTrainer.logID + "_populationProgress", "feasible;infeasible");
            }
            LogManager.write(this.feasibleTrainer.logID + "_populationProgress", this.feasibleTrainer.getPopulation().getPopulationSize() + ";" + this.infeasibleTrainer.getPopulation().getPopulationSize());
        }
    }
}

