/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Gene;
import genetic.Species;
import genetic.SpeciesLibrary;
import genetic.comparators.GeneFitnessComparator;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.logs.Writer;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneticAlgorithm {
    protected ParameterCollection parameters;
    protected Vector<Gene> allGenes;
    SpeciesLibrary speciesLib;

    public GeneticAlgorithm(ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.speciesLib = null;
        if (this.parameters.contains("speciesTargetNumber")) {
            this.speciesLib = new SpeciesLibrary(this.parameters);
        }
    }

    public static void toXML(Vector<Gene> targetGenes, String filename) {
        try {
            new File(filename).getParentFile().mkdirs();
        }
        catch (Exception e) {
            LogManager.writeError("Error", null, e.toString());
        }
        String toSave = "<population>\n";
        for (int i = 0; i < targetGenes.size(); ++i) {
            toSave = toSave + targetGenes.get(i).toXML() + "\n";
        }
        toSave = toSave + "</population>";
        Writer xmlWriter = new Writer(filename);
        xmlWriter.write(toSave);
        xmlWriter.close();
    }

    public void toXML(String filename) {
        try {
            new File(filename).getParentFile().mkdirs();
        }
        catch (Exception e) {
            LogManager.writeError("Error", this, e.toString());
        }
        String toSave = "<population>\n";
        for (int i = 0; i < this.allGenes.size(); ++i) {
            toSave = toSave + this.allGenes.get(i).toXML() + "\n";
        }
        toSave = toSave + "</population>";
        Writer xmlWriter = new Writer(filename);
        xmlWriter.write(toSave);
        xmlWriter.close();
    }

    public void toSpeciesXML(String filename) {
        try {
            new File(filename).getParentFile().mkdirs();
        }
        catch (Exception e) {
            LogManager.writeError("Error", this, e.toString());
        }
        String toSave = "<allSpecies>\n";
        for (int i = 0; i < this.speciesLib.size(); ++i) {
            toSave = toSave + ((Species)this.speciesLib.get(i)).toXML() + "\n";
        }
        toSave = toSave + "</allSpecies>";
        Writer xmlWriter = new Writer(filename);
        xmlWriter.write(toSave);
        xmlWriter.close();
    }

    public double getDiversity() {
        double result = 0.0;
        int pairs = 0;
        for (int i = 0; i < this.allGenes.size(); ++i) {
            for (int j = 0; j < this.allGenes.size(); ++j) {
                if (i == j) continue;
                result += (double)this.allGenes.get(i).getDifference(this.allGenes.get(j));
                ++pairs;
            }
        }
        if (pairs == 0) {
            return 1.0;
        }
        return result / (double)pairs;
    }

    public double getDiversity(Gene template) {
        double result = 0.0;
        int pairs = 0;
        for (int i = 0; i < this.allGenes.size(); ++i) {
            if (template == this.allGenes.get(i)) continue;
            result += (double)template.getDifference(this.allGenes.get(i));
            ++pairs;
        }
        if (pairs == 0) {
            return 1.0;
        }
        return result / (double)pairs;
    }

    public int getPopulationSize() {
        return this.allGenes.size();
    }

    public Gene getGene(int index) {
        if (index < 0 || index >= this.allGenes.size()) {
            LogManager.writeError("Error", this, "index out of bounds");
            return null;
        }
        return this.allGenes.get(index);
    }

    public void sortPopulation() {
        Collections.sort(this.allGenes, new GeneFitnessComparator());
    }

    public void sortPopulation(Comparator comparator) {
        Collections.sort(this.allGenes, comparator);
    }

    public Vector<Gene> generateOffspring() {
        return this.generateOffspring(this.allGenes.size());
    }

    public Vector<Gene> generateOffspring(int offspringCount) {
        return this.generateOffspring(this.allGenes, offspringCount);
    }

    public Vector<Gene> generateOffspring(Vector<Gene> parents) {
        return this.generateOffspring(parents, parents.size());
    }

    public SpeciesLibrary getSpeciesLibrary() {
        return this.speciesLib;
    }

    public Vector<Gene> generateOffspring(Vector<Gene> parents, int offspringCount) {
        Vector<Gene> result = new Vector();
        if (this.speciesLib != null) {
            this.speciesLib.update(offspringCount);
            for (int i = 0; i < this.speciesLib.size(); ++i) {
                if (((Species)this.speciesLib.get(i)).isDefunct() || ((Species)this.speciesLib.get(i)).getOffspringCount() <= 0) continue;
                Vector<Gene> speciesGenes = ((Species)this.speciesLib.get((int)i)).members;
                Vector<Gene> speciesOffspring = this.generateOffspringHelper(speciesGenes, ((Species)this.speciesLib.get(i)).getOffspringCount());
                System.out.println(((Species)this.speciesLib.get(i)).getID() + " (" + speciesGenes.size() + ") offspring generated: " + speciesOffspring.size());
                result.addAll(speciesOffspring);
            }
            this.speciesLib.cleanDefunctSpecies();
        } else {
            result = this.generateOffspringHelper(parents, offspringCount);
        }
        return result;
    }

    public abstract Vector<Gene> generateOffspringHelper(Vector<Gene> var1, int var2);

    public void replacePopulation(Vector<Gene> replacements) {
        this.allGenes = new Vector();
        this.allGenes.addAll(replacements);
        if (this.speciesLib != null) {
            this.speciesLib.replacePopulation(this.allGenes);
        }
    }

    public void randomizePopulation() {
        for (int i = 0; i < this.allGenes.size(); ++i) {
            this.allGenes.get(i).randomize();
        }
        if (this.speciesLib != null) {
            this.speciesLib.clear();
            this.speciesLib.replacePopulation(this.allGenes);
        }
    }

    public void initializePopulation() {
        this.initializePopulationHelper();
        if (this.speciesLib != null) {
            this.speciesLib.clear();
        }
    }

    public abstract void initializePopulationHelper();
}

