/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Embryogeny;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.Species;
import genetic.fitness.Fitness;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.StatisticUtils;

public class GeneticAlgorithmTrainer
extends GeneticAlgorithmTrainerGeneric {
    protected Fitness fitnessFunction;

    public GeneticAlgorithmTrainer(Fitness fn, Embryogeny embryo, GeneticAlgorithm ga, ParameterCollection gaParams) {
        this.population = ga;
        this.parameters = gaParams;
        this.fitnessFunction = fn;
        this.embryogeny = embryo;
        this.init();
    }

    public void generateOffspring() {
        boolean normalizeFitness = false;
        if (this.parameters.contains("normalizeFitness")) {
            normalizeFitness = this.parameters.getBoolean("normalizeFitness");
        }
        if (normalizeFitness) {
            this.normalizeFitness();
        }
        Vector<Gene> offspring = this.population.generateOffspring();
        this.population.replacePopulation(offspring);
    }

    public void generateOffspring(int number) {
        boolean normalizeFitness = false;
        if (this.parameters.contains("normalizeFitness")) {
            normalizeFitness = this.parameters.getBoolean("normalizeFitness");
        }
        if (normalizeFitness) {
            this.normalizeFitness();
        }
        Vector<Gene> offspring = this.population.generateOffspring(number);
        this.population.replacePopulation(offspring);
    }

    public void evaluateParents() {
        this.initializePhenotypes();
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            Gene g = this.population.getGene(i);
            double currFitness = this.fitnessFunction.evaluate(g.getPhenotype());
            g.setFitness(currFitness);
        }
        this.calculateStatistics();
    }

    public double evaluate(Gene g) {
        return this.fitnessFunction.evaluate(g.getPhenotype());
    }

    protected void writeFitnessProgress() {
        if (!this.logID.isEmpty()) {
            if (LogManager.addLogfile(this.logID + "_fitnessProgress", this.logID + "_fitnessProgress.csv")) {
                LogManager.write(this.logID + "_fitnessProgress", "maxFitness;avgFitness");
            }
            LogManager.write(this.logID + "_fitnessProgress", this.maxFitness + ";" + this.avgFitness);
        }
    }

    public void writeSpeciesProgress() {
        if (!this.logID.isEmpty() && this.population.speciesLib != null) {
            if (LogManager.addLogfile(this.logID + "_speciesProgress", this.logID + "_speciesProgress.csv")) {
                LogManager.write(this.logID + "_speciesProgress", "totalSpecies;currDifferenceThreshold;avgSize;stdSize;maxSize;minSize;avgFitness;stdFitness;maxFitness;minFitness;avgAge;stdAge;avgUpdate;stdUpdate");
            }
            double[] fitness = new double[this.population.speciesLib.size()];
            double[] size = new double[this.population.speciesLib.size()];
            double[] age = new double[this.population.speciesLib.size()];
            double[] updateDiff = new double[this.population.speciesLib.size()];
            for (int i = 0; i < this.population.speciesLib.size(); ++i) {
                fitness[i] = ((Species)this.population.speciesLib.get(i)).getFitness();
                size[i] = ((Species)this.population.speciesLib.get(i)).getMemberCount();
                age[i] = ((Species)this.population.speciesLib.get(i)).getAge();
                updateDiff[i] = ((Species)this.population.speciesLib.get(i)).getLastUpdate() - ((Species)this.population.speciesLib.get(i)).getAge();
            }
            LogManager.write(this.logID + "_speciesProgress", this.population.speciesLib.size() + ";" + this.population.speciesLib.currDifferenceThreshold + ";" + StatisticUtils.average(size) + ";" + StatisticUtils.standardDeviation(size) + ";" + StatisticUtils.maximum(size) + ";" + StatisticUtils.minimum(size) + ";" + StatisticUtils.average(fitness) + ";" + StatisticUtils.standardDeviation(fitness) + ";" + StatisticUtils.maximum(fitness) + ";" + StatisticUtils.minimum(fitness) + ";" + StatisticUtils.average(age) + ";" + StatisticUtils.standardDeviation(age) + ";" + StatisticUtils.average(updateDiff) + ";" + StatisticUtils.standardDeviation(updateDiff));
        }
    }

    public Fitness getFitnessFunction() {
        return this.fitnessFunction;
    }
}

