/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Embryogeny;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.RandomNumberManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneticAlgorithmTrainerGeneric
implements Runnable {
    protected ParameterCollection parameters;
    protected GeneticAlgorithm population;
    protected Embryogeny embryogeny;
    protected int maxGeneration;
    protected int currGeneration;
    protected double maxFitness;
    protected double avgFitness;
    protected double minFitness;
    protected Gene bestIndividual;
    protected String logID;

    protected void init() {
        this.bestIndividual = null;
        this.maxGeneration = 0;
        this.currGeneration = 0;
        this.logID = "";
    }

    public double getAvgFitness() {
        return this.avgFitness;
    }

    public double getMaxFitness() {
        return this.maxFitness;
    }

    public double getMinFitness() {
        return this.minFitness;
    }

    public Gene getBestIndividual() {
        return this.bestIndividual;
    }

    public void setLogID(String value) {
        this.logID = value;
    }

    public void setMaxGeneration(int value) {
        this.maxGeneration = value;
    }

    public void resetGenerationCount() {
        this.currGeneration = 0;
    }

    public String getLogID() {
        return this.logID;
    }

    public double getProgress() {
        return (double)this.currGeneration / (double)this.maxGeneration;
    }

    @Override
    public void run() {
        this.train();
    }

    public void train() {
        this.resetGenerationCount();
        this.maxGeneration = 1000;
        if (this.parameters.contains("maxGenerations")) {
            this.maxGeneration = this.parameters.getInteger("maxGenerations");
        }
        this.train(this.maxGeneration);
    }

    public void train(int generations) {
        double minimumAcceptedFitness = -1.0;
        if (this.parameters.contains("minimumAcceptedFitness")) {
            minimumAcceptedFitness = this.parameters.getDouble("minimumAcceptedFitness");
        }
        this.evaluateParents();
        for (int e = 0; e < generations && !(Math.abs(this.maxFitness - minimumAcceptedFitness) < 1.0E-5); ++e) {
            this.writeLogProgress();
            this.generateOffspring();
            ++this.currGeneration;
            this.evaluateParents();
        }
    }

    protected abstract void generateOffspring();

    protected abstract void generateOffspring(int var1);

    public abstract void evaluateParents();

    public abstract double evaluate(Gene var1);

    public void calculateStatistics() {
        this.bestIndividual = null;
        this.avgFitness = 0.0;
        this.maxFitness = -1.7976931348623157E308;
        this.minFitness = Double.MAX_VALUE;
        int geneCount = 0;
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            Gene g = this.population.getGene(i);
            double currFitness = g.getFitness();
            this.avgFitness += currFitness;
            if (currFitness > this.maxFitness) {
                this.maxFitness = currFitness;
                this.bestIndividual = g;
            }
            if (currFitness < this.minFitness) {
                this.minFitness = currFitness;
            }
            ++geneCount;
        }
        this.avgFitness /= (double)geneCount;
    }

    protected void normalizeFitness() {
        double blah = this.maxFitness - this.minFitness;
        if (this.maxFitness - this.minFitness > 0.0) {
            for (int i = 0; i < this.population.getPopulationSize(); ++i) {
                double currFitness = this.population.getGene(i).getFitness();
                double blah2 = currFitness - this.minFitness;
                double nrmFitness = (currFitness - this.minFitness) / (this.maxFitness - this.minFitness);
                this.population.getGene(i).setFitness(nrmFitness);
            }
        }
    }

    public void initializePhenotypes() {
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            Gene g = this.population.getGene(i);
            if (g.getPhenotype() != null) continue;
            g.setPhenotype(this.embryogeny.createPhenotype(g.getGenotype()));
        }
    }

    public Gene getBestIndividualCustom(Fitness customFn) {
        double bestFitness = -1.7976931348623157E308;
        Gene result = null;
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            double currFn = customFn.evaluate(this.population.getGene(i).getPhenotype());
            if (!(currFn > bestFitness)) continue;
            bestFitness = currFn;
            result = this.population.getGene(i);
        }
        return result;
    }

    public Gene getBestIndividualCustom(Fitness customFn, Embryogeny customEmbryo) {
        double bestFitness = -1.7976931348623157E308;
        Gene result = null;
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            Object customPhenotype = customEmbryo.createPhenotype(this.population.getGene(i).getGenotype());
            double currFn = customFn.evaluate(customPhenotype);
            if (!(currFn > bestFitness)) continue;
            bestFitness = currFn;
            result = this.population.getGene(i);
        }
        return result;
    }

    public Gene getWorstIndividualCustom(Fitness customFn) {
        double worstFitness = Double.MAX_VALUE;
        Gene result = null;
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            double currFn = customFn.evaluate(this.population.getGene(i).getPhenotype());
            if (!(currFn < worstFitness)) continue;
            worstFitness = currFn;
            result = this.population.getGene(i);
        }
        return result;
    }

    public Gene getWorstIndividualCustom(Fitness customFn, Embryogeny customEmbryo) {
        double worstFitness = Double.MAX_VALUE;
        Gene result = null;
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            Object customPhenotype = customEmbryo.createPhenotype(this.population.getGene(i).getGenotype());
            double currFn = customFn.evaluate(customPhenotype);
            if (!(currFn < worstFitness)) continue;
            worstFitness = currFn;
            result = this.population.getGene(i);
        }
        return result;
    }

    public Vector<Double> evaluateParentsCustom(Fitness customFn) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            result.add(customFn.evaluate(this.population.getGene(i).getPhenotype()));
        }
        return result;
    }

    public Vector<Double> evaluateParentsCustom(Fitness customFn, Embryogeny customEmbryo) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            Object customPhenotype = customEmbryo.createPhenotype(this.population.getGene(i).getGenotype());
            result.add(customFn.evaluate(customPhenotype));
        }
        return result;
    }

    public Vector<Object> getRandomPhenotypes(int number) {
        Vector<Gene> genes = this.getRandomGenes(number);
        Vector<Object> result = new Vector<Object>();
        for (Gene g : genes) {
            result.add(g.getPhenotype());
        }
        return result;
    }

    public Vector<Gene> getRandomGenes(int number) {
        number = Math.min(number, this.population.getPopulationSize());
        Vector<Integer> rolls = new Vector<Integer>();
        while (rolls.size() < number) {
            int roll = RandomNumberManager.getRandomInt(0, this.population.getPopulationSize());
            if (rolls.contains(roll)) continue;
            rolls.add(roll);
        }
        Vector<Gene> result = new Vector<Gene>();
        for (int i = 0; i < rolls.size(); ++i) {
            result.add(this.population.getGene((Integer)rolls.get(i)));
        }
        return result;
    }

    public Vector<Object> getDifferentPhenotypes(int number, Gene target) {
        Vector<Gene> genes = this.getDifferentGenes(number, target);
        Vector<Object> result = new Vector<Object>();
        for (Gene g : genes) {
            result.add(g.getPhenotype());
        }
        return result;
    }

    public Vector<Gene> getDifferentGenes(int number, Gene target) {
        number = Math.min(number, this.population.getPopulationSize());
        Vector<Float> differences = new Vector<Float>();
        Vector<Gene> result = new Vector<Gene>();
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            differences.add(Float.valueOf(target.getDifference(this.population.getGene(i))));
        }
        while (result.size() < number) {
            float maxDiff = -1.0f;
            int maxIndex = -1;
            for (int i = 0; i < differences.size(); ++i) {
                if (!(((Float)differences.get(i)).floatValue() > maxDiff) || result.contains(this.population.getGene(i))) continue;
                maxIndex = i;
                maxDiff = ((Float)differences.get(i)).floatValue();
            }
            result.add(this.population.getGene(maxIndex));
        }
        return result;
    }

    public Vector<Object> getSamplePhenotypes(int number) {
        Vector<Gene> genes = this.getSampleGenes(number);
        Vector<Object> result = new Vector<Object>();
        for (Gene g : genes) {
            result.add(g.getPhenotype());
        }
        return result;
    }

    public Vector<Gene> getSampleGenes(int number) {
        number = Math.min(number, this.population.getPopulationSize());
        Vector<Gene> result = new Vector<Gene>();
        if (number <= 0) {
            return result;
        }
        double[] targetFitnesses = new double[number];
        double increment = (this.maxFitness - this.minFitness) / (double)number;
        for (int i = 0; i < number - 1; ++i) {
            targetFitnesses[i] = this.maxFitness - (double)i * increment;
        }
        targetFitnesses[number - 1] = this.minFitness;
        int count = 0;
        this.population.sortPopulation();
        for (int i = 0; i < this.population.getPopulationSize() && count < targetFitnesses.length; ++i) {
            Gene currGene = this.population.getGene(i);
            double geneDistance = currGene.getFitness() - targetFitnesses[count];
            if (!(currGene.getFitness() <= targetFitnesses[count])) continue;
            if (count < targetFitnesses.length - 1 && i > 0 && currGene.getFitness() <= targetFitnesses[count + 1]) {
                result.add(currGene);
                ++count;
                continue;
            }
            result.add(currGene);
            ++count;
        }
        System.out.println("count " + count);
        return result;
    }

    public Vector<Object> getBestPhenotypes(int number) {
        Vector<Gene> genes = this.getBestGenes(number);
        Vector<Object> result = new Vector<Object>();
        for (Gene g : genes) {
            result.add(g.getPhenotype());
        }
        return result;
    }

    public Vector<Gene> getBestGenes(int number) {
        Vector<Gene> result = new Vector<Gene>();
        this.population.sortPopulation();
        for (int i = 0; i < number && i < this.population.getPopulationSize(); ++i) {
            result.add(this.population.getGene(i));
        }
        return result;
    }

    public Vector<Gene> getBestUniqueGenes(int number) {
        Vector<Gene> result = new Vector<Gene>();
        this.population.sortPopulation();
        int totalGenes = this.population.getPopulationSize();
        for (int i = 0; result.size() < number && i < totalGenes; ++i) {
            boolean toAdd = true;
            for (int j = 0; j < result.size(); ++j) {
                if (this.population.getGene(i).getDifference(result.get(j)) != 0.0f) continue;
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            result.add(this.population.getGene(i));
        }
        return result;
    }

    public Vector<Object> getDiversePhenotypes(int number) {
        Vector<Gene> genes = this.getDiverseGenes(number);
        Vector<Object> result = new Vector<Object>();
        for (Gene g : genes) {
            result.add(g.getPhenotype());
        }
        return result;
    }

    public Vector<Gene> getDiverseGenes(int number) {
        number = Math.min(number, this.population.getPopulationSize());
        Vector<Float> differences = new Vector<Float>();
        Vector<Gene> result = new Vector<Gene>();
        if (this.population.getPopulationSize() == 1) {
            result.add(this.population.getGene(0));
            return result;
        }
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            float avgDifference = 0.0f;
            for (int j = 0; j < this.population.getPopulationSize(); ++j) {
                if (j == i) continue;
                avgDifference += this.population.getGene(i).getDifference(this.population.getGene(j));
            }
            differences.add(Float.valueOf(avgDifference /= (float)(this.population.getPopulationSize() - 1)));
        }
        while (result.size() < number) {
            float maxDiff = -1.0f;
            int maxIndex = -1;
            for (int i = 0; i < differences.size(); ++i) {
                if (!(((Float)differences.get(i)).floatValue() > maxDiff) || result.contains(this.population.getGene(i))) continue;
                maxIndex = i;
                maxDiff = ((Float)differences.get(i)).floatValue();
            }
            result.add(this.population.getGene(maxIndex));
        }
        return result;
    }

    public Vector<Object> getDiversePhenotypes(int number, DifferenceFitness dfn) {
        Vector<Gene> genes = this.getDiverseGenes(number, dfn);
        Vector<Object> result = new Vector<Object>();
        for (Gene g : genes) {
            result.add(g.getPhenotype());
        }
        return result;
    }

    public Vector<Gene> getDiverseGenes(int number, DifferenceFitness dfn) {
        number = Math.min(number, this.population.getPopulationSize());
        Vector<Float> differences = new Vector<Float>();
        Vector<Gene> result = new Vector<Gene>();
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            float avgDifference = 0.0f;
            for (int j = 0; j < this.population.getPopulationSize(); ++j) {
                if (j == i) continue;
                avgDifference = (float)((double)avgDifference + dfn.evaluate(this.population.getGene(i).getPhenotype(), this.population.getGene(j).getPhenotype()));
            }
            differences.add(Float.valueOf(avgDifference /= (float)(this.population.getPopulationSize() - 1)));
        }
        while (result.size() < number) {
            float maxDiff = -1.0f;
            int maxIndex = -1;
            for (int i = 0; i < differences.size(); ++i) {
                if (!(((Float)differences.get(i)).floatValue() > maxDiff) || result.contains(this.population.getGene(i))) continue;
                maxIndex = i;
                maxDiff = ((Float)differences.get(i)).floatValue();
            }
            result.add(this.population.getGene(maxIndex));
        }
        return result;
    }

    public GeneticAlgorithm getPopulation() {
        return this.population;
    }

    public void writeLogProgress() {
        this.writeFitnessProgress();
    }

    protected abstract void writeFitnessProgress();
}

