/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Embryogeny;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.comparators.GeneFitnessComparator;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.logs.Writer;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoveltyTrainer
extends GeneticAlgorithmTrainerGeneric {
    protected DifferenceFitness distanceFunction;
    protected Fitness evaluationFunction;
    protected Vector<Gene> novelIndividuals;

    public NoveltyTrainer(DifferenceFitness distFunction, Embryogeny embryo, GeneticAlgorithm ga, ParameterCollection gaParams) {
        this(distFunction, null, embryo, ga, gaParams);
    }

    public NoveltyTrainer(DifferenceFitness distFunction, Fitness evalFunction, Embryogeny embryo, GeneticAlgorithm ga, ParameterCollection gaParams) {
        this.population = ga;
        this.parameters = gaParams;
        this.distanceFunction = distFunction;
        this.evaluationFunction = evalFunction;
        this.embryogeny = embryo;
        this.resetNovelIndividuals();
        this.init();
    }

    @Override
    public void generateOffspring() {
        boolean nrmFitness = false;
        if (this.parameters.contains("normalizeFitness")) {
            nrmFitness = this.parameters.getBoolean("normalizeFitness");
        }
        if (nrmFitness) {
            this.normalizeFitness();
        }
        Vector<Gene> offspring = this.population.generateOffspring();
        this.population.replacePopulation(offspring);
    }

    @Override
    public void generateOffspring(int number) {
        boolean nrmFitness = false;
        if (this.parameters.contains("normalizeFitness")) {
            nrmFitness = this.parameters.getBoolean("normalizeFitness");
        }
        if (nrmFitness) {
            this.normalizeFitness();
        }
        Vector<Gene> offspring = this.population.generateOffspring(number);
        this.population.replacePopulation(offspring);
    }

    public void resetNovelIndividuals() {
        this.novelIndividuals = new Vector();
    }

    @Override
    public void train(int generations) {
        if (this.population.getPopulationSize() == 0) {
            return;
        }
        double minimumAcceptedFitness = -1.0;
        if (this.parameters.contains("minimumAcceptedFitness")) {
            minimumAcceptedFitness = this.parameters.getDouble("minimumAcceptedFitness");
        }
        this.evaluateParents();
        for (int e = 0; e < generations && !(Math.abs(this.maxFitness - minimumAcceptedFitness) < 1.0E-5); ++e) {
            this.saveNovelIndividuals();
            this.writeLogProgress();
            this.writeDiversityProgress();
            this.generateOffspring();
            ++this.currGeneration;
            this.evaluateParents();
        }
    }

    @Override
    public void evaluateParents() {
        if (this.population.getPopulationSize() == 0) {
            return;
        }
        this.initializePhenotypes();
        if (this.evaluationFunction != null) {
            for (int i = 0; i < this.population.getPopulationSize(); ++i) {
                Gene g = this.population.getGene(i);
                double currFitness = this.evaluationFunction.evaluate(g.getPhenotype());
                g.setFitness(currFitness);
            }
            this.calculateStatistics();
            this.writeEvaluationFitnessProgress();
        }
        int maxNeighbours = this.parameters.contains("maxNeighbours") ? this.parameters.getInteger("maxNeighbours") : this.population.getPopulationSize() + this.novelIndividuals.size();
        for (int i = 0; i < this.population.getPopulationSize(); ++i) {
            double fitness = this.calculateAverageDistance(this.population.getGene(i), maxNeighbours);
            this.population.getGene(i).setFitness(fitness);
        }
        this.calculateStatistics();
    }

    @Override
    public double evaluate(Gene g) {
        int maxNeighbours = this.parameters.contains("maxNeighbours") ? this.parameters.getInteger("maxNeighbours") : this.population.getPopulationSize() + this.novelIndividuals.size();
        return this.calculateAverageDistance(g, maxNeighbours);
    }

    protected void saveNovelIndividuals() {
        int i;
        if (this.population.getPopulationSize() == 0) {
            return;
        }
        int novelIndividualsPerGeneration = this.parameters.contains("novelIndividualsPerGeneration") ? this.parameters.getInteger("novelIndividualsPerGeneration") : -1;
        double novelIndividualThreshold = this.parameters.contains("novelIndividualThreshold") ? this.parameters.getDouble("novelIndividualThreshold") : -1.0;
        Vector<Gene> addedNovelIndividuals = new Vector<Gene>();
        for (i = 0; i < this.population.getPopulationSize(); ++i) {
            if (!(this.population.getGene(i).getFitness() >= novelIndividualThreshold)) continue;
            addedNovelIndividuals.add(this.population.getGene(i));
        }
        if (novelIndividualsPerGeneration > 0) {
            Collections.sort(addedNovelIndividuals, new GeneFitnessComparator());
            for (i = 0; i < Math.min(novelIndividualsPerGeneration, addedNovelIndividuals.size()); ++i) {
                this.novelIndividuals.add((Gene)addedNovelIndividuals.get(i));
            }
        } else if (novelIndividualsPerGeneration < 0) {
            this.novelIndividuals.addAll(addedNovelIndividuals);
        }
    }

    protected void writeDiversityProgress() {
        if (!this.logID.isEmpty()) {
            int comparisons = 0;
            double diversity = 0.0;
            for (int i = 0; i < this.population.getPopulationSize(); ++i) {
                for (int j = 0; j < i; ++j) {
                    diversity += this.distanceFunction.evaluate(this.population.getGene(i).getPhenotype(), this.population.getGene(j).getPhenotype());
                    ++comparisons;
                }
            }
            LogManager.addLogfile(this.logID + "_diversityProgress", this.logID + "_diversityProgress.csv");
            LogManager.write(this.logID + "_diversityProgress", "" + (diversity /= (double)comparisons));
        }
    }

    protected void writeEvaluationFitnessProgress() {
        if (!this.logID.isEmpty()) {
            if (LogManager.addLogfile(this.logID + "_evaluationFitnessProgress", this.logID + "_evaluationFitnessProgress.csv")) {
                LogManager.write(this.logID + "_evaluationFitnessProgress", "maxFitness;avgFitness");
            }
            LogManager.write(this.logID + "_evaluationFitnessProgress", this.maxFitness + ";" + this.avgFitness);
        }
    }

    @Override
    protected void writeFitnessProgress() {
        if (!this.logID.isEmpty()) {
            if (LogManager.addLogfile(this.logID + "_fitnessProgress", this.logID + "_fitnessProgress.csv")) {
                LogManager.write(this.logID + "_fitnessProgress", "maxFitness;avgFitness");
            }
            LogManager.write(this.logID + "_fitnessProgress", this.maxFitness + ";" + this.avgFitness);
        }
    }

    public Vector<Gene> getNovelIndividuals() {
        return this.novelIndividuals;
    }

    public void setNovelIndividuals(Vector<Gene> genes) {
        this.novelIndividuals.clear();
        for (int i = 0; i < genes.size(); ++i) {
            this.novelIndividuals.add(genes.get(i).clone());
        }
    }

    public double calculateAverageDistance(int geneIndex, int maxNeighbours) {
        if (geneIndex < 0 || geneIndex >= this.population.getPopulationSize()) {
            LogManager.writeError("Error", this, "geneIndex out of bounds");
            return -1.0;
        }
        return this.calculateAverageDistance(this.population.getGene(geneIndex), maxNeighbours);
    }

    public double calculateAverageDistance(Gene gene, int maxNeighbours) {
        if (maxNeighbours <= 0) {
            maxNeighbours = this.population.getPopulationSize() + this.novelIndividuals.size();
        }
        double[] distanceMatrix = new double[maxNeighbours];
        int currIndex = 0;
        for (int j = 0; j < this.population.getPopulationSize() + this.novelIndividuals.size(); ++j) {
            Gene otherGene;
            Gene gene2 = otherGene = j < this.population.getPopulationSize() ? this.population.getGene(j) : this.novelIndividuals.get(j - this.population.getPopulationSize());
            if (gene == otherGene) continue;
            double distance = this.distanceFunction.evaluate(gene.getPhenotype(), otherGene.getPhenotype());
            if (currIndex < maxNeighbours) {
                distanceMatrix[Math.min((int)currIndex, (int)(maxNeighbours - 1))] = distance;
                Arrays.sort(distanceMatrix, 0, ++currIndex);
                continue;
            }
            if (!(distance < distanceMatrix[distanceMatrix.length - 1])) continue;
            distanceMatrix[distanceMatrix.length - 1] = distance;
            Arrays.sort(distanceMatrix, 0, distanceMatrix.length);
        }
        double avgDistance = 0.0;
        for (int j = 0; j < distanceMatrix.length; ++j) {
            avgDistance += distanceMatrix[j];
        }
        return avgDistance /= (double)distanceMatrix.length;
    }

    public Vector<Gene> filterNovelIndividuals(int maxNeighbours, double cutoffAvgDifferenceThreshold, double cutoffMinDifferenceThreshold) {
        Vector<Gene> result = new Vector<Gene>();
        if (maxNeighbours <= 0) {
            maxNeighbours = this.novelIndividuals.size() - 1;
        }
        for (int i = 0; i < this.novelIndividuals.size(); ++i) {
            Gene gene = this.novelIndividuals.get(i);
            double[] distanceMatrix = new double[maxNeighbours];
            int currIndex = 0;
            for (int j = 0; j < this.novelIndividuals.size(); ++j) {
                if (i == j) continue;
                Gene otherGene = this.novelIndividuals.get(j);
                double distance = this.distanceFunction.evaluate(gene.getPhenotype(), otherGene.getPhenotype());
                if (currIndex < maxNeighbours) {
                    distanceMatrix[Math.min((int)currIndex, (int)(maxNeighbours - 1))] = distance;
                    Arrays.sort(distanceMatrix, 0, ++currIndex);
                    continue;
                }
                if (!(distance < distanceMatrix[distanceMatrix.length - 1])) continue;
                distanceMatrix[distanceMatrix.length - 1] = distance;
                Arrays.sort(distanceMatrix, 0, distanceMatrix.length);
            }
            double minDistance = distanceMatrix[0];
            double avgDistance = 0.0;
            for (int j = 0; j < distanceMatrix.length; ++j) {
                avgDistance += distanceMatrix[j];
            }
            avgDistance /= (double)distanceMatrix.length;
            if (!(minDistance > cutoffMinDifferenceThreshold) || !(avgDistance > cutoffAvgDifferenceThreshold)) continue;
            result.add(gene);
        }
        return result;
    }

    public Vector<Gene> filterNovelIndividuals(double cutoffMinDifferenceThreshold) {
        return this.filterNovelIndividuals(1, -1.0, cutoffMinDifferenceThreshold);
    }

    protected void storeNovelIndividualsToXML(String filename) {
        try {
            new File(filename).getParentFile().mkdirs();
        }
        catch (Exception e) {
            LogManager.writeError("Error", this, e.toString());
        }
        String toSave = "<population>\n";
        for (int i = 0; i < this.novelIndividuals.size(); ++i) {
            toSave = toSave + this.novelIndividuals.get(i).toXML() + "\n";
        }
        toSave = toSave + "</population>";
        Writer xmlWriter = new Writer(filename);
        xmlWriter.write(toSave);
        xmlWriter.close();
    }
}

