/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Gene;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.CounterManager;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Species {
    ParameterCollection parameters;
    String id;
    Vector<Gene> members;
    Gene bestIndividualCopy;
    int age;
    int lastUpdate;
    int offspringCount;
    double fitness;
    boolean defunct;
    Vector<Float> differencesFromBest = new Vector();
    float avgDifference;
    float stDevDifference;

    public Species(ParameterCollection gaParams) {
        this.members = new Vector();
        this.parameters = gaParams;
        this.bestIndividualCopy = null;
        this.fitness = 0.0;
        this.age = 0;
        this.offspringCount = 0;
        this.defunct = true;
        this.id = "species" + CounterManager.nextCounter("speciesID");
    }

    public Species(Vector<Gene> members, ParameterCollection gaParams) {
        this(gaParams);
        this.members.addAll(members);
        this.update();
    }

    public void add(Gene member) {
        this.members.add(member);
        this.defunct = false;
    }

    public void addAll(Collection<? extends Gene> members) {
        this.members.addAll(members);
        this.defunct = false;
    }

    public void remove(Gene member) {
        int toRemoveIndex = this.members.indexOf(member);
        if (toRemoveIndex != -1) {
            this.remove(toRemoveIndex);
        }
    }

    public Gene remove(int index) {
        if (index < 0 || index >= this.members.size()) {
            LogManager.writeError("Error", this, "member index out of range");
            return null;
        }
        Gene result = this.members.get(index);
        this.members.remove(index);
        return result;
    }

    public boolean isDefunct() {
        return this.defunct;
    }

    public void clear() {
        this.members.clear();
    }

    public int size() {
        return this.members.size();
    }

    public int indexOf(Gene member) {
        return this.members.indexOf(member);
    }

    public Gene get(int index) {
        if (index < 0 || index >= this.members.size()) {
            LogManager.writeError("Error", this, "gene index out of bouds");
            return null;
        }
        return this.members.get(index);
    }

    public String toXML() {
        String result = "<species>";
        result = result + "<id value=\"" + this.id + "\"/>\n";
        result = result + "<age value=\"" + this.age + "\"/>\n";
        result = result + "<lastUpdate value=\"" + this.lastUpdate + "\"/>\n";
        result = result + "<defunct value=\"" + this.defunct + "\"/>\n";
        result = result + this.bestIndividualCopy.toXML();
        result = result + "</species>\n";
        return result;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public Vector<Gene> getMembers() {
        return this.members;
    }

    public double getFitness() {
        return this.fitness;
    }

    public int getOffspringCount() {
        return this.offspringCount;
    }

    public int getAge() {
        return this.age;
    }

    public int getLastUpdate() {
        return this.lastUpdate;
    }

    public String getID() {
        return this.id;
    }

    public void setOffspringCount(int value) {
        this.offspringCount = value;
    }

    public void findBestIndividual() {
        Gene tempBest = this.bestIndividualCopy;
        for (Gene g : this.members) {
            if (tempBest != null && !(g.getFitness() > tempBest.getFitness())) continue;
            tempBest = g;
        }
        if (tempBest != this.bestIndividualCopy) {
            this.bestIndividualCopy = tempBest.clone();
            this.lastUpdate = this.age;
        }
    }

    public void findDifferences() {
        this.avgDifference = 0.0f;
        this.stDevDifference = 0.0f;
        this.differencesFromBest.clear();
        for (Gene g : this.members) {
            float compat = g.getDifference(this.bestIndividualCopy);
            this.differencesFromBest.add(Float.valueOf(compat));
            this.avgDifference += compat;
        }
        if (this.differencesFromBest.size() > 0) {
            this.avgDifference /= (float)this.differencesFromBest.size();
        }
        for (int i = 0; i < this.differencesFromBest.size(); ++i) {
            this.stDevDifference = (float)((double)this.stDevDifference + Math.pow(this.differencesFromBest.get(i).floatValue() - this.avgDifference, 2.0));
        }
        if (this.differencesFromBest.size() > 1) {
            this.stDevDifference /= (float)(this.differencesFromBest.size() - 1);
        }
    }

    public void update() {
        this.findBestIndividual();
        this.fitness = 0.0;
        for (Gene g : this.members) {
            double currFitness = g.getFitness();
            this.fitness += currFitness;
        }
        if (this.members.size() > 0) {
            this.fitness /= (double)this.members.size();
            this.defunct = false;
        } else {
            this.defunct = true;
        }
        this.offspringCount = 0;
        ++this.age;
    }

    public Species split() {
        if (this.differencesFromBest.size() < 2) {
            return null;
        }
        int outlierIndex = this.differencesFromBest.indexOf(Collections.max(this.differencesFromBest));
        if (outlierIndex == -1) {
            return null;
        }
        Gene outlier = this.members.get(outlierIndex);
        this.remove(outlier);
        Species result = new Species(this.parameters);
        result.add(outlier);
        Vector<Gene> outlierAdditions = new Vector<Gene>();
        for (int i = 0; i < this.size(); ++i) {
            Gene temp = this.members.get(i);
            if (!(this.differencesFromBest.get(i).floatValue() > temp.getDifference(outlier))) continue;
            outlierAdditions.add(temp);
        }
        for (Gene g : outlierAdditions) {
            this.remove(g);
            result.add(g);
        }
        result.update();
        this.update();
        return result;
    }

    public Species mergeWith(Species otherSpecies) {
        if (otherSpecies == null) {
            LogManager.writeError("Error", this, "merged species is null");
        }
        Species result = new Species(this.parameters);
        result.addAll(otherSpecies.getMembers());
        result.update();
        return result;
    }

    public Gene getBestIndividualCopy() {
        return this.bestIndividualCopy;
    }

    public double getBestFitness() {
        if (this.bestIndividualCopy == null) {
            return 0.0;
        }
        return this.bestIndividualCopy.getFitness();
    }

    public float getDifference(Gene other) {
        if (this.bestIndividualCopy == null) {
            LogManager.writeError("Error", this, "species not initialized yet.");
        }
        return this.bestIndividualCopy.getDifference(other);
    }

    public float getAvgDifference() {
        return this.avgDifference;
    }

    public float getStDevDifference() {
        return this.stDevDifference;
    }
}

