/*
 * Decompiled with CFR 0.152.
 */
package genetic;

import genetic.Gene;
import genetic.Species;
import genetic.SpeciesOffspringCountComparator;
import java.util.Collections;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.CounterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeciesLibrary
extends Vector<Species> {
    ParameterCollection parameters;
    final float incDifferenceThreshold;
    final float minDifferenceThreshold;
    final int speciesTargetNumber;
    float currDifferenceThreshold;

    public SpeciesLibrary(ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.speciesTargetNumber = this.parameters.contains("speciesTargetNumber") ? this.parameters.getInteger("speciesTargetNumber") : 8;
        this.incDifferenceThreshold = this.parameters.contains("incDifferenceThreshold") ? this.parameters.getFloat("incDifferenceThreshold") : 0.1f;
        this.minDifferenceThreshold = this.parameters.contains("minDifferenceThreshold") ? this.parameters.getFloat("minDifferenceThreshold") : this.incDifferenceThreshold;
        this.currDifferenceThreshold = this.parameters.contains("initialDifferenceThreshold") ? this.parameters.getFloat("initialDifferenceThreshold") : 0.3f;
        CounterManager.addCounter("speciesID", 0);
    }

    public void replacePopulation(Vector<Gene> offspring) {
        this.clearSpecies();
        for (int k = 0; k < offspring.size(); ++k) {
            Gene gene = offspring.get(k);
            float minDifference = Float.MAX_VALUE;
            int closestSpecies = -1;
            for (int i = 0; i < this.size(); ++i) {
                float currDifference = ((Species)this.get(i)).getDifference(gene);
                if (!(currDifference < minDifference)) continue;
                minDifference = currDifference;
                closestSpecies = i;
            }
            if (closestSpecies != -1) {
                System.out.println("closestSpecies=" + ((Species)this.get((int)closestSpecies)).id + " minDifference=" + minDifference);
            }
            if (closestSpecies != -1 && minDifference < this.currDifferenceThreshold) {
                ((Species)this.get(closestSpecies)).add(gene);
                continue;
            }
            Species addedSpecies = new Species(this.parameters);
            addedSpecies.add(gene);
            addedSpecies.findBestIndividual();
            this.add(addedSpecies);
        }
    }

    public void cleanDefunctSpecies() {
        Vector removedSpecies = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            if (!((Species)this.get(i)).isDefunct()) continue;
            removedSpecies.add(this.get(i));
        }
        this.removeAll(removedSpecies);
    }

    public int getActiveSpecies() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (((Species)this.get(i)).isDefunct()) continue;
            ++result;
        }
        return result;
    }

    public int getDefunctSpecies() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!((Species)this.get(i)).isDefunct()) continue;
            ++result;
        }
        return result;
    }

    public void update(int totalOffspringCount) {
        for (int i = 0; i < this.size(); ++i) {
            if (((Species)this.get(i)).isDefunct()) continue;
            ((Species)this.get(i)).update();
        }
        this.cleanDefunctSpecies();
        double totalFitness = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            totalFitness += ((Species)this.get(i)).getFitness();
        }
        int assignedOffspring = 0;
        for (int i = 0; i < this.size(); ++i) {
            int currOffspringCount = totalFitness == 0.0 ? (int)Math.floor((float)totalOffspringCount / (float)this.size()) : (int)Math.floor((double)totalOffspringCount * ((Species)this.get(i)).getFitness() / totalFitness);
            System.out.println(((Species)this.get(i)).getID() + " fn = " + ((Species)this.get(i)).getFitness() + " / " + totalFitness + " offspring=" + currOffspringCount);
            assignedOffspring += currOffspringCount;
            ((Species)this.get(i)).setOffspringCount(currOffspringCount);
        }
        System.out.println("assignedOffspring " + assignedOffspring);
        Collections.sort(this, new SpeciesOffspringCountComparator());
        int index = this.size() - 1;
        while (assignedOffspring < totalOffspringCount) {
            if (((Species)this.get(index)).getOffspringCount() > 0) {
                ((Species)this.get(index)).setOffspringCount(((Species)this.get(index)).getOffspringCount() + 1);
                ++assignedOffspring;
            }
            if (--index >= 0) continue;
            index = this.size() - 1;
        }
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(((Species)this.get(i)).getID() + " fn = " + ((Species)this.get(i)).getFitness() + " / " + totalFitness + " offspring=" + ((Species)this.get(i)).getOffspringCount());
        }
        this.adjustDifferenceThreshold();
        System.out.println("currDifferenceThreshold=" + this.currDifferenceThreshold);
        System.out.println("Species: " + this.getActiveSpecies());
        int totalPopulation = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (((Species)this.get(i)).isDefunct()) continue;
            System.out.println("Species " + ((Species)this.get(i)).getID() + " (" + ((Species)this.get(i)).getMemberCount() + ") fn=" + ((Species)this.get(i)).getFitness());
            totalPopulation += ((Species)this.get(i)).getMemberCount();
        }
        System.out.println("Total offspring = " + totalPopulation);
    }

    public void adjustDifferenceThreshold() {
        int activeSpecies = this.getActiveSpecies();
        this.currDifferenceThreshold = activeSpecies > this.speciesTargetNumber ? (this.currDifferenceThreshold < this.minDifferenceThreshold ? (this.currDifferenceThreshold *= 2.0f) : (this.currDifferenceThreshold += this.incDifferenceThreshold)) : (this.currDifferenceThreshold < 2.0f * this.minDifferenceThreshold ? (this.currDifferenceThreshold /= 2.0f) : (this.currDifferenceThreshold -= this.incDifferenceThreshold));
    }

    public void clearSpecies() {
        for (int i = 0; i < this.size(); ++i) {
            ((Species)this.get(i)).clear();
        }
    }
}

