/*
 * Decompiled with CFR 0.152.
 */
package genetic.bitarray;

import genetic.Gene;
import genetic.bitarray.BAGene;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAExpandableGene
extends BAGene {
    public BAExpandableGene(int arraySize, ParameterCollection gaParams) {
        super(arraySize, gaParams);
    }

    public BAExpandableGene(Gene copy) {
        super(copy);
    }

    public BAExpandableGene(double[] genotype, ParameterCollection gaParams) {
        super(genotype, gaParams);
    }

    @Override
    public Vector<Gene> produceOffspring(Gene other) {
        Vector<Gene> result = new Vector<Gene>();
        if (!(other instanceof BAGene)) {
            LogManager.writeError("Error", this, "combining genes of different types");
            return result;
        }
        double[] otherGenotype = ((BAGene)other).getGenotype();
        int geneLengthDifference = ((double[])this.genotype).length - otherGenotype.length;
        int geneOffset = 0;
        if (geneLengthDifference > 0) {
            geneOffset = RandomNumberManager.getRandomInt(0, geneLengthDifference + 1);
        } else if (geneLengthDifference < 0) {
            geneOffset = -RandomNumberManager.getRandomInt(0, -geneLengthDifference);
        }
        double[] offspring1Array = new double[((double[])this.genotype).length + geneOffset];
        double[] offspring2Array = new double[((double[])this.genotype).length];
        int crossoverPoints = 0;
        if (this.parameters.contains("crossoverPoints")) {
            crossoverPoints = this.parameters.getInteger("crossoverPoints");
        }
        if (crossoverPoints <= 0) {
            double chanceToCopyOther = 0.5;
            if (other.getFitness() + this.fitness > 0.0) {
                chanceToCopyOther = other.getFitness() / (other.getFitness() + this.fitness);
            }
            if (geneLengthDifference > 0) {
                int i;
                for (i = 0; i < geneOffset; ++i) {
                    offspring1Array[i] = ((double[])this.genotype)[i];
                }
                for (i = 0; i < otherGenotype.length; ++i) {
                    if (RandomNumberManager.getRandomDouble() < chanceToCopyOther) {
                        offspring1Array[i + geneOffset] = ((double[])this.genotype)[i + geneOffset];
                        offspring2Array[i] = otherGenotype[i];
                        continue;
                    }
                    offspring1Array[i + geneOffset] = otherGenotype[i];
                    offspring2Array[i] = ((double[])this.genotype)[i + geneOffset];
                }
                for (i = otherGenotype.length + geneOffset; i < offspring1Array.length; ++i) {
                    offspring1Array[i] = ((double[])this.genotype)[i];
                }
            } else {
                int i;
                for (i = 0; i < -geneOffset; ++i) {
                    offspring2Array[i] = ((double[])this.genotype)[i];
                }
                for (i = 0; i < ((double[])this.genotype).length; ++i) {
                    if (RandomNumberManager.getRandomDouble() < chanceToCopyOther) {
                        offspring1Array[i] = ((double[])this.genotype)[i];
                        offspring2Array[i - geneOffset] = otherGenotype[i - geneOffset];
                        continue;
                    }
                    offspring1Array[i] = otherGenotype[i - geneOffset];
                    offspring2Array[i - geneOffset] = ((double[])this.genotype)[i];
                }
                for (i = ((double[])this.genotype).length - geneOffset; i < offspring2Array.length; ++i) {
                    offspring2Array[i] = ((double[])this.genotype)[i];
                }
            }
        } else if (crossoverPoints > 0) {
            int[] crossoverLocations = new int[crossoverPoints];
            int minimalLength = Math.min(offspring1Array.length, offspring2Array.length);
            crossoverLocations[0] = RandomNumberManager.getRandomInt(1, minimalLength - crossoverPoints);
            for (int c = 1; c < crossoverPoints; ++c) {
                crossoverLocations[c] = RandomNumberManager.getRandomInt(crossoverLocations[c - 1], minimalLength - c);
            }
            int currCrossover = 0;
            if (geneLengthDifference > 0) {
                int i;
                for (i = 0; i < geneOffset; ++i) {
                    offspring1Array[i] = ((double[])this.genotype)[i];
                }
                for (i = 0; i < otherGenotype.length; ++i) {
                    if (currCrossover < crossoverLocations.length && i >= crossoverLocations[currCrossover]) {
                        ++currCrossover;
                    }
                    if (currCrossover % 2 == 0) {
                        offspring1Array[i + geneOffset] = ((double[])this.genotype)[i + geneOffset];
                        offspring2Array[i] = otherGenotype[i];
                        continue;
                    }
                    offspring1Array[i + geneOffset] = otherGenotype[i];
                    offspring2Array[i] = ((double[])this.genotype)[i + geneOffset];
                }
                for (i = otherGenotype.length + geneOffset; i < offspring1Array.length; ++i) {
                    offspring1Array[i] = ((double[])this.genotype)[i];
                }
            } else {
                int i;
                for (i = 0; i < -geneOffset; ++i) {
                    offspring2Array[i] = ((double[])this.genotype)[i];
                }
                for (i = 0; i < ((double[])this.genotype).length; ++i) {
                    if (currCrossover < crossoverLocations.length && i >= crossoverLocations[currCrossover]) {
                        ++currCrossover;
                    }
                    if (currCrossover % 2 == 0) {
                        offspring1Array[i] = ((double[])this.genotype)[i];
                        offspring2Array[i - geneOffset] = otherGenotype[i - geneOffset];
                        continue;
                    }
                    offspring1Array[i] = otherGenotype[i - geneOffset];
                    offspring2Array[i - geneOffset] = ((double[])this.genotype)[i];
                }
                for (i = ((double[])this.genotype).length - geneOffset; i < offspring2Array.length; ++i) {
                    offspring2Array[i] = ((double[])this.genotype)[i];
                }
            }
        }
        BAExpandableGene offspring1 = new BAExpandableGene(offspring1Array, this.parameters);
        offspring1.bindGenotype();
        result.add(offspring1);
        BAExpandableGene offspring2 = new BAExpandableGene(offspring2Array, this.parameters);
        offspring2.bindGenotype();
        result.add(offspring2);
        return result;
    }

    @Override
    public BAGene mutate() {
        BAExpandableGene result = new BAExpandableGene((double[])this.genotype, this.parameters);
        int mutateAddBitsNumber = 0;
        int mutateAddBitsChance = 0;
        int mutateMaxBitsNumber = -1;
        int mutateInvertArray = 0;
        int mutateGaussian = 0;
        int mutateRandomOffset = 0;
        int mutateNegativeBit = 0;
        int mutateBitMinNumber = 0;
        int mutateBitMaxNumber = 1;
        int genotypeMinInitialValue = 0;
        int genotypeMaxInitialValue = 1;
        if (this.parameters.contains("mutateAddBitsChance")) {
            mutateInvertArray = this.parameters.getInteger("mutateAddBitsChance");
        }
        if (this.parameters.contains("mutateAddBitsNumber")) {
            mutateInvertArray = this.parameters.getInteger("mutateAddBitsNumber");
        }
        if (this.parameters.contains("mutateMaxBitsNumber")) {
            mutateInvertArray = this.parameters.getInteger("mutateMaxBitsNumber");
        }
        if (this.parameters.contains("mutateInvertArray")) {
            mutateInvertArray = this.parameters.getInteger("mutateInvertArray");
        }
        if (this.parameters.contains("mutateGaussian")) {
            mutateGaussian = this.parameters.getInteger("mutateGaussian");
        }
        if (this.parameters.contains("mutateRandomOffset")) {
            mutateRandomOffset = this.parameters.getInteger("mutateRandomOffset");
        }
        if (this.parameters.contains("mutateNegativeBit")) {
            mutateNegativeBit = this.parameters.getInteger("mutateNegativeBit");
        }
        if (this.parameters.contains("mutateBitMinNumber")) {
            mutateBitMinNumber = this.parameters.getInteger("mutateBitMinNumber");
        }
        if (this.parameters.contains("mutateBitMaxNumber")) {
            mutateBitMaxNumber = this.parameters.getInteger("mutateBitMaxNumber");
        }
        if (this.parameters.contains("genotypeMinInitialValue")) {
            genotypeMinInitialValue = this.parameters.getInteger("genotypeMinInitialValue");
        }
        if (this.parameters.contains("genotypeMaxInitialValue")) {
            genotypeMaxInitialValue = this.parameters.getInteger("genotypeMaxInitialValue");
        }
        if (RandomNumberManager.getRandomInt(0, 100) < mutateAddBitsChance && mutateAddBitsNumber > 0 && (mutateMaxBitsNumber < 0 || ((double[])result.genotype).length + mutateAddBitsNumber <= mutateMaxBitsNumber)) {
            double[] bloatedGenotype = new double[((double[])result.genotype).length + mutateAddBitsNumber];
            for (int i = 0; i < bloatedGenotype.length; ++i) {
                bloatedGenotype[i] = i < ((double[])result.genotype).length ? ((double[])result.genotype)[i] : RandomNumberManager.getRandomDouble(genotypeMinInitialValue, genotypeMaxInitialValue);
            }
        } else if (RandomNumberManager.getRandomInt(0, 100) < mutateInvertArray) {
            for (int i = 0; i < ((double[])result.genotype).length; ++i) {
                ((double[])result.genotype)[i] = ((double[])result.genotype)[((double[])result.genotype).length - 1 - i];
            }
        } else {
            Vector<Integer> mutatedIndexes = new Vector<Integer>();
            int bitsToMutate = RandomNumberManager.getRandomInt(mutateBitMinNumber, mutateBitMaxNumber);
            while (mutatedIndexes.size() < ((double[])result.genotype).length && mutatedIndexes.size() < bitsToMutate) {
                for (int i = 0; i < ((double[])result.genotype).length; ++i) {
                    if (mutatedIndexes.contains(i)) continue;
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateGaussian) {
                        mutatedIndexes.add(i);
                        double[] dArray = (double[])result.genotype;
                        int n = i;
                        dArray[n] = dArray[n] + RandomNumberManager.getRandomGaussian();
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateRandomOffset) {
                        mutatedIndexes.add(i);
                        double[] dArray = (double[])result.genotype;
                        int n = i;
                        dArray[n] = dArray[n] + RandomNumberManager.getRandomDouble();
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) >= mutateNegativeBit) continue;
                    mutatedIndexes.add(i);
                    ((double[])result.genotype)[i] = -((double[])result.genotype)[i];
                }
            }
        }
        result.bindGenotype();
        return result;
    }

    @Override
    public float getDifference(Gene other) {
        if (!(other instanceof BAExpandableGene)) {
            LogManager.writeError("Error", this, "comparing genes of different types");
            return 0.0f;
        }
        BAExpandableGene ba_other = (BAExpandableGene)other;
        if (((double[])this.genotype).length != ((double[])ba_other.genotype).length) {
            LogManager.writeError("Error", this, "comparing genes of different length");
            return 0.0f;
        }
        float result = 0.0f;
        for (int i = 0; i < ((double[])this.genotype).length; ++i) {
            result = (float)((double)result + Math.abs(((double[])this.genotype)[i] - ((double[])ba_other.genotype)[i]));
        }
        return result;
    }
}

