/*
 * Decompiled with CFR 0.152.
 */
package genetic.bitarray;

import genetic.Gene;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAGene
extends Gene<double[]> {
    public BAGene(int arraySize, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.phenotype = null;
        this.fitness = 0.0;
        this.genotype = new double[arraySize];
    }

    public BAGene(Gene copy) {
        if (!(copy instanceof BAGene)) {
            LogManager.writeError("Error", this, "combining genes of different types");
            return;
        }
        BAGene ba_copy = (BAGene)copy;
        this.parameters = ba_copy.parameters;
        this.phenotype = null;
        this.fitness = 0.0;
        this.genotype = new double[((double[])ba_copy.genotype).length];
        for (int i = 0; i < ((double[])this.genotype).length; ++i) {
            ((double[])this.genotype)[i] = ((double[])ba_copy.genotype)[i];
        }
    }

    public BAGene(double[] genotype, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.phenotype = null;
        this.fitness = 0.0;
        this.genotype = new double[genotype.length];
        for (int i = 0; i < genotype.length; ++i) {
            ((double[])this.genotype)[i] = genotype[i];
        }
    }

    @Override
    public void randomize() {
        int genotypeMinInitialValue = 0;
        int genotypeMaxInitialValue = 1;
        if (this.parameters.contains("genotypeMinInitialValue")) {
            genotypeMinInitialValue = this.parameters.getInteger("genotypeMinInitialValue");
        }
        if (this.parameters.contains("genotypeMaxInitialValue")) {
            genotypeMaxInitialValue = this.parameters.getInteger("genotypeMaxInitialValue");
        }
        for (int i = 0; i < ((double[])this.genotype).length; ++i) {
            ((double[])this.genotype)[i] = RandomNumberManager.getRandomDouble(genotypeMinInitialValue, genotypeMaxInitialValue);
        }
    }

    public static BAGene loadFromString(String xml, ParameterCollection gaParams) {
        String localXml = new String(xml);
        localXml.replace("<gene>", "");
        localXml.replace("<array>", "");
        localXml.replace("</array>", "");
        localXml.replace("</gene>", "");
        String[] allelesStr = localXml.split(";");
        double[] alleles = new double[allelesStr.length];
        for (int i = 0; i < alleles.length; ++i) {
            alleles[i] = Double.parseDouble(allelesStr[i]);
        }
        return new BAGene(alleles, gaParams);
    }

    @Override
    public BAGene clone() {
        return new BAGene(this);
    }

    @Override
    public String toXML() {
        String result = "";
        result = result + "<gene>";
        result = result + "<array>";
        for (int i = 0; i < ((double[])this.genotype).length; ++i) {
            result = result + ((double[])this.genotype)[i];
            if (i >= ((double[])this.genotype).length - 1) continue;
            result = result + ";";
        }
        result = result + "</array>";
        result = result + "</gene>";
        return result;
    }

    @Override
    public Vector<Gene> produceOffspring(Gene other) {
        Vector<Gene> result = new Vector<Gene>();
        if (!(other instanceof BAGene)) {
            LogManager.writeError("Error", this, "combining genes of different types");
            return result;
        }
        BAGene ba_other = (BAGene)other;
        double[] offspring1Array = new double[((double[])this.genotype).length];
        double[] offspring2Array = new double[((double[])this.genotype).length];
        if (((double[])this.genotype).length != ((double[])ba_other.genotype).length) {
            LogManager.writeError("Error", this, "recombining genes of different length");
            return null;
        }
        if (((double[])this.genotype).length == 0 || ((double[])ba_other.genotype).length == 0) {
            LogManager.writeError("Error", this, "one or more of the genes are empty");
            return null;
        }
        int crossoverPoints = 0;
        if (this.parameters.contains("crossoverPoints")) {
            crossoverPoints = this.parameters.getInteger("crossoverPoints");
        }
        if (crossoverPoints <= 0) {
            double chanceToCopyOther = 0.5;
            if (ba_other.getFitness() + this.fitness > 0.0) {
                chanceToCopyOther = ba_other.getFitness() / (ba_other.getFitness() + this.fitness);
            }
            for (int i = 0; i < offspring1Array.length; ++i) {
                if (RandomNumberManager.getRandomDouble() < chanceToCopyOther) {
                    offspring1Array[i] = ((double[])this.genotype)[i];
                    offspring2Array[i] = ((double[])ba_other.genotype)[i];
                    continue;
                }
                offspring1Array[i] = ((double[])ba_other.genotype)[i];
                offspring2Array[i] = ((double[])this.genotype)[i];
            }
        } else if (crossoverPoints > 0) {
            int[] crossoverLocations = new int[crossoverPoints];
            crossoverLocations[0] = RandomNumberManager.getRandomInt(1, offspring1Array.length - crossoverPoints);
            for (int c = 1; c < crossoverPoints; ++c) {
                crossoverLocations[c] = RandomNumberManager.getRandomInt(crossoverLocations[c - 1], offspring1Array.length - c);
            }
            int currCrossover = 0;
            for (int i = 0; i < offspring1Array.length; ++i) {
                if (currCrossover < crossoverLocations.length && i >= crossoverLocations[currCrossover]) {
                    ++currCrossover;
                }
                if (currCrossover % 2 == 0) {
                    offspring1Array[i] = ((double[])this.genotype)[i];
                    offspring2Array[i] = ((double[])ba_other.genotype)[i];
                    continue;
                }
                offspring1Array[i] = ((double[])ba_other.genotype)[i];
                offspring2Array[i] = ((double[])this.genotype)[i];
            }
        }
        BAGene offspring1 = new BAGene(offspring1Array, this.parameters);
        offspring1.bindGenotype();
        result.add(offspring1);
        BAGene offspring2 = new BAGene(offspring2Array, this.parameters);
        offspring2.bindGenotype();
        result.add(offspring2);
        return result;
    }

    @Override
    public BAGene mutate() {
        BAGene result = new BAGene((double[])this.genotype, this.parameters);
        int mutateInvertArray = 0;
        int mutateGaussian = 0;
        int mutateRandomOffset = 0;
        int mutateNegativeBit = 0;
        int mutateBitMinNumber = 0;
        int mutateBitMaxNumber = 1;
        if (this.parameters.contains("mutateInvertArray")) {
            mutateInvertArray = this.parameters.getInteger("mutateInvertArray");
        }
        if (this.parameters.contains("mutateGaussian")) {
            mutateGaussian = this.parameters.getInteger("mutateGaussian");
        }
        if (this.parameters.contains("mutateRandomOffset")) {
            mutateRandomOffset = this.parameters.getInteger("mutateRandomOffset");
        }
        if (this.parameters.contains("mutateNegativeBit")) {
            mutateNegativeBit = this.parameters.getInteger("mutateNegativeBit");
        }
        if (this.parameters.contains("mutateBitMinNumber")) {
            mutateBitMinNumber = this.parameters.getInteger("mutateBitMinNumber");
        }
        if (this.parameters.contains("mutateBitMaxNumber")) {
            mutateBitMaxNumber = this.parameters.getInteger("mutateBitMaxNumber");
        }
        if (RandomNumberManager.getRandomInt(0, 100) < mutateInvertArray) {
            for (int i = 0; i < ((double[])result.genotype).length / 2; ++i) {
                double temp = ((double[])result.genotype)[i];
                ((double[])result.genotype)[i] = ((double[])result.genotype)[((double[])result.genotype).length - (i + 1)];
                ((double[])result.genotype)[((double[])result.genotype).length - (i + 1)] = temp;
            }
        } else {
            Vector<Integer> mutatedIndexes = new Vector<Integer>();
            int bitsToMutate = RandomNumberManager.getRandomInt(mutateBitMinNumber, mutateBitMaxNumber);
            while (mutatedIndexes.size() < ((double[])result.genotype).length && mutatedIndexes.size() < bitsToMutate) {
                for (int i = 0; i < ((double[])result.genotype).length; ++i) {
                    if (mutatedIndexes.contains(i)) continue;
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateGaussian) {
                        mutatedIndexes.add(i);
                        double[] dArray = (double[])result.genotype;
                        int n = i;
                        dArray[n] = dArray[n] + RandomNumberManager.getRandomGaussian();
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateRandomOffset) {
                        mutatedIndexes.add(i);
                        double[] dArray = (double[])result.genotype;
                        int n = i;
                        dArray[n] = dArray[n] + RandomNumberManager.getRandomDouble();
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) >= mutateNegativeBit) continue;
                    mutatedIndexes.add(i);
                    ((double[])result.genotype)[i] = -((double[])result.genotype)[i];
                }
            }
        }
        result.bindGenotype();
        return result;
    }

    @Override
    public float getDifference(Gene other) {
        if (!(other instanceof BAGene)) {
            LogManager.writeError("Error", this, "comparing genes of different types");
            return 0.0f;
        }
        BAGene ba_other = (BAGene)other;
        if (((double[])this.genotype).length != ((double[])ba_other.genotype).length) {
            LogManager.writeError("Error", this, "comparing genes of different length");
            return 0.0f;
        }
        float result = 0.0f;
        for (int i = 0; i < ((double[])this.genotype).length; ++i) {
            result = (float)((double)result + Math.abs(((double[])this.genotype)[i] - ((double[])ba_other.genotype)[i]));
        }
        return result /= (float)((double[])this.genotype).length;
    }

    public void bindGenotype() {
        this.bindGenotype(false);
    }

    public void bindGenotype(boolean initialValues) {
        boolean genotypeInteger = false;
        int genotypeMinValue = 0;
        int genotypeMaxValue = 0;
        if (this.parameters.contains("genotypeInteger")) {
            genotypeInteger = this.parameters.getBoolean("genotypeInteger");
        }
        if (initialValues && this.parameters.contains("genotypeMinInitialValue")) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinInitialValue");
        }
        if (initialValues && this.parameters.contains("genotypeMaxInitialValue")) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxInitialValue");
        }
        if (!(initialValues && this.parameters.contains("genotypeMinInitialValue") || !this.parameters.contains("genotypeMinValue"))) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinValue");
        }
        if (!(initialValues && this.parameters.contains("genotypeMaxInitialValue") || !this.parameters.contains("genotypeMaxValue"))) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxValue");
        }
        for (int i = 0; i < ((double[])this.genotype).length; ++i) {
            ((double[])this.genotype)[i] = Math.max(((double[])this.genotype)[i], (double)genotypeMinValue);
            ((double[])this.genotype)[i] = Math.min(((double[])this.genotype)[i], (double)genotypeMaxValue);
        }
    }

    @Override
    public double[] getGenotype() {
        double[] result = new double[((double[])this.genotype).length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((double[])this.genotype)[i];
        }
        return result;
    }
}

