/*
 * Decompiled with CFR 0.152.
 */
package genetic.bitarray;

import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.bitarray.BAGene;
import genetic.comparators.GeneFitnessComparator;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAGeneticAlgorithm
extends GeneticAlgorithm {
    public BAGeneticAlgorithm(ParameterCollection gaParams) {
        super(gaParams);
    }

    public static BAGeneticAlgorithm loadFromXML(String filename, ParameterCollection gaParams) {
        File file = new File(filename);
        if (!file.exists()) {
            LogManager.writeError("Error", null, "file " + filename + " does not exist.");
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (Exception e) {
            LogManager.writeError("Error", null, "error parsing file " + filename + ".");
            return null;
        }
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().endsWith("population")) {
            LogManager.writeError("Error", null, "invalid XML root");
            return null;
        }
        BAGeneticAlgorithm result = new BAGeneticAlgorithm(gaParams);
        result.allGenes.clear();
        NodeList nodeLst = doc.getElementsByTagName("gene");
        for (int i = 0; i < nodeLst.getLength(); ++i) {
            if (nodeLst.item(i).getNodeType() != 1) {
                LogManager.writeError("Error", null, "invalid XML node");
                break;
            }
            Element el = (Element)nodeLst.item(i);
            result.allGenes.add(BAGene.loadFromString(nodeLst.item(i).getTextContent(), gaParams));
        }
        return result;
    }

    @Override
    public void initializePopulationHelper() {
        this.allGenes = new Vector();
        int population = this.parameters.getInteger("population");
        int arraySize = this.parameters.getInteger("arraySize");
        if (arraySize <= 0) {
            LogManager.writeError("Error", this, "arraySize not defined");
        }
        for (int i = 0; i < population; ++i) {
            this.allGenes.add(new BAGene(arraySize, this.parameters));
        }
    }

    @Override
    public Vector<Gene> generateOffspringHelper(Vector<Gene> parents, int offspringCount) {
        Vector<Gene> result = new Vector<Gene>();
        if (offspringCount <= 0) {
            return result;
        }
        int mutateAnyProbability = 0;
        if (this.parameters.contains("mutateAnyProbability")) {
            mutateAnyProbability = this.parameters.getInteger("mutateAnyProbability");
        }
        int mutateOnlyProbability = 0;
        if (this.parameters.contains("mutateOnlyProbability")) {
            mutateOnlyProbability = this.parameters.getInteger("mutateOnlyProbability");
        }
        int steadyPercentage = 0;
        if (this.parameters.contains("steadyPercentage")) {
            steadyPercentage = this.parameters.getInteger("steadyPercentage");
        }
        int steadyGeneCount = Math.max(1, steadyPercentage * offspringCount / 100);
        offspringCount -= steadyGeneCount;
        Collections.sort(this.allGenes, new GeneFitnessComparator());
        for (int i = 0; i < steadyGeneCount; ++i) {
            result.add(new BAGene((Gene)this.allGenes.get(i)));
        }
        Vector<Integer> roulette = this.generateRouletteWheel(this.allGenes);
        while (offspringCount > 0) {
            Gene firstChild = this.rollRouletteWheel(this.allGenes, roulette);
            Gene secondChild = null;
            int roll = RandomNumberManager.getRandomInt(0, 100);
            if (roll >= mutateOnlyProbability && offspringCount > 1) {
                for (int tries = 100; tries > 0 && (secondChild = this.rollRouletteWheel(this.allGenes, roulette)).getDifference(firstChild) != 0.0f; --tries) {
                }
            }
            if (secondChild == null) {
                result.add(firstChild.mutate());
                --offspringCount;
                continue;
            }
            Vector<Gene> offspring = firstChild.produceOffspring(secondChild);
            for (Gene off : offspring) {
                int roll_mutate = RandomNumberManager.getRandomInt(0, 100);
                if (roll_mutate < mutateAnyProbability) continue;
                off.mutate();
            }
            result.addAll(offspring);
            offspringCount -= offspring.size();
        }
        return result;
    }

    protected Vector<Integer> generateRouletteWheel(Vector<Gene> genes) {
        Vector<Integer> result = new Vector<Integer>();
        double maxFitness = genes.firstElement().getFitness();
        double minFitness = genes.lastElement().getFitness();
        int totalFitness = 0;
        for (int i = 0; i < genes.size(); ++i) {
            int nrmFtn = 1;
            if (maxFitness > minFitness) {
                nrmFtn = (int)Math.max(1.0, 1000.0 * (genes.get(i).getFitness() - minFitness) / (maxFitness - minFitness));
            }
            result.add(totalFitness += nrmFtn);
        }
        return result;
    }

    protected Gene rollRouletteWheel(Vector<Gene> genes, Vector<Integer> roulette) {
        int roll_firstChild = RandomNumberManager.getRandomInt(0, roulette.lastElement());
        for (int i = 0; i < genes.size(); ++i) {
            if (roll_firstChild >= roulette.get(i)) continue;
            return genes.get(i);
        }
        return null;
    }
}

