/*
 * Decompiled with CFR 0.152.
 */
package genetic.bitarray;

import genetic.Gene;
import genetic.bitarray.BAGene;
import genetic.bitarray.BAGeneticAlgorithm;
import genetic.comparators.GeneFitnessComparator;
import java.util.Collections;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAGeneticAlgorithm_Species
extends BAGeneticAlgorithm {
    public BAGeneticAlgorithm_Species(ParameterCollection gaParams) {
        super(gaParams);
    }

    @Override
    public void initializePopulation() {
        this.allGenes = new Vector();
        int population = this.parameters.getInteger("population");
        int arraySize = this.parameters.getInteger("arraySize");
        if (arraySize <= 0) {
            LogManager.writeError("Error", this, "arraySize not defined");
        }
        for (int i = 0; i < population; ++i) {
            this.allGenes.add(new BAGene(arraySize, this.parameters));
        }
    }

    @Override
    public Vector<Gene> generateOffspring(Vector<Gene> parents, int offspringCount) {
        Vector<Gene> result = new Vector<Gene>();
        if (offspringCount <= 0) {
            return result;
        }
        int mutateAnyProbability = 0;
        if (this.parameters.contains("mutateAnyProbability")) {
            mutateAnyProbability = this.parameters.getInteger("mutateAnyProbability");
        }
        int mutateOnlyProbability = 0;
        if (this.parameters.contains("mutateOnlyProbability")) {
            mutateOnlyProbability = this.parameters.getInteger("mutateOnlyProbability");
        }
        int steadyPercentage = 0;
        if (this.parameters.contains("steadyPercentage")) {
            steadyPercentage = this.parameters.getInteger("steadyPercentage");
        }
        int steadyGeneCount = Math.max(1, steadyPercentage * offspringCount / 100);
        offspringCount -= steadyGeneCount;
        Collections.sort(this.allGenes, new GeneFitnessComparator());
        for (int i = 0; i < steadyGeneCount; ++i) {
            result.add(new BAGene((Gene)this.allGenes.get(i)));
        }
        Vector<Integer> roulette = new Vector<Integer>();
        int totalFitness = 0;
        double maxFitness = ((Gene)this.allGenes.firstElement()).getFitness();
        double minFitness = ((Gene)this.allGenes.lastElement()).getFitness();
        for (int i = 0; i < this.allGenes.size(); ++i) {
            int nrmFtn = 1;
            if (maxFitness > minFitness) {
                nrmFtn = (int)Math.max(1.0, 1000.0 * (((Gene)this.allGenes.get(i)).getFitness() - minFitness) / (maxFitness - minFitness));
            }
            roulette.add(totalFitness += nrmFtn);
        }
        while (offspringCount > 0) {
            int roll;
            Gene firstChild = null;
            Gene secondChild = null;
            int roll_firstChild = RandomNumberManager.getRandomInt(0, totalFitness);
            for (int i = 0; i < this.allGenes.size(); ++i) {
                if (roll_firstChild >= (Integer)roulette.get(i)) continue;
                firstChild = (Gene)this.allGenes.get(i);
                break;
            }
            if ((roll = RandomNumberManager.getRandomInt(0, 100)) >= mutateOnlyProbability && offspringCount > 1) {
                for (int tries = 100; tries > 0; --tries) {
                    int roll_secondChild = RandomNumberManager.getRandomInt(0, totalFitness + 1);
                    for (int i = 0; i < this.allGenes.size(); ++i) {
                        if (roll_secondChild >= (Integer)roulette.get(i)) continue;
                        secondChild = (Gene)this.allGenes.get(i);
                        break;
                    }
                    if (secondChild != firstChild) break;
                }
            }
            if (secondChild == null) {
                result.add(firstChild.mutate());
                --offspringCount;
                continue;
            }
            Vector<Gene> offspring = firstChild.produceOffspring(secondChild);
            for (Gene off : offspring) {
                int roll_mutate = RandomNumberManager.getRandomInt(0, 100);
                if (roll_mutate < mutateAnyProbability) continue;
                off.mutate();
            }
            result.addAll(offspring);
            offspringCount -= offspring.size();
        }
        return result;
    }
}

