/*
 * Decompiled with CFR 0.152.
 */
package genetic.bitarray;

import genetic.GeneticAlgorithmTrainer;
import genetic.bitarray.BAGeneticAlgorithm;
import genetic.bitarray.MinusOneEmbryogeny;
import genetic.bitarray.MinusOneFitness;
import util.collections.ParameterCollection;

public class Benchmark {
    public static void main(String[] args) {
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", "200");
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "0");
        params.setParameter("arraySize", "100");
        params.setParameter("crossoverPoints", "1");
        params.setParameter("genotypeInteger", "1");
        params.setParameter("genotypeMinInitialValue", "-2");
        params.setParameter("genotypeMaxInitialValue", "2");
        params.setParameter("genotypeMinValue", "-5");
        params.setParameter("genotypeMaxValue", "5");
        params.setParameter("mutateAnyProbability", "5");
        params.setParameter("mutateInvertArray", "15");
        params.setParameter("mutateGaussian", "20");
        params.setParameter("mutateRandomOffset", "10");
        params.setParameter("mutateNegativeBit", "10");
        params.setParameter("mutateBitMinNumber", "10");
        params.setParameter("mutateBitMaxNumber", "30");
        params.setParameter("speciesTargetNumber", "10");
        params.setParameter("incDifferenceThreshold", "0.1");
        params.setParameter("minDifferenceThreshold", "0.1");
        params.setParameter("initialDifferenceThreshold", "1.0");
        params.saveToXML("geneticalgorithm_minusone.xml");
        BAGeneticAlgorithm ga = new BAGeneticAlgorithm(params);
        ga.initializePopulation();
        ga.randomizePopulation();
        GeneticAlgorithmTrainer gTrainer = new GeneticAlgorithmTrainer(new MinusOneFitness(), new MinusOneEmbryogeny(), ga, params);
        gTrainer.setLogID("logs/generic/MinusOneTrainingGA");
        for (int i = 0; i < 100; ++i) {
            gTrainer.train(1);
            gTrainer.writeSpeciesProgress();
        }
    }
}

