/*
 * Decompiled with CFR 0.152.
 */
package genetic.comparators;

import genetic.Embryogeny;
import genetic.Gene;
import genetic.fitness.Fitness;
import java.util.Comparator;

public class CustomGeneFitnessComparator
implements Comparator {
    Fitness customFitness = null;
    Embryogeny customEmbryogeny = null;

    public CustomGeneFitnessComparator(Fitness fn) {
        this.customFitness = fn;
        this.customEmbryogeny = null;
    }

    public CustomGeneFitnessComparator(Fitness fn, Embryogeny embryo) {
        this.customFitness = fn;
        this.customEmbryogeny = embryo;
    }

    public int compare(Object curr, Object other) {
        if (other instanceof Gene && curr instanceof Gene) {
            Object otherPhenotype;
            Object currPhenotype;
            if (this.customEmbryogeny == null) {
                currPhenotype = ((Gene)curr).getPhenotype();
                otherPhenotype = ((Gene)other).getPhenotype();
            } else {
                currPhenotype = this.customEmbryogeny.createPhenotype(((Gene)curr).getGenotype());
                otherPhenotype = this.customEmbryogeny.createPhenotype(((Gene)other).getGenotype());
            }
            double currFitness = this.customFitness.evaluate(currPhenotype);
            double otherFitness = this.customFitness.evaluate(otherPhenotype);
            return -Double.compare(currFitness, otherFitness);
        }
        System.out.println("GeneFitnessComparator: not comparing with another Gene");
        return 0;
    }
}

