/*
 * Decompiled with CFR 0.152.
 */
package genetic.fitness;

import genetic.fitness.Fitness;
import java.util.Vector;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedFitness<E>
extends Fitness<E> {
    protected Vector<WeightedFitnessPair> fitnessDimensions;

    public WeightedFitness() {
        this.init();
    }

    public WeightedFitness(Fitness fn) {
        this.init();
        this.fitnessDimensions.add(new WeightedFitnessPair(1.0, fn));
        this.generateLabel();
    }

    public WeightedFitness(double weight, Fitness fn) {
        this.init();
        this.fitnessDimensions.add(new WeightedFitnessPair(weight, fn));
        this.generateLabel();
    }

    protected void init() {
        this.fitnessDimensions = new Vector();
        this.generateLabel();
    }

    public void add(double weight, Fitness fn) {
        this.fitnessDimensions.add(new WeightedFitnessPair(weight, fn));
        this.generateLabel();
    }

    protected void generateLabel() {
        this.label = "";
        for (int i = 0; i < this.fitnessDimensions.size(); ++i) {
            WeightedFitnessPair wfp = this.fitnessDimensions.get(i);
            this.label = this.label + "" + String.format("%.4f", wfp.getWeight()) + "" + wfp.getFitness().getLabel();
            if (i >= this.fitnessDimensions.size() - 1) continue;
            this.label = this.label + "+";
        }
        if (this.label.isEmpty()) {
            this.label = "uninitialized";
        }
    }

    public void normalize() {
        int i;
        double nrmWeights = 0.0;
        double[] weights = this.getWeights();
        for (i = 0; i < weights.length; ++i) {
            nrmWeights += Math.abs(weights[i]);
        }
        for (i = 0; i < weights.length; ++i) {
            weights[i] = weights[i] / nrmWeights;
        }
        this.setWeights(weights);
    }

    public int getFitnessDimensions() {
        return this.fitnessDimensions.size();
    }

    public double[] getWeights() {
        if (this.fitnessDimensions == null) {
            LogManager.writeError("Error", this, "weights are not initialized");
            return null;
        }
        double[] result = new double[this.fitnessDimensions.size()];
        for (int i = 0; i < this.fitnessDimensions.size(); ++i) {
            result[i] = this.fitnessDimensions.get(i).getWeight();
        }
        return result;
    }

    public double getWeight(int index) {
        if (this.fitnessDimensions == null || index < 0 || index >= this.fitnessDimensions.size()) {
            LogManager.writeError("Error", this, "weights are not initialized");
            return 0.0;
        }
        return this.fitnessDimensions.get(index).getWeight();
    }

    public void setWeights(double[] weights) {
        if (weights.length != this.fitnessDimensions.size()) {
            LogManager.writeError("Error", this, "newly assigned weights do not have corresponding fitnesses");
            return;
        }
        for (int i = 0; i < weights.length; ++i) {
            this.fitnessDimensions.get(i).setWeight(weights[i]);
        }
    }

    public void setWeight(int index, double weight) {
        if (index < 0 || index >= this.fitnessDimensions.size()) {
            LogManager.writeError("Error", this, "index out of bounds");
            return;
        }
        this.fitnessDimensions.get(index).setWeight(weight);
    }

    public Fitness[] getFitnesses() {
        if (this.fitnessDimensions == null) {
            LogManager.writeError("Error", this, "weights are not initialized");
            return null;
        }
        Fitness[] result = new Fitness[this.fitnessDimensions.size()];
        for (int i = 0; i < this.fitnessDimensions.size(); ++i) {
            result[i] = this.fitnessDimensions.get(i).getFitness();
        }
        return result;
    }

    public Fitness getFitness(int index) {
        if (this.fitnessDimensions == null) {
            LogManager.writeError("Error", this, "weights are not initialized");
            return null;
        }
        if (index < 0 || index >= this.fitnessDimensions.size()) {
            LogManager.writeError("Error", this, "index out of bounds");
            return null;
        }
        return this.fitnessDimensions.get(index).getFitness();
    }

    public String printLabels() {
        String result = "";
        Fitness[] fns = this.getFitnesses();
        for (int i = 0; i < fns.length; ++i) {
            result = result + fns[i].getLabel();
            if (i >= fns.length - 1) continue;
            result = result + ";";
        }
        return result;
    }

    public String printWeights() {
        String result = "";
        double[] weights = this.getWeights();
        for (int i = 0; i < weights.length; ++i) {
            result = result + weights[i];
            if (i >= weights.length - 1) continue;
            result = result + ";";
        }
        return result;
    }

    @Override
    public double evaluateSpecific(E phenotype) {
        double result = 0.0;
        for (int i = 0; i < this.fitnessDimensions.size(); ++i) {
            if (this.fitnessDimensions.get(i).getWeight() == 0.0) continue;
            double value = this.fitnessDimensions.get(i).getFitness().evaluateSpecific(phenotype);
            double weight = this.fitnessDimensions.get(i).getWeight();
            result += weight * value;
        }
        return result;
    }

    @Override
    public double evaluateSpecific(double[] fitnessScores) {
        if (fitnessScores.length != this.fitnessDimensions.size()) {
            LogManager.writeError("Error", this, "dimension index out of bounds");
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < this.fitnessDimensions.size(); ++i) {
            double weight = this.fitnessDimensions.get(i).getWeight();
            result += weight * fitnessScores[i];
        }
        return result;
    }

    public double[] evaluateDimensions(Object phenotype) {
        double[] result = new double[this.fitnessDimensions.size()];
        for (int i = 0; i < this.fitnessDimensions.size(); ++i) {
            double value;
            result[i] = value = this.fitnessDimensions.get(i).getFitness().evaluate(phenotype);
        }
        return result;
    }

    public double evaluateDimension(Object phenotype, int dimension) {
        if (dimension < 0 || dimension >= this.fitnessDimensions.size()) {
            LogManager.writeError("Error", this, "dimension index out of bounds");
            return 0.0;
        }
        return this.fitnessDimensions.get(dimension).getFitness().evaluate(phenotype);
    }

    protected class WeightedFitnessPair {
        Fitness fn;
        double weight;

        public WeightedFitnessPair(double weight, Fitness fn) {
            this.fn = fn;
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double value) {
            this.weight = value;
        }

        public Fitness getFitness() {
            return this.fn;
        }

        public String getLabel() {
            return this.fn.getLabel();
        }
    }
}

