/*
 * Decompiled with CFR 0.152.
 */
package genetic.logger;

import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import java.util.Vector;

public class AllFitnessLogger {
    Vector<SingleFitnessLogger> allFnLoggers;
    BestFitnessLogger bestLogger = null;
    BestFitnessLogger userTasteLogger = null;
    int totalGenerations;
    int totalRuns;

    public AllFitnessLogger(int totalGenerations, int totalRuns) {
        this.totalGenerations = totalGenerations;
        this.totalRuns = totalRuns;
        this.allFnLoggers = new Vector();
    }

    public AllFitnessLogger(int totalGenerations, int totalRuns, WeightedFitness bestEvaluator) {
        this(totalGenerations, totalRuns);
        this.allFnLoggers.add(new SingleFitnessLogger(totalGenerations, totalRuns, bestEvaluator));
        this.bestLogger = new BestFitnessLogger(totalGenerations, totalRuns, bestEvaluator);
    }

    public AllFitnessLogger(int totalGenerations, int totalRuns, WeightedFitness bestEvaluator, WeightedFitness userTasteEvaluator) {
        this(totalGenerations, totalRuns);
        this.allFnLoggers.add(new SingleFitnessLogger(totalGenerations, totalRuns, bestEvaluator));
        this.bestLogger = new BestFitnessLogger(totalGenerations, totalRuns, bestEvaluator);
        this.userTasteLogger = new BestFitnessLogger(totalGenerations, totalRuns, userTasteEvaluator);
        this.userTasteLogger.setSuffix("userTaste");
    }

    public void addFitnessLogger(Fitness fitness) {
        this.allFnLoggers.add(new SingleFitnessLogger(this.totalGenerations, this.totalRuns, fitness));
    }

    public void reset() {
        this.allFnLoggers.clear();
        if (this.bestLogger != null) {
            this.bestLogger.reset();
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.reset();
        }
    }

    public void storeGeneration(int currGeneration, int currRun, GeneticAlgorithmTrainerGeneric gTrainer) {
        for (SingleFitnessLogger sfl : this.allFnLoggers) {
            sfl.storeGeneration(currGeneration, currRun, gTrainer);
        }
        if (this.bestLogger != null) {
            this.bestLogger.storeGeneration(currGeneration, currRun, gTrainer);
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.storeGeneration(currGeneration, currRun, gTrainer);
        }
    }

    public void writeRun(int run, String fileBase) {
        for (SingleFitnessLogger sfl : this.allFnLoggers) {
            sfl.writeRun(run, fileBase);
        }
        if (this.bestLogger != null) {
            this.bestLogger.writeRun(run, fileBase);
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.writeRun(run, fileBase);
        }
    }

    public void writeAllProgress(String fileBase) {
        for (SingleFitnessLogger sfl : this.allFnLoggers) {
            sfl.writeAllProgress(fileBase);
        }
        if (this.bestLogger != null) {
            this.bestLogger.writeAllProgress(fileBase);
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.writeAllProgress(fileBase);
        }
    }
}

