/*
 * Decompiled with CFR 0.152.
 */
package genetic.logger;

import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import java.util.Collections;
import java.util.Vector;
import util.logs.Writer;
import util.statics.LogManager;
import util.statics.StatisticUtils;

public class DiversityLogger {
    Fitness fCheck = null;
    Fitness currFitness;
    DifferenceFitness currDifference;
    Vector<double[]> minDiversities;
    Vector<double[]> maxDiversities;
    Vector<double[]> avgDiversities;
    Vector<double[]> medianDiversities;
    Vector<double[]> point25Diversities;
    Vector<double[]> point75Diversities;

    public DiversityLogger(int totalGenerations, int totalRuns, Fitness fn) {
        this.currFitness = fn;
        this.init(totalGenerations, totalRuns);
    }

    public DiversityLogger(int totalGenerations, int totalRuns, DifferenceFitness dfn) {
        this.currDifference = dfn;
        this.init(totalGenerations, totalRuns);
    }

    public DiversityLogger(int totalGenerations, int totalRuns, Fitness fn, Fitness fCheck) {
        this.fCheck = fCheck;
        this.currFitness = fn;
        this.init(totalGenerations, totalRuns);
    }

    public DiversityLogger(int totalGenerations, int totalRuns, DifferenceFitness dfn, Fitness fCheck) {
        this.fCheck = fCheck;
        this.currDifference = dfn;
        this.init(totalGenerations, totalRuns);
    }

    protected void init(int totalGenerations, int totalRuns) {
        this.minDiversities = new Vector();
        this.maxDiversities = new Vector();
        this.avgDiversities = new Vector();
        this.medianDiversities = new Vector();
        this.point25Diversities = new Vector();
        this.point75Diversities = new Vector();
        for (int i = 0; i < totalGenerations; ++i) {
            this.minDiversities.add(new double[totalRuns]);
            this.maxDiversities.add(new double[totalRuns]);
            this.avgDiversities.add(new double[totalRuns]);
            this.medianDiversities.add(new double[totalRuns]);
            this.point25Diversities.add(new double[totalRuns]);
            this.point75Diversities.add(new double[totalRuns]);
        }
    }

    public void storeGeneration(int currGeneration, int currRun, GeneticAlgorithmTrainerGeneric gTrainer) {
        Vector<Float> differences = new Vector<Float>();
        int tc = 0;
        float cf = 0.0f;
        GeneticAlgorithm population = gTrainer.getPopulation();
        int populationSize = population.getPopulationSize();
        for (int i = 0; i < populationSize; ++i) {
            if (this.fCheck != null && this.fCheck.evaluate(population.getGene(i).getPhenotype()) != 0.0) continue;
            if (this.currFitness != null) {
                float fVal = (float)this.currFitness.evaluate(population.getGene(i).getPhenotype());
                for (int j = 0; j < populationSize; ++j) {
                    if (j == i || this.fCheck != null && this.fCheck.evaluate(population.getGene(j).getPhenotype()) != 0.0) continue;
                    float tVal = (float)this.currFitness.evaluate(population.getGene(j).getPhenotype());
                    float currDiff = Math.abs(tVal - fVal);
                    differences.add(Float.valueOf(currDiff));
                    cf += currDiff;
                    ++tc;
                }
                continue;
            }
            if (this.currDifference == null) continue;
            for (int j = 0; j < populationSize; ++j) {
                if (j == i || this.fCheck != null && this.fCheck.evaluate(population.getGene(j).getPhenotype()) != 0.0) continue;
                float currDiff = (float)this.currDifference.evaluate(population.getGene(i).getPhenotype(), population.getGene(j).getPhenotype());
                differences.add(Float.valueOf(currDiff));
                cf += currDiff;
                ++tc;
            }
        }
        Collections.sort(differences);
        if (populationSize == 0) {
            this.minDiversities.get((int)currGeneration)[currRun - 1] = -1.0;
            this.maxDiversities.get((int)currGeneration)[currRun - 1] = -1.0;
            this.medianDiversities.get((int)currGeneration)[currRun - 1] = -1.0;
            this.point25Diversities.get((int)currGeneration)[currRun - 1] = -1.0;
            this.point75Diversities.get((int)currGeneration)[currRun - 1] = -1.0;
            this.avgDiversities.get((int)currGeneration)[currRun - 1] = -1.0;
        } else if (differences.isEmpty()) {
            this.minDiversities.get((int)currGeneration)[currRun - 1] = -0.5;
            this.minDiversities.get((int)currGeneration)[currRun - 1] = -0.5;
            this.maxDiversities.get((int)currGeneration)[currRun - 1] = -0.5;
            this.medianDiversities.get((int)currGeneration)[currRun - 1] = -0.5;
            this.point25Diversities.get((int)currGeneration)[currRun - 1] = -0.5;
            this.point75Diversities.get((int)currGeneration)[currRun - 1] = -0.5;
            this.avgDiversities.get((int)currGeneration)[currRun - 1] = -0.5;
        } else {
            this.minDiversities.get((int)currGeneration)[currRun - 1] = ((Float)differences.firstElement()).floatValue();
            this.maxDiversities.get((int)currGeneration)[currRun - 1] = ((Float)differences.lastElement()).floatValue();
            this.medianDiversities.get((int)currGeneration)[currRun - 1] = ((Float)differences.get((int)Math.floor(differences.size() / 2))).floatValue();
            this.point25Diversities.get((int)currGeneration)[currRun - 1] = ((Float)differences.get((int)Math.floor(differences.size() / 4))).floatValue();
            this.point75Diversities.get((int)currGeneration)[currRun - 1] = ((Float)differences.get((int)Math.floor(differences.size() * 3 / 4))).floatValue();
            this.avgDiversities.get((int)currGeneration)[currRun - 1] = cf / (float)tc;
        }
    }

    public void writeRun(int run, String fileBase) {
        if (run < 1 || run > this.maxDiversities.size()) {
            LogManager.writeError("Error", this, "run to write out of bounds");
            return;
        }
        --run;
        String result_totalFitnessProgress = "";
        result_totalFitnessProgress = result_totalFitnessProgress + "maxDiversity;minDiversity;avgDiversity;medianDiversity;p25Diversity;p75Diversity\n";
        for (int i = 0; i < this.maxDiversities.size(); ++i) {
            result_totalFitnessProgress = result_totalFitnessProgress + this.maxDiversities.get(i)[run] + ";" + this.minDiversities.get(i)[run] + ";";
            result_totalFitnessProgress = result_totalFitnessProgress + this.avgDiversities.get(i)[run] + ";" + this.medianDiversities.get(i)[run] + ";";
            result_totalFitnessProgress = result_totalFitnessProgress + this.point25Diversities.get(i)[run] + ";" + this.point75Diversities.get(i)[run] + "\n";
        }
        String filename = "";
        if (this.currFitness != null) {
            filename = fileBase + (run + 1) + "/" + this.currFitness.getLabel() + "-totalDiversityProgress.csv";
        } else if (this.currDifference != null) {
            filename = fileBase + (run + 1) + "/" + this.currDifference.getLabel() + "-totalDiversityProgress.csv";
        }
        Writer totalFitnessProgress = new Writer(filename);
        totalFitnessProgress.write(result_totalFitnessProgress);
    }

    public void writeAllProgress(String fileBase) {
        int i;
        String result_totalFitnessProgress = "";
        String result_allAverageFitnesses = "";
        String result_allMedianFitnesses = "";
        String result_allMaximumFitnesses = "";
        String result_allMinimumFitnesses = "";
        String result_allP25Fitnesses = "";
        String result_allP75Fitnesses = "";
        int totalRuns = this.maxDiversities.get(0).length;
        int intervals = this.maxDiversities.size();
        double[] maxFitnesses_avg = new double[intervals];
        double[] minFitnesses_avg = new double[intervals];
        double[] avgFitnesses_avg = new double[intervals];
        double[] medFitnesses_avg = new double[intervals];
        double[] p25Fitnesses_avg = new double[intervals];
        double[] p75Fitnesses_avg = new double[intervals];
        double[] maxFitnesses_stdev = new double[intervals];
        double[] minFitnesses_stdev = new double[intervals];
        double[] avgFitnesses_stdev = new double[intervals];
        double[] medFitnesses_stdev = new double[intervals];
        double[] p25Fitnesses_stdev = new double[intervals];
        double[] p75Fitnesses_stdev = new double[intervals];
        result_totalFitnessProgress = result_totalFitnessProgress + "maxDiversity;minDiversity;avgDiversity;medianDiversity;p25Diversity;p75Diversity;";
        result_totalFitnessProgress = result_totalFitnessProgress + "maxDiversity_stdev;minDiversity_stdev;avgDiversity_stdev;medianDiversity_stdev;p25Diversity_stdev;p75Diversity_stdev\n";
        for (i = 0; i < intervals; ++i) {
            maxFitnesses_stdev[i] = StatisticUtils.standardDeviation(this.maxDiversities.get(i));
            minFitnesses_stdev[i] = StatisticUtils.standardDeviation(this.minDiversities.get(i));
            avgFitnesses_stdev[i] = StatisticUtils.standardDeviation(this.avgDiversities.get(i));
            medFitnesses_stdev[i] = StatisticUtils.standardDeviation(this.medianDiversities.get(i));
            p25Fitnesses_stdev[i] = StatisticUtils.standardDeviation(this.point25Diversities.get(i));
            p75Fitnesses_stdev[i] = StatisticUtils.standardDeviation(this.point75Diversities.get(i));
            maxFitnesses_avg[i] = StatisticUtils.average(this.maxDiversities.get(i));
            minFitnesses_avg[i] = StatisticUtils.average(this.minDiversities.get(i));
            avgFitnesses_avg[i] = StatisticUtils.average(this.avgDiversities.get(i));
            medFitnesses_avg[i] = StatisticUtils.average(this.medianDiversities.get(i));
            p25Fitnesses_avg[i] = StatisticUtils.average(this.point25Diversities.get(i));
            p75Fitnesses_avg[i] = StatisticUtils.average(this.point75Diversities.get(i));
            result_totalFitnessProgress = result_totalFitnessProgress + maxFitnesses_avg[i] + ";" + minFitnesses_avg[i] + ";" + avgFitnesses_avg[i] + ";" + medFitnesses_avg[i] + ";" + p25Fitnesses_avg[i] + ";" + p75Fitnesses_avg[i] + ";";
            result_totalFitnessProgress = result_totalFitnessProgress + maxFitnesses_stdev[i] + ";" + minFitnesses_stdev[i] + ";" + avgFitnesses_stdev[i] + ";" + medFitnesses_stdev[i] + ";" + p25Fitnesses_stdev[i] + ";" + p75Fitnesses_stdev[i] + "\n";
        }
        for (i = 0; i < intervals; ++i) {
            String maxPrintout = "";
            String minPrintout = "";
            String avgPrintout = "";
            String medPrintout = "";
            String p25Printout = "";
            String p75Printout = "";
            for (int j = 0; j < totalRuns; ++j) {
                maxPrintout = maxPrintout + this.maxDiversities.get(i)[j];
                minPrintout = minPrintout + this.minDiversities.get(i)[j];
                avgPrintout = avgPrintout + this.avgDiversities.get(i)[j];
                medPrintout = medPrintout + this.medianDiversities.get(i)[j];
                p25Printout = p25Printout + this.point25Diversities.get(i)[j];
                p75Printout = p75Printout + this.point75Diversities.get(i)[j];
                if (j >= totalRuns - 1) continue;
                maxPrintout = maxPrintout + ";";
                minPrintout = minPrintout + ";";
                avgPrintout = avgPrintout + ";";
                medPrintout = medPrintout + ";";
                p25Printout = p25Printout + ";";
                p75Printout = p75Printout + ";";
            }
            result_allMaximumFitnesses = result_allMaximumFitnesses + maxPrintout + "\n";
            result_allMinimumFitnesses = result_allMinimumFitnesses + minPrintout + "\n";
            result_allAverageFitnesses = result_allAverageFitnesses + avgPrintout + "\n";
            result_allMedianFitnesses = result_allMedianFitnesses + medPrintout + "\n";
            result_allP25Fitnesses = result_allP25Fitnesses + p25Printout + "\n";
            result_allP75Fitnesses = result_allP75Fitnesses + p75Printout + "\n";
        }
        String label = this.currFitness != null ? this.currFitness.getLabel() : this.currDifference.getLabel();
        Writer totalFitnessProgress = new Writer(fileBase + label + "-totalDiversityProgress.csv");
        totalFitnessProgress.write(result_totalFitnessProgress);
        Writer allMaxFitnesses = new Writer(fileBase + label + "-allMaxDiversities.csv");
        allMaxFitnesses.write(result_allMaximumFitnesses);
        Writer allMinFitnesses = new Writer(fileBase + label + "-allMinDiversities.csv");
        allMinFitnesses.write(result_allMinimumFitnesses);
        Writer allAverageFitnesses = new Writer(fileBase + label + "-allAvgDiversities.csv");
        allAverageFitnesses.write(result_allAverageFitnesses);
        Writer allMedianFitnesses = new Writer(fileBase + label + "-allMedianDiversities.csv");
        allMedianFitnesses.write(result_allMedianFitnesses);
        Writer allP25Fitnesses = new Writer(fileBase + label + "-allP25Diversities.csv");
        allP25Fitnesses.write(result_allP25Fitnesses);
        Writer allP75Fitnesses = new Writer(fileBase + label + "-allP75Diversities.csv");
        allP75Fitnesses.write(result_allP75Fitnesses);
    }
}

