/*
 * Decompiled with CFR 0.152.
 */
package genetic.logger;

import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.fitness.Fitness;
import java.util.Vector;
import util.logs.Writer;
import util.statics.LogManager;
import util.statics.StatisticUtils;

public class SingleFitnessLogger {
    Vector<double[]> maxFitnesses;
    Vector<double[]> avgFitnesses;
    Fitness currFitness;
    Fitness fCheck = null;

    public SingleFitnessLogger(int totalGenerations, int totalRuns, Fitness fn) {
        this(totalGenerations, totalRuns, fn, null);
    }

    public SingleFitnessLogger(int totalGenerations, int totalRuns, Fitness fn, Fitness fCheck) {
        this.currFitness = fn;
        this.fCheck = fCheck;
        this.maxFitnesses = new Vector();
        this.avgFitnesses = new Vector();
        for (int i = 0; i < totalGenerations; ++i) {
            this.maxFitnesses.add(new double[totalRuns]);
            this.avgFitnesses.add(new double[totalRuns]);
        }
    }

    public Fitness getFitness() {
        return this.currFitness;
    }

    public void reset() {
        this.maxFitnesses.clear();
        this.avgFitnesses.clear();
    }

    public void storeGeneration(int currGeneration, int currRun, GeneticAlgorithmTrainerGeneric gTrainer) {
        this.maxFitnesses.get((int)currGeneration)[currRun - 1] = -1.7976931348623157E308;
        this.avgFitnesses.get((int)currGeneration)[currRun - 1] = 0.0;
        Vector<Double> fChecks = this.fCheck == null ? null : gTrainer.evaluateParentsCustom(this.fCheck);
        int fCount = 0;
        for (int m = 0; m < gTrainer.getPopulation().getPopulationSize(); ++m) {
            if (fChecks == null) {
                ++fCount;
            } else if (fChecks.get(m) == 0.0) {
                ++fCount;
            }
            if (fChecks != null && fChecks.get(m) != 0.0) continue;
            double currValue = this.currFitness.evaluate(gTrainer.getPopulation().getGene(m).getPhenotype());
            double[] dArray = this.avgFitnesses.get(currGeneration);
            int n = currRun - 1;
            dArray[n] = dArray[n] + currValue;
            if (!(currValue > this.maxFitnesses.get(currGeneration)[currRun - 1])) continue;
            this.maxFitnesses.get((int)currGeneration)[currRun - 1] = currValue;
        }
        this.avgFitnesses.get((int)currGeneration)[currRun - 1] = fCount == 0 ? -1.0 : this.avgFitnesses.get(currGeneration)[currRun - 1] / (double)fCount;
    }

    public void writeRun(int run, String fileBase) {
        if (run < 1 || run > this.maxFitnesses.size()) {
            LogManager.writeError("Error", this, "run to write out of bounds");
            return;
        }
        --run;
        String result_totalFitnessProgress = "";
        result_totalFitnessProgress = result_totalFitnessProgress + "maximum fitness;average fitness\n";
        for (int i = 0; i < this.maxFitnesses.size(); ++i) {
            result_totalFitnessProgress = result_totalFitnessProgress + this.maxFitnesses.get(i)[run] + ";" + this.avgFitnesses.get(i)[run] + "\n";
        }
        Writer totalFitnessProgress = new Writer(fileBase + (run + 1) + "/" + this.currFitness.getLabel() + "-totalFitnessProgress.csv");
        totalFitnessProgress.write(result_totalFitnessProgress);
    }

    public void writeAllProgress(String fileBase) {
        int i;
        String result_totalFitnessProgress = "";
        String result_allAverageFitnesses = "";
        String result_allMaximumFitnesses = "";
        int totalRuns = this.maxFitnesses.get(0).length;
        int intervals = this.maxFitnesses.size();
        double[] maxFitnesses_avg = new double[intervals];
        double[] avgFitnesses_avg = new double[intervals];
        double[] maxFitnesses_stdev = new double[intervals];
        double[] avgFitnesses_stdev = new double[intervals];
        result_totalFitnessProgress = result_totalFitnessProgress + "maximum fitness;maximum fitness stdev;average fitness;average fitness stdev\n";
        for (i = 0; i < intervals; ++i) {
            maxFitnesses_stdev[i] = StatisticUtils.standardDeviation(this.maxFitnesses.get(i));
            avgFitnesses_stdev[i] = StatisticUtils.standardDeviation(this.avgFitnesses.get(i));
            double maxTotal = 0.0;
            double avgTotal = 0.0;
            for (int j = 0; j < totalRuns; ++j) {
                maxTotal += this.maxFitnesses.get(i)[j];
                avgTotal += this.avgFitnesses.get(i)[j];
            }
            avgFitnesses_avg[i] = avgTotal / (double)totalRuns;
            maxFitnesses_avg[i] = maxTotal / (double)totalRuns;
            result_totalFitnessProgress = result_totalFitnessProgress + maxFitnesses_avg[i] + ";" + maxFitnesses_stdev[i] + ";" + avgFitnesses_avg[i] + ";" + avgFitnesses_stdev[i] + "\n";
        }
        for (i = 0; i < intervals; ++i) {
            String maxPrintout = "";
            String avgPrintout = "";
            for (int j = 0; j < totalRuns; ++j) {
                maxPrintout = maxPrintout + this.maxFitnesses.get(i)[j];
                avgPrintout = avgPrintout + this.avgFitnesses.get(i)[j];
                if (j >= totalRuns - 1) continue;
                maxPrintout = maxPrintout + ";";
                avgPrintout = avgPrintout + ";";
            }
            result_allMaximumFitnesses = result_allMaximumFitnesses + maxPrintout + "\n";
            result_allAverageFitnesses = result_allAverageFitnesses + avgPrintout + "\n";
        }
        Writer totalFitnessProgress = new Writer(fileBase + this.currFitness.getLabel() + "-totalFitnessProgress.csv");
        totalFitnessProgress.write(result_totalFitnessProgress);
        Writer allAverageFitnesses = new Writer(fileBase + this.currFitness.getLabel() + "-allAverageFitnesses.csv");
        allAverageFitnesses.write(result_allAverageFitnesses);
        Writer allMaximumFitnesses = new Writer(fileBase + this.currFitness.getLabel() + "-allMaximumFitnesses.csv");
        allMaximumFitnesses.write(result_allMaximumFitnesses);
    }
}

